/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.corefoundation;

import com.sun.jna.Native;
import net.pms.platform.jna.ArrayByReference;
import net.pms.platform.mac.corefoundation.CoreFoundation;

public class CFTypeArrayRef
extends ArrayByReference<CoreFoundation.CFTypeRef> {
    protected CoreFoundation.CFTypeRef[] array;

    public CFTypeArrayRef() {
    }

    public CFTypeArrayRef(long size) {
        this.setSize((long)Native.POINTER_SIZE * size, 0L);
    }

    public CFTypeArrayRef(CoreFoundation.CFTypeRef[] cfTypeRefs) {
        this.setArray(cfTypeRefs, 0L);
    }

    public void setSize(long size) {
        if (size != this.getSize()) {
            this.array = null;
            super.setSize(size, 100L);
        }
    }

    public void setArray(CoreFoundation.CFTypeRef[] cfTypeRefs) {
        this.setArray(cfTypeRefs, 100L);
    }

    public void setArray(CoreFoundation.CFTypeRef[] cfTypeRefs, long reAllocateThreshold) {
        super.setArray(cfTypeRefs, reAllocateThreshold);
        if (this.array == null || cfTypeRefs.length != this.array.length) {
            this.array = new CoreFoundation.CFTypeRef[cfTypeRefs.length];
        }
        if (cfTypeRefs.length > 0) {
            System.arraycopy(cfTypeRefs, 0, this.array, 0, cfTypeRefs.length);
        }
    }

    public CoreFoundation.CFTypeRef[] getArray() {
        if (this.array == null) {
            this.array = (CoreFoundation.CFTypeRef[])super.getArray();
        }
        return this.array;
    }

    @Override
    public int getElementSize() {
        return Native.POINTER_SIZE;
    }

    protected CoreFoundation.CFTypeRef[] getElements() {
        CoreFoundation.CFTypeRef[] result = new CoreFoundation.CFTypeRef[(int)this.size];
        int i = 0;
        while ((long)i < this.size) {
            result[i] = new CoreFoundation.CFTypeRef(this.getPointer().getPointer(i * this.getElementSize()));
            ++i;
        }
        return result;
    }

    protected void setElements(CoreFoundation.CFTypeRef[] array) {
        int i = 0;
        while ((long)i < this.size) {
            this.getPointer().setPointer(i * this.getElementSize(), array[i].getPointer());
            ++i;
        }
    }

    @Override
    public String toString() {
        if (this.array == null) {
            this.array = (CoreFoundation.CFTypeRef[])super.getArray();
            if (this.array == null) {
                return "null";
            }
        }
        if (this.size == 0L || this.array.length == 0) {
            return this.getClass().getSimpleName() + ": empty";
        }
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(": [");
        for (int i = 0; (long)i < this.size && i < this.array.length; ++i) {
            sb.append(this.array[i].toString());
            if ((long)i >= this.size - 1L) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

