/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.pms.platform.PlatformProgramPaths;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FFmpegProgramInfo;
import net.pms.util.FileUtil;
import net.pms.util.ProgramExecutableType;

public class MacProgramPaths
extends PlatformProgramPaths {
    private final FFmpegProgramInfo ffmpegInfo;
    private final ExternalProgramInfo mPlayerInfo;
    private final ExternalProgramInfo vlcInfo;
    private final ExternalProgramInfo mEncoderInfo;
    private final ExternalProgramInfo tsMuxeRInfo;
    private final ExternalProgramInfo flacInfo;
    private final ExternalProgramInfo dcRawInfo;
    private final ExternalProgramInfo youtubeDlInfo;

    public MacProgramPaths() {
        Path vlc;
        Path ffmpeg = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            ffmpeg = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("ffmpeg");
        }
        if (ffmpeg == null || !Files.exists(ffmpeg, new LinkOption[0])) {
            ffmpeg = PLATFORM_BINARIES_FOLDER.resolve("ffmpeg");
        }
        this.ffmpegInfo = new FFmpegProgramInfo("FFmpeg", ProgramExecutableType.BUNDLED);
        this.ffmpegInfo.setPath(ProgramExecutableType.BUNDLED, ffmpeg);
        ffmpeg = FileUtil.findExecutableInOSPath(Paths.get("ffmpeg", new String[0]));
        if (ffmpeg != null) {
            this.ffmpegInfo.setPath(ProgramExecutableType.INSTALLED, ffmpeg);
        }
        Path mPlayer = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            mPlayer = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("mplayer");
        }
        if (mPlayer == null || !Files.exists(mPlayer, new LinkOption[0])) {
            mPlayer = PLATFORM_BINARIES_FOLDER.resolve("mplayer");
        }
        this.mPlayerInfo = new ExternalProgramInfo("MPlayer", ProgramExecutableType.BUNDLED);
        this.mPlayerInfo.setPath(ProgramExecutableType.BUNDLED, mPlayer);
        mPlayer = FileUtil.findExecutableInOSPath(Paths.get("mplayer", new String[0]));
        if (mPlayer != null) {
            this.mPlayerInfo.setPath(ProgramExecutableType.INSTALLED, mPlayer);
        }
        if (!Files.exists(vlc = Paths.get("/Applications/VLC.app/Contents/MacOS/VLC", new String[0]), new LinkOption[0])) {
            vlc = FileUtil.findExecutableInOSPath(Paths.get("VLC", new String[0]));
        }
        if (vlc != null) {
            this.vlcInfo = new ExternalProgramInfo("VLC", ProgramExecutableType.INSTALLED);
            this.vlcInfo.setPath(ProgramExecutableType.INSTALLED, vlc);
        } else {
            this.vlcInfo = new ExternalProgramInfo("VLC", null);
        }
        Path mEncoder = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            mEncoder = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("mencoder");
        }
        if (mEncoder == null || !Files.exists(mEncoder, new LinkOption[0])) {
            mEncoder = PLATFORM_BINARIES_FOLDER.resolve("mencoder");
        }
        this.mEncoderInfo = new ExternalProgramInfo("MEncoder", ProgramExecutableType.BUNDLED);
        this.mEncoderInfo.setPath(ProgramExecutableType.BUNDLED, mEncoder);
        mEncoder = FileUtil.findExecutableInOSPath(Paths.get("mencoder", new String[0]));
        if (mEncoder != null) {
            this.mEncoderInfo.setPath(ProgramExecutableType.INSTALLED, mEncoder);
        }
        Path tsMuxeR = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            tsMuxeR = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("tsMuxeR");
        }
        if (tsMuxeR == null || !Files.exists(tsMuxeR, new LinkOption[0])) {
            tsMuxeR = PLATFORM_BINARIES_FOLDER.resolve("tsMuxeR");
        }
        this.tsMuxeRInfo = new ExternalProgramInfo("tsMuxeR", ProgramExecutableType.BUNDLED);
        this.tsMuxeRInfo.setPath(ProgramExecutableType.BUNDLED, tsMuxeR);
        tsMuxeR = Paths.get("/Applications/tsMuxerGUI.app/Contents/MacOS/tsMuxeR", new String[0]);
        if (!Files.exists(tsMuxeR, new LinkOption[0])) {
            tsMuxeR = FileUtil.findExecutableInOSPath(Paths.get("tsMuxeR", new String[0]));
        }
        if (tsMuxeR != null) {
            this.tsMuxeRInfo.setPath(ProgramExecutableType.INSTALLED, tsMuxeR);
        }
        Path flac = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            flac = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("flac");
        }
        if (flac == null || !Files.exists(flac, new LinkOption[0])) {
            flac = PLATFORM_BINARIES_FOLDER.resolve("flac");
        }
        this.flacInfo = new ExternalProgramInfo("FLAC", ProgramExecutableType.BUNDLED);
        this.flacInfo.setPath(ProgramExecutableType.BUNDLED, flac);
        flac = FileUtil.findExecutableInOSPath(Paths.get("flac", new String[0]));
        if (flac != null) {
            this.flacInfo.setPath(ProgramExecutableType.INSTALLED, flac);
        }
        Path dcRaw = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            dcRaw = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("dcraw");
        }
        if (dcRaw == null || !Files.exists(dcRaw, new LinkOption[0])) {
            dcRaw = PLATFORM_BINARIES_FOLDER.resolve("dcraw");
        }
        this.dcRawInfo = new ExternalProgramInfo("DCRaw", ProgramExecutableType.BUNDLED);
        this.dcRawInfo.setPath(ProgramExecutableType.BUNDLED, dcRaw);
        dcRaw = FileUtil.findExecutableInOSPath(Paths.get("dcraw", new String[0]));
        if (dcRaw != null) {
            this.dcRawInfo.setPath(ProgramExecutableType.INSTALLED, dcRaw);
        }
        Path youtubeDl = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            youtubeDl = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("youtube-dl");
        }
        if (youtubeDl == null || !Files.exists(youtubeDl, new LinkOption[0])) {
            youtubeDl = PLATFORM_BINARIES_FOLDER.resolve("youtube-dl");
        }
        this.youtubeDlInfo = new ExternalProgramInfo("youtube-dl", ProgramExecutableType.BUNDLED);
        this.youtubeDlInfo.setPath(ProgramExecutableType.BUNDLED, youtubeDl);
        youtubeDl = FileUtil.findExecutableInOSPath(Paths.get("youtube-dl", new String[0]));
        if (youtubeDl != null) {
            this.flacInfo.setPath(ProgramExecutableType.INSTALLED, youtubeDl);
        }
    }

    @Override
    public FFmpegProgramInfo getFFmpeg() {
        return this.ffmpegInfo;
    }

    @Override
    public ExternalProgramInfo getMPlayer() {
        return this.mPlayerInfo;
    }

    @Override
    public ExternalProgramInfo getVLC() {
        return this.vlcInfo;
    }

    @Override
    public ExternalProgramInfo getMEncoder() {
        return this.mEncoderInfo;
    }

    @Override
    public ExternalProgramInfo getTsMuxeR() {
        return this.tsMuxeRInfo;
    }

    @Override
    public ExternalProgramInfo getFLAC() {
        return this.flacInfo;
    }

    @Override
    public ExternalProgramInfo getDCRaw() {
        return this.dcRawInfo;
    }

    @Override
    public ExternalProgramInfo getAviSynth() {
        return null;
    }

    @Override
    public ExternalProgramInfo getInterFrame() {
        return null;
    }

    @Override
    public ExternalProgramInfo getFFMS2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getDirectShowSource() {
        return null;
    }

    @Override
    public ExternalProgramInfo getMvtools2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getDepan() {
        return null;
    }

    @Override
    public ExternalProgramInfo getMasktools2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getCropResize() {
        return null;
    }

    @Override
    public ExternalProgramInfo getConvert2dTo3d() {
        return null;
    }

    @Override
    public ExternalProgramInfo getYoutubeDl() {
        return this.youtubeDlInfo;
    }
}

