/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.pms.io.StreamGobbler;
import net.pms.platform.PlatformUtils;
import net.pms.platform.linux.FreedesktopTrash;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.UMSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxUtils
extends PlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxUtils.class);
    private static final int TERM_TIMEOUT = 10000;
    private static final int ALRM_TIMEOUT = 2000;

    @Override
    public void moveToTrash(File file) throws IOException {
        try {
            FreedesktopTrash.moveToTrash(file);
        }
        catch (FileUtil.InvalidFileSystemException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdmin() {
        Object object = IS_ADMIN_LOCK;
        synchronized (object) {
            if (isAdmin != null) {
                return isAdmin;
            }
            try {
                String exitLine;
                int exitValue;
                String command = "id -Gn";
                LOGGER.trace("isAdmin: Executing \"id -Gn\"");
                Process p = Runtime.getRuntime().exec(new String[]{"id", "-Gn"});
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.US_ASCII);
                try (BufferedReader br = new BufferedReader(isr);){
                    p.waitFor();
                    exitValue = p.exitValue();
                    exitLine = br.readLine();
                }
                if (exitValue != 0 || exitLine == null || exitLine.isEmpty()) {
                    LOGGER.error("Could not determine root privileges, \"{}\" ended with exit code: {}", (Object)"id -Gn", (Object)exitValue);
                    isAdmin = false;
                    return false;
                }
                LOGGER.trace("isAdmin: \"{}\" returned {}", (Object)"id -Gn", (Object)exitLine);
                if (exitLine.matches(".*\\broot\\b.*")) {
                    LOGGER.trace("isAdmin: UMS has root privileges");
                    isAdmin = true;
                    return true;
                }
                LOGGER.trace("isAdmin: UMS does not have root privileges");
                isAdmin = false;
                return false;
            }
            catch (IOException e) {
                LOGGER.error("An error prevented UMS from checking Linux permissions: {}", (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            isAdmin = false;
            return false;
        }
    }

    @Override
    public String getDefaultFontPath() {
        String font = LinuxUtils.getAbsolutePath("/usr/share/fonts/truetype/msttcorefonts/", "Arial.ttf");
        if (font == null) {
            font = LinuxUtils.getAbsolutePath("/usr/share/fonts/truetype/ttf-bitstream-veras/", "Vera.ttf");
        }
        if (font == null) {
            font = LinuxUtils.getAbsolutePath("/usr/share/fonts/truetype/ttf-dejavu/", "DejaVuSans.ttf");
        }
        return font;
    }

    @Override
    public String[] getShutdownCommand() {
        return new String[]{"shutdown", "-h", "now"};
    }

    @Override
    public void destroyProcess(Process p) {
        if (p != null) {
            long pid = ProcessUtil.getProcessId(p);
            if (pid != 0L) {
                LOGGER.trace("Killing the Unix process: " + pid);
                Runnable r = () -> {
                    block2: {
                        UMSUtils.sleep(10000);
                        try {
                            p.exitValue();
                        }
                        catch (IllegalThreadStateException itse) {
                            if (LinuxUtils.kill(pid, 14)) break block2;
                            UMSUtils.sleep(2000);
                            LinuxUtils.kill(pid, 9);
                        }
                    }
                };
                Thread failsafe = new Thread(r, "Process Destroyer");
                failsafe.start();
            }
            p.destroy();
        }
    }

    private static boolean kill(long pid, int signal) {
        boolean killed = false;
        LOGGER.warn("Sending kill -" + signal + " to the Unix process: " + pid);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("kill", "-" + signal, Long.toString(pid));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StreamGobbler.consume(process.getInputStream(), true);
            int exit = ProcessUtil.waitFor(process);
            if (exit == 0) {
                killed = true;
                LOGGER.debug("Successfully sent kill -" + signal + " to the Unix process: " + pid);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error calling: kill -" + signal + " " + pid, e);
        }
        return killed;
    }
}

