/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.linux;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.pms.platform.PlatformProgramPaths;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FFmpegProgramInfo;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import net.pms.util.ProgramExecutableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxProgramPaths
extends PlatformProgramPaths {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxProgramPaths.class);
    private final FFmpegProgramInfo ffmpegInfo;
    private final ExternalProgramInfo mPlayerInfo;
    private final ExternalProgramInfo vlcInfo;
    private final ExternalProgramInfo mEncoderInfo;
    private final ExternalProgramInfo tsMuxeRInfo;
    private final ExternalProgramInfo flacInfo;
    private final ExternalProgramInfo dcRawInfo;
    private final ExternalProgramInfo youtubeDlInfo;

    public LinuxProgramPaths() {
        Path flac;
        Path ffmpeg = FileUtil.findExecutableInOSPath(Paths.get("ffmpeg", new String[0]));
        this.ffmpegInfo = new FFmpegProgramInfo("FFmpeg", ProgramExecutableType.INSTALLED);
        if (ffmpeg != null) {
            this.ffmpegInfo.setPath(ProgramExecutableType.INSTALLED, ffmpeg);
        } else {
            ffmpeg = PLATFORM_BINARIES_FOLDER.resolve("ffmpeg");
            this.ffmpegInfo.setPath(ProgramExecutableType.BUNDLED, ffmpeg);
            this.ffmpegInfo.setDefault(ProgramExecutableType.BUNDLED);
            try {
                if (!new FilePermissions(ffmpeg, new LinkOption[0]).isExecutable()) {
                    LOGGER.trace("Insufficient permission to executable \"{}\"", (Object)ffmpeg);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.trace("Executable \"{}\" not found: {}", (Object)ffmpeg, (Object)e.getMessage());
            }
        }
        Path mPlayer = FileUtil.findExecutableInOSPath(Paths.get("mplayer", new String[0]));
        if (mPlayer != null) {
            this.mPlayerInfo = new ExternalProgramInfo("MPlayer", ProgramExecutableType.INSTALLED);
            this.mPlayerInfo.setPath(ProgramExecutableType.INSTALLED, mPlayer);
        } else {
            this.mPlayerInfo = new ExternalProgramInfo("MPlayer", null);
        }
        Path vlc = FileUtil.findExecutableInOSPath(Paths.get("vlc", new String[0]));
        if (vlc != null) {
            this.vlcInfo = new ExternalProgramInfo("VLC", ProgramExecutableType.INSTALLED);
            this.vlcInfo.setPath(ProgramExecutableType.INSTALLED, vlc);
        } else {
            this.vlcInfo = new ExternalProgramInfo("VLC", null);
        }
        Path mEncoder = FileUtil.findExecutableInOSPath(Paths.get("mencoder", new String[0]));
        if (mEncoder != null) {
            this.mEncoderInfo = new ExternalProgramInfo("MEncoder", ProgramExecutableType.INSTALLED);
            this.mEncoderInfo.setPath(ProgramExecutableType.INSTALLED, mEncoder);
        } else {
            this.mEncoderInfo = new ExternalProgramInfo("MEncoder", null);
        }
        Path tsMuxeR = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            tsMuxeR = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("tsMuxeR");
        }
        if (tsMuxeR == null || !Files.exists(tsMuxeR, new LinkOption[0])) {
            tsMuxeR = PLATFORM_BINARIES_FOLDER.resolve("tsMuxeR");
        }
        this.tsMuxeRInfo = new ExternalProgramInfo("tsMuxeR", ProgramExecutableType.BUNDLED);
        this.tsMuxeRInfo.setPath(ProgramExecutableType.BUNDLED, tsMuxeR);
        tsMuxeR = FileUtil.findExecutableInOSPath(Paths.get("tsMuxeR", new String[0]));
        if (tsMuxeR != null) {
            this.tsMuxeRInfo.setPath(ProgramExecutableType.INSTALLED, tsMuxeR);
        }
        if ((flac = FileUtil.findExecutableInOSPath(Paths.get("flac", new String[0]))) != null) {
            this.flacInfo = new ExternalProgramInfo("FLAC", ProgramExecutableType.INSTALLED);
            this.flacInfo.setPath(ProgramExecutableType.INSTALLED, flac);
        } else {
            this.flacInfo = new ExternalProgramInfo("FLAC", null);
        }
        Path dcRaw = FileUtil.findExecutableInOSPath(Paths.get("dcraw", new String[0]));
        if (dcRaw != null) {
            this.dcRawInfo = new ExternalProgramInfo("DCRaw", ProgramExecutableType.INSTALLED);
            this.dcRawInfo.setPath(ProgramExecutableType.INSTALLED, dcRaw);
        } else {
            this.dcRawInfo = new ExternalProgramInfo("DCRaw", null);
        }
        Path youtubeDl = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            youtubeDl = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve("youtube-dl");
        }
        if (youtubeDl == null || !Files.exists(youtubeDl, new LinkOption[0])) {
            youtubeDl = PLATFORM_BINARIES_FOLDER.resolve("youtube-dl");
        }
        this.youtubeDlInfo = new ExternalProgramInfo("youtube-dl", ProgramExecutableType.BUNDLED);
        this.youtubeDlInfo.setPath(ProgramExecutableType.BUNDLED, youtubeDl);
        youtubeDl = FileUtil.findExecutableInOSPath(Paths.get("youtube-dl", new String[0]));
        if (youtubeDl != null) {
            this.youtubeDlInfo.setPath(ProgramExecutableType.INSTALLED, youtubeDl);
        }
    }

    @Override
    public FFmpegProgramInfo getFFmpeg() {
        return this.ffmpegInfo;
    }

    @Override
    public ExternalProgramInfo getMPlayer() {
        return this.mPlayerInfo;
    }

    @Override
    public ExternalProgramInfo getVLC() {
        return this.vlcInfo;
    }

    @Override
    public ExternalProgramInfo getMEncoder() {
        return this.mEncoderInfo;
    }

    @Override
    public ExternalProgramInfo getTsMuxeR() {
        return this.tsMuxeRInfo;
    }

    @Override
    public ExternalProgramInfo getFLAC() {
        return this.flacInfo;
    }

    @Override
    public ExternalProgramInfo getDCRaw() {
        return this.dcRawInfo;
    }

    @Override
    public ExternalProgramInfo getAviSynth() {
        return null;
    }

    @Override
    public ExternalProgramInfo getInterFrame() {
        return null;
    }

    @Override
    public ExternalProgramInfo getFFMS2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getDirectShowSource() {
        return null;
    }

    @Override
    public ExternalProgramInfo getMvtools2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getDepan() {
        return null;
    }

    @Override
    public ExternalProgramInfo getMasktools2() {
        return null;
    }

    @Override
    public ExternalProgramInfo getCropResize() {
        return null;
    }

    @Override
    public ExternalProgramInfo getConvert2dTo3d() {
        return null;
    }

    @Override
    public ExternalProgramInfo getYoutubeDl() {
        return this.youtubeDlInfo;
    }
}

