/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers.mediainfo;

import net.pms.parsers.mediainfo.MediaInfoHelper;
import net.pms.parsers.mediainfo.StreamKind;

public class StreamContainer {
    private StreamContainer() {
    }

    public static final Long getCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Count");
    }

    public static final Long getStatus(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Status");
    }

    public static final Long getStreamCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamCount");
    }

    public static final String getStreamKind(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamKind");
    }

    public static final String getStreamKindString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamKind/String");
    }

    public static final Long getStreamKindID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamKindID");
    }

    public static final Long getStreamKindPos(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamKindPos");
    }

    public static final Long getStreamOrder(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamOrder");
    }

    public static final Long getFirstPacketOrder(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "FirstPacketOrder");
    }

    public static final String getInform(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Inform");
    }

    public static final String getID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ID");
    }

    public static final String getIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ID/String");
    }

    public static final String getOriginalSourceMediumID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceMedium_ID");
    }

    public static final String getOriginalSourceMediumIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceMedium_ID/String");
    }

    public static final String getUniqueID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UniqueID");
    }

    public static final String getUniqueIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UniqueID/String");
    }

    public static final String getMenuID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "MenuID");
    }

    public static final String getMenuIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "MenuID/String");
    }

    public static final Long getGeneralCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "GeneralCount");
    }

    public static final Long getVideoCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "VideoCount");
    }

    public static final Long getAudioCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "AudioCount");
    }

    public static final Long getTextCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "TextCount");
    }

    public static final Long getOtherCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "OtherCount");
    }

    public static final Long getImageCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "ImageCount");
    }

    public static final Long getMenuCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "MenuCount");
    }

    public static final String getVideoFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Video_Format_List");
    }

    public static final String getVideoFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Video_Format_WithHint_List");
    }

    @Deprecated
    public static final String getVideoCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Video_Codec_List");
    }

    public static final String getVideoLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Video_Language_List");
    }

    public static final String getAudioFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Audio_Format_List");
    }

    public static final String getAudioFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Audio_Format_WithHint_List");
    }

    @Deprecated
    public static final String getAudioCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Audio_Codec_List");
    }

    public static final String getAudioLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Audio_Language_List");
    }

    public static final Long getAudioChannelsTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Audio_Channels_Total");
    }

    public static final String getTextFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Text_Format_List");
    }

    public static final String getTextFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Text_Format_WithHint_List");
    }

    @Deprecated
    public static final String getTextCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Text_Codec_List");
    }

    public static final String getTextLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Text_Language_List");
    }

    public static final String getOtherFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Other_Format_List");
    }

    public static final String getOtherFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Other_Format_WithHint_List");
    }

    @Deprecated
    public static final String getOtherCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Other_Codec_List");
    }

    public static final String getOtherLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Other_Language_List");
    }

    public static final String getImageFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Image_Format_List");
    }

    public static final String getImageFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Image_Format_WithHint_List");
    }

    @Deprecated
    public static final String getImageCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Image_Codec_List");
    }

    public static final String getImageLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Image_Language_List");
    }

    public static final String getMenuFormatList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Menu_Format_List");
    }

    public static final String getMenuFormatWithHintList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Menu_Format_WithHint_List");
    }

    @Deprecated
    public static final String getMenuCodecList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Menu_Codec_List");
    }

    public static final String getMenuLanguageList(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Menu_Language_List");
    }

    public static final String getCompleteName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CompleteName");
    }

    public static final String getFolderName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FolderName");
    }

    public static final String getFileNameExtension(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileNameExtension");
    }

    public static final String getFileName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileName");
    }

    public static final String getFileExtension(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileExtension");
    }

    public static final String getCompleteNameLast(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CompleteName_Last");
    }

    public static final String getFolderNameLast(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FolderName_Last");
    }

    public static final String getFileNameExtensionLast(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileNameExtension_Last");
    }

    public static final String getFileNameLast(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileName_Last");
    }

    public static final String getFileExtensionLast(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileExtension_Last");
    }

    public static final String getFormat(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format");
    }

    public static final String getFormatString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format/String");
    }

    public static final String getFormatInfo(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format/Info");
    }

    public static final String getFormatUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format/Url");
    }

    public static final String getFormatExtensions(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format/Extensions");
    }

    public static final String getFormatCommercial(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Commercial");
    }

    public static final String getFormatCommercialIfAny(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Commercial_IfAny");
    }

    public static final String getFormatVersion(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Version");
    }

    public static final String getFormatProfile(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Profile");
    }

    public static final String getFormatLevel(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Level");
    }

    public static final String getFormatCompression(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Compression");
    }

    public static final String getFormatSettings(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_Settings");
    }

    public static final String getFormatAdditionalFeatures(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Format_AdditionalFeatures");
    }

    public static final String getInternetMediaType(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "InternetMediaType");
    }

    public static final String getCodecID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID");
    }

    public static final String getCodecIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID/String");
    }

    public static final String getCodecIDInfo(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID/Info");
    }

    public static final String getCodecIDHint(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID/Hint");
    }

    public static final String getCodecIDUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID/Url");
    }

    public static final String getCodecIDDescription(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID_Description");
    }

    public static final String getCodecIDVersion(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID_Version");
    }

    public static final String getCodecIDCompatible(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CodecID_Compatible");
    }

    public static final String getInterleaved(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Interleaved");
    }

    @Deprecated
    public static final String getCodec(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec");
    }

    @Deprecated
    public static final String getCodecString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec/String");
    }

    @Deprecated
    public static final String getCodecInfo(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec/Info");
    }

    @Deprecated
    public static final String getCodecUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec/Url");
    }

    @Deprecated
    public static final String getCodecExtensions(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec/Extensions");
    }

    @Deprecated
    public static final String getCodecSettings(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec_Settings");
    }

    @Deprecated
    public static final String getCodecSettingsAutomatic(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Codec_Settings_Automatic");
    }

    public static final String getFileSize(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize");
    }

    public static final String getFileSizeString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize/String");
    }

    public static final String getFileSizeString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize/String1");
    }

    public static final String getFileSizeString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize/String2");
    }

    public static final String getFileSizeString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize/String3");
    }

    public static final String getFileSizeString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FileSize/String4");
    }

    public static final Double getDuration(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "Duration");
    }

    public static final String getDurationString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String");
    }

    public static final String getDurationString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String1");
    }

    public static final String getDurationString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String2");
    }

    public static final String getDurationString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String3");
    }

    public static final String getDurationString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String4");
    }

    public static final String getDurationString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration/String5");
    }

    public static final Double getDurationStart(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "Duration_Start");
    }

    public static final String getDurationStartString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String");
    }

    public static final String getDurationStartString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String1");
    }

    public static final String getDurationStartString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String2");
    }

    public static final String getDurationStartString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String3");
    }

    public static final String getDurationStartString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String4");
    }

    public static final String getDurationStartString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_Start/String5");
    }

    public static final Double getDurationEnd(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "Duration_End");
    }

    public static final String getDurationEndString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String");
    }

    public static final String getDurationEndString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String1");
    }

    public static final String getDurationEndString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String2");
    }

    public static final String getDurationEndString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String3");
    }

    public static final String getDurationEndString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String4");
    }

    public static final String getDurationEndString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Duration_End/String5");
    }

    public static final String getOverallBitRateMode(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate_Mode");
    }

    public static final String getOverallBitRateModeString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate_Mode/String");
    }

    public static final Double getOverallBitRate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "OverallBitRate");
    }

    public static final String getOverallBitRateString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate/String");
    }

    public static final Double getOverallBitRateMinimum(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "OverallBitRate_Minimum");
    }

    public static final String getOverallBitRateMinimumString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate_Minimum/String");
    }

    public static final Double getOverallBitRateNominal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "OverallBitRate_Nominal");
    }

    public static final String getOverallBitRateNominalString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate_Nominal/String");
    }

    public static final Double getOverallBitRateMaximum(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "OverallBitRate_Maximum");
    }

    public static final String getOverallBitRateMaximumString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OverallBitRate_Maximum/String");
    }

    public static final Double getFrameRate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getDouble(StreamKind.GENERAL, streamNumber, "FrameRate");
    }

    public static final String getFrameRateString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "FrameRate/String");
    }

    public static final Long getFrameRateNum(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "FrameRate_Num");
    }

    public static final Long getFrameRateDen(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "FrameRate_Den");
    }

    public static final Long getFrameCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "FrameCount");
    }

    public static final Long getDelay(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Delay");
    }

    public static final String getDelayString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String");
    }

    public static final String getDelayString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String1");
    }

    public static final String getDelayString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String2");
    }

    public static final String getDelayString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String3");
    }

    public static final String getDelayString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String4");
    }

    public static final String getDelayString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay/String5");
    }

    public static final String getDelaySettings(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay_Settings");
    }

    public static final String getDelayDropFrame(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay_DropFrame");
    }

    public static final String getDelaySource(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay_Source");
    }

    public static final String getDelaySourceString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Delay_Source/String");
    }

    public static final Long getStreamSize(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamSize");
    }

    public static final String getStreamSizeString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String");
    }

    public static final String getStreamSizeString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String1");
    }

    public static final String getStreamSizeString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String2");
    }

    public static final String getStreamSizeString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String3");
    }

    public static final String getStreamSizeString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String4");
    }

    public static final String getStreamSizeString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize/String5");
    }

    public static final String getStreamSizeProportion(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Proportion");
    }

    public static final Long getStreamSizeDemuxed(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed");
    }

    public static final String getStreamSizeDemuxedString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String");
    }

    public static final String getStreamSizeDemuxedString1(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String1");
    }

    public static final String getStreamSizeDemuxedString2(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String2");
    }

    public static final String getStreamSizeDemuxedString3(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String3");
    }

    public static final String getStreamSizeDemuxedString4(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String4");
    }

    public static final String getStreamSizeDemuxedString5(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "StreamSize_Demuxed/String5");
    }

    public static final Long getHeaderSize(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "HeaderSize");
    }

    public static final Long getDataSize(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "DataSize");
    }

    public static final Long getFooterSize(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "FooterSize");
    }

    public static final String getIsStreamable(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "IsStreamable");
    }

    public static final String getAlbumReplayGainGain(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album_ReplayGain_Gain");
    }

    public static final String getAlbumReplayGainGainString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album_ReplayGain_Gain/String");
    }

    public static final String getAlbumReplayGainPeak(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album_ReplayGain_Peak");
    }

    public static final String getEncryption(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption");
    }

    public static final String getEncryptionFormat(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_Format");
    }

    public static final String getEncryptionLength(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_Length");
    }

    public static final String getEncryptionMethod(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_Method");
    }

    public static final String getEncryptionMode(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_Mode");
    }

    public static final String getEncryptionPadding(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_Padding");
    }

    public static final String getEncryptionInitializationVector(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encryption_InitializationVector");
    }

    public static final String getUniversalAdIDString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UniversalAdID/String");
    }

    public static final String getUniversalAdIDRegistry(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UniversalAdID_Registry");
    }

    public static final String getUniversalAdIDValue(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UniversalAdID_Value");
    }

    public static final String getTitle(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Title");
    }

    public static final String getTitleMore(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Title_More");
    }

    public static final String getTitleUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Title/Url");
    }

    public static final String getDomain(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Domain");
    }

    public static final String getCollection(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Collection");
    }

    public static final String getSeason(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Season");
    }

    public static final Long getSeasonPosition(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Season_Position");
    }

    public static final Long getSeasonPositionTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Season_Position_Total");
    }

    public static final String getMovie(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Movie");
    }

    public static final String getMovieMore(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Movie_More");
    }

    public static final String getMovieCountry(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Movie/Country");
    }

    public static final String getMovieUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Movie/Url");
    }

    public static final String getAlbum(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album");
    }

    public static final String getAlbumMore(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album_More");
    }

    public static final String getAlbumSort(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album/Sort");
    }

    public static final String getAlbumPerformer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album/Performer");
    }

    public static final String getAlbumPerformerSort(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album/Performer/Sort");
    }

    public static final String getAlbumPerformerUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Album/Performer/Url");
    }

    public static final String getComic(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Comic");
    }

    public static final String getComicMore(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Comic_More");
    }

    public static final Long getComicPositionTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Comic/Position_Total");
    }

    public static final String getPart(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Part");
    }

    public static final Long getPartPosition(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Part/Position");
    }

    public static final Long getPartPositionTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Part/Position_Total");
    }

    public static final String getReel(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Reel");
    }

    public static final Long getReelPosition(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Reel/Position");
    }

    public static final Long getReelPositionTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Reel/Position_Total");
    }

    public static final String getTrack(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Track");
    }

    public static final String getTrackMore(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Track_More");
    }

    public static final String getTrackUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Track/Url");
    }

    public static final String getTrackSort(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Track/Sort");
    }

    public static final Long getTrackPosition(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Track/Position");
    }

    public static final Long getTrackPositionTotal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Track/Position_Total");
    }

    public static final String getPackageName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "PackageName");
    }

    public static final String getGrouping(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Grouping");
    }

    public static final String getChapter(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Chapter");
    }

    public static final String getSubTrack(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "SubTrack");
    }

    public static final String getOriginalAlbum(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Album");
    }

    public static final String getOriginalMovie(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Movie");
    }

    public static final String getOriginalPart(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Part");
    }

    public static final String getOriginalTrack(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Track");
    }

    public static final String getCompilation(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Compilation");
    }

    public static final String getCompilationString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Compilation/String");
    }

    public static final String getPerformer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Performer");
    }

    public static final String getPerformerSort(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Performer/Sort");
    }

    public static final String getPerformerUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Performer/Url");
    }

    public static final String getOriginalPerformer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Performer");
    }

    public static final String getAccompaniment(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Accompaniment");
    }

    public static final String getComposer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Composer");
    }

    public static final String getComposerNationality(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Composer/Nationality");
    }

    public static final String getComposerSort(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Composer/Sort");
    }

    public static final String getArranger(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Arranger");
    }

    public static final String getLyricist(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Lyricist");
    }

    public static final String getOriginalLyricist(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Lyricist");
    }

    public static final String getConductor(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Conductor");
    }

    public static final String getDirector(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Director");
    }

    public static final String getCoDirector(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CoDirector");
    }

    public static final String getAssistantDirector(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "AssistantDirector");
    }

    public static final String getDirectorOfPhotography(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "DirectorOfPhotography");
    }

    public static final String getSoundEngineer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "SoundEngineer");
    }

    public static final String getArtDirector(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ArtDirector");
    }

    public static final String getProductionDesigner(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ProductionDesigner");
    }

    public static final String getChoreographer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Choreographer");
    }

    public static final String getCostumeDesigner(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CostumeDesigner");
    }

    public static final String getActor(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Actor");
    }

    public static final String getActorCharacter(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Actor_Character");
    }

    public static final String getWrittenBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "WrittenBy");
    }

    public static final String getScreenplayBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ScreenplayBy");
    }

    public static final String getEditedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "EditedBy");
    }

    public static final String getCommissionedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CommissionedBy");
    }

    public static final String getProducer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Producer");
    }

    public static final String getCoProducer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CoProducer");
    }

    public static final String getExecutiveProducer(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ExecutiveProducer");
    }

    public static final String getMusicBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "MusicBy");
    }

    public static final String getDistributedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "DistributedBy");
    }

    public static final String getOriginalSourceFormDistributedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm/DistributedBy");
    }

    public static final String getMasteredBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "MasteredBy");
    }

    public static final String getEncodedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "EncodedBy");
    }

    public static final String getRemixedBy(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "RemixedBy");
    }

    public static final String getProductionStudio(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ProductionStudio");
    }

    public static final String getThanksTo(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ThanksTo");
    }

    public static final String getPublisher(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Publisher");
    }

    public static final String getPublisherURL(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Publisher/URL");
    }

    public static final String getLabel(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Label");
    }

    public static final String getGenre(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Genre");
    }

    public static final String getPodcastCategory(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "PodcastCategory");
    }

    public static final String getMood(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Mood");
    }

    public static final String getContentType(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ContentType");
    }

    public static final String getSubject(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Subject");
    }

    public static final String getDescription(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Description");
    }

    public static final String getKeywords(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Keywords");
    }

    public static final String getSummary(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Summary");
    }

    public static final String getSynopsis(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Synopsis");
    }

    public static final String getPeriod(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Period");
    }

    public static final String getLawRating(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "LawRating");
    }

    public static final String getLawRatingReason(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "LawRating_Reason");
    }

    public static final String getICRA(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ICRA");
    }

    public static final String getReleasedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Released_Date");
    }

    public static final String getOriginalReleasedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Original/Released_Date");
    }

    public static final String getRecordedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Recorded_Date");
    }

    public static final String getEncodedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Date");
    }

    public static final String getTaggedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Tagged_Date");
    }

    public static final String getWrittenDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Written_Date");
    }

    public static final String getMasteredDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Mastered_Date");
    }

    public static final String getFileCreatedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "File_Created_Date");
    }

    public static final String getFileCreatedDateLocal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "File_Created_Date_Local");
    }

    public static final String getFileModifiedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "File_Modified_Date");
    }

    public static final String getFileModifiedDateLocal(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "File_Modified_Date_Local");
    }

    public static final String getRecordedLocation(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Recorded_Location");
    }

    public static final String getWrittenLocation(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Written_Location");
    }

    public static final String getArchivalLocation(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Archival_Location");
    }

    public static final String getEncodedApplication(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application");
    }

    public static final String getEncodedApplicationString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application/String");
    }

    public static final String getEncodedApplicationCompanyName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application_CompanyName");
    }

    public static final String getEncodedApplicationName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application_Name");
    }

    public static final String getEncodedApplicationVersion(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application_Version");
    }

    public static final String getEncodedApplicationUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Application_Url");
    }

    public static final String getEncodedLibrary(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library");
    }

    public static final String getEncodedLibraryString(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library/String");
    }

    public static final String getEncodedLibraryCompanyName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library_CompanyName");
    }

    public static final String getEncodedLibraryName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library_Name");
    }

    public static final String getEncodedLibraryVersion(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library_Version");
    }

    public static final String getEncodedLibraryDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library_Date");
    }

    public static final String getEncodedLibrarySettings(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_Library_Settings");
    }

    public static final String getEncodedOperatingSystem(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Encoded_OperatingSystem");
    }

    public static final String getCropped(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cropped");
    }

    public static final String getDimensions(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Dimensions");
    }

    public static final String getDotsPerInch(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "DotsPerInch");
    }

    public static final String getLightness(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Lightness");
    }

    public static final String getOriginalSourceMedium(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceMedium");
    }

    public static final String getOriginalSourceForm(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm");
    }

    public static final String getOriginalSourceFormNumColors(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm/NumColors");
    }

    public static final String getOriginalSourceFormName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm/Name");
    }

    public static final String getOriginalSourceFormCropped(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm/Cropped");
    }

    public static final String getOriginalSourceFormSharpness(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalSourceForm/Sharpness");
    }

    public static final String getTaggedApplication(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Tagged_Application");
    }

    public static final String getBPM(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "BPM");
    }

    public static final String getISRC(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ISRC");
    }

    public static final String getISBN(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ISBN");
    }

    public static final String getISAN(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ISAN");
    }

    public static final String getBarCode(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "BarCode");
    }

    public static final String getLCCN(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "LCCN");
    }

    public static final String getUMID(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "UMID");
    }

    public static final String getCatalogNumber(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "CatalogNumber");
    }

    public static final String getLabelCode(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "LabelCode");
    }

    public static final String getOwner(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Owner");
    }

    public static final String getCopyright(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Copyright");
    }

    public static final String getCopyrightUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Copyright/Url");
    }

    public static final String getProducerCopyright(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Producer_Copyright");
    }

    public static final String getTermsOfUse(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "TermsOfUse");
    }

    public static final String getServiceName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ServiceName");
    }

    public static final String getServiceChannel(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ServiceChannel");
    }

    public static final String getServiceUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Service/Url");
    }

    public static final String getServiceProvider(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ServiceProvider");
    }

    public static final String getServiceProviderUrl(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ServiceProvider/Url");
    }

    public static final String getServiceType(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "ServiceType");
    }

    public static final String getNetworkName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "NetworkName");
    }

    public static final String getOriginalNetworkName(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "OriginalNetworkName");
    }

    public static final String getCountry(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Country");
    }

    public static final String getTimeZone(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "TimeZone");
    }

    public static final String getCover(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cover");
    }

    public static final String getCoverDescription(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cover_Description");
    }

    public static final String getCoverType(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cover_Type");
    }

    public static final String getCoverMime(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cover_Mime");
    }

    public static final String getCoverData(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Cover_Data");
    }

    public static final String getLyrics(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Lyrics");
    }

    public static final String getComment(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Comment");
    }

    public static final String getRating(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Rating");
    }

    public static final String getAddedDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Added_Date");
    }

    public static final String getPlayedFirstDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Played_First_Date");
    }

    public static final String getPlayedLastDate(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.get(StreamKind.GENERAL, streamNumber, "Played_Last_Date");
    }

    public static final Long getPlayedCount(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "Played_Count");
    }

    public static final Long getEPGPositionsBegin(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "EPG_Positions_Begin");
    }

    public static final Long getEPGPositionsEnd(MediaInfoHelper mediaInfo, int streamNumber) {
        return mediaInfo.getLong(StreamKind.GENERAL, streamNumber, "EPG_Positions_End");
    }
}

