/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webplayerserver.servlets;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.pms.network.webguiserver.GuiHttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="WebPlayerServlet", urlPatterns={"/"}, displayName="Player Servlet")
public class WebPlayerServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebPlayerServlet.class);
    private static final String BASE_PATH = "/";
    private static final String ABOUT_BASE_PATH = "/about";
    private static final String PLAYER_BASE_PATH = "/player";
    private static final List<String> ROUTES = List.of("/about", "/player");

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String uri = req.getRequestURI();
            if (uri == null) {
                uri = "/index.html";
            } else if (uri.startsWith("/static/")) {
                resp.setHeader("Cache-Control", "public, max-age=604800");
            } else {
                uri = uri.toLowerCase();
            }
            if (uri.equals(BASE_PATH) || ROUTES.contains(uri) || uri.startsWith(PLAYER_BASE_PATH)) {
                uri = "/index.html";
            }
            if (!WebPlayerServlet.writeAsync(req, resp, uri.substring(1))) {
                LOGGER.trace("WebPlayerServlet request not available : {}", (Object)req.getRequestURI());
                WebPlayerServlet.respond(req, resp, "<html><body>404 - File Not Found: " + req.getRequestURI() + "</body></html>", 404, "text/html");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in WebPlayerServlet: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

