/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import net.pms.network.webguiserver.WebSocketDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/v1/api/ws")
public class WebSocketEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketEndpoint.class);

    @OnOpen
    public void onOpen(Session session) {
        LOGGER.debug("WebSocket connection opened: " + session.getId());
        WebSocketDispatcher.add(session);
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        if ("ping".equals(message)) {
            try {
                session.getBasicRemote().sendText("pong");
            }
            catch (IOException e) {
                LOGGER.debug("Error sending message: " + e.getMessage());
            }
        } else {
            WebSocketDispatcher.onMessage(session, message);
        }
    }

    @OnClose
    public void onClose(Session session) {
        LOGGER.debug("WebSocket connection closed: " + session.getId());
        WebSocketDispatcher.remove(session);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        LOGGER.debug("WebSocket error: {}", (Object)throwable.getMessage());
        LOGGER.trace("Error details: {}", throwable);
    }
}

