/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl.jetty.ee10;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import net.pms.PMS;
import net.pms.network.mediaserver.jupnp.transport.spi.JakartaServletContainerAdapter;
import net.pms.network.mediaserver.servlets.MediaServerImportResourceServlet;
import net.pms.network.mediaserver.servlets.MediaServerServlet;
import net.pms.network.mediaserver.servlets.NextcpApiServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServletContainer
implements JakartaServletContainerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyServletContainer.class.getName());
    public static final JettyServletContainer INSTANCE = new JettyServletContainer();
    protected Server server;

    private JettyServletContainer() {
        this.resetServer();
    }

    @Override
    public synchronized void setExecutorService(ExecutorService executorService) {
    }

    @Override
    public synchronized int addConnector(String host, int port) throws IOException {
        ServerConnector connector = new ServerConnector(this.server, new HttpConnectionFactory(), new HTTP2CServerConnectionFactory());
        connector.setHost(host);
        connector.setPort(port);
        connector.setIdleTimeout(0x6DDD00L);
        this.server.addConnector(connector);
        return port;
    }

    @Override
    public synchronized void registerServlet(String contextPath, Servlet servlet) {
        Handler handler;
        ContextHandlerCollection contextHandlers;
        if (this.server.getHandler() == null) {
            contextHandlers = new ContextHandlerCollection(new ContextHandler[0]);
            this.server.setHandler(contextHandlers);
        }
        if ((handler = this.server.getHandler()) instanceof ContextHandlerCollection) {
            contextHandlers = (ContextHandlerCollection)handler;
            LOGGER.info("Registering UPnP servlet under context path: {}", (Object)contextPath);
            ServletContextHandler servletHandler = new ServletContextHandler(0);
            if (contextPath != null && !contextPath.isEmpty()) {
                servletHandler.setContextPath(contextPath);
            }
            this.addImportServlet(servletHandler);
            servletHandler.addServlet(new ServletHolder("MEDIA HTTP SERVER", new MediaServerServlet()), "/ums/*");
            servletHandler.addServlet(new ServletHolder("NextcpApiServlet", new NextcpApiServlet()), "/api/*");
            ServletHolder s = new ServletHolder("UPNP HTTP SERVER", servlet);
            servletHandler.addServlet(s, "/dev/*");
            contextHandlers.addHandler(servletHandler);
        } else {
            LOGGER.trace("Server handler is not a ContextHandlerCollection");
        }
    }

    private void addImportServlet(ServletContextHandler servletHandler) {
        try {
            String location = PMS.getConfiguration().getTempFolder().getAbsolutePath();
            long maxFileSize = Long.MAX_VALUE;
            long maxRequestSize = Long.MAX_VALUE;
            int fileSizeThreshold = 2048;
            MultipartConfigElement multipartConfig = new MultipartConfigElement(location, maxFileSize, maxRequestSize, fileSizeThreshold);
            ServletHolder importHolder = new ServletHolder("MEDIA SERVER IMPORT RESOURCE", new MediaServerImportResourceServlet());
            importHolder.getRegistration().setMultipartConfig(multipartConfig);
            servletHandler.addServlet(importHolder, "/import/*");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void startIfNotRunning() {
        if (!this.server.isStarted() && !this.server.isStarting()) {
            LOGGER.info("Starting Jetty server {}", (Object)Server.getVersion());
            try {
                this.server.start();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't start Jetty server", e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void stopIfRunning() {
        if (!this.server.isStopped() && !this.server.isStopping()) {
            LOGGER.info("Stopping Jetty server...");
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't stop Jetty server", e);
                throw new RuntimeException(e);
            }
            finally {
                this.resetServer();
            }
        }
    }

    private void resetServer() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("jupnp-stream-server");
        this.server = new Server(threadPool);
    }
}

