/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import net.pms.network.NetworkDeviceFilter;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.impl.DatagramIOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsDatagramIO
extends DatagramIOImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramIOImpl.class);

    public UmsDatagramIO(DatagramIOConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public void run() {
        LOGGER.debug("Entering blocking receiving loop, listening for UDP datagrams on: " + String.valueOf(this.socket.getLocalAddress()) + ":" + this.socket.getPort());
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[this.getConfiguration().getMaxDatagramBytes()];
                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                    this.socket.receive(datagram);
                    if (!NetworkDeviceFilter.isAllowed(datagram.getAddress())) {
                        LOGGER.trace("Ip Filtering denying address: {}", (Object)datagram.getAddress().getHostAddress());
                        continue;
                    }
                    LOGGER.debug("UDP datagram received from: " + datagram.getAddress().getHostAddress() + ":" + datagram.getPort() + " on: " + String.valueOf(this.localAddress));
                    this.router.received(this.datagramProcessor.read(this.localAddress.getAddress(), datagram));
                }
            }
            catch (SocketException ex) {
                LOGGER.debug("Socket closed");
            }
            catch (UnsupportedDataException ex) {
                LOGGER.info("Could not read datagram: " + ex.getMessage());
                continue;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            break;
        }
        try {
            if (!this.socket.isClosed()) {
                LOGGER.debug("Closing unicast socket");
                this.socket.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

