/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.pms.network.mediaserver.jupnp.transport.impl.JakartaServletConnection;
import net.pms.network.mediaserver.jupnp.transport.impl.JakartaServletUpnpStream;
import org.jupnp.model.message.Connection;
import org.jupnp.protocol.ProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaAsyncServletUpnpStream
extends JakartaServletUpnpStream
implements AsyncListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaAsyncServletUpnpStream.class);
    protected final AsyncContext asyncContext;
    protected final HttpServletRequest request;

    protected JakartaAsyncServletUpnpStream(ProtocolFactory protocolFactory, AsyncContext asyncContext, HttpServletRequest request) {
        super(protocolFactory);
        this.asyncContext = asyncContext;
        this.request = request;
        asyncContext.addListener(this);
    }

    @Override
    protected Connection createConnection() {
        return new JakartaServletConnection(this.getRequest());
    }

    @Override
    protected HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected HttpServletResponse getResponse() {
        ServletResponse response = this.asyncContext.getResponse();
        if (response == null) {
            throw new IllegalStateException("Couldn't get response from asynchronous context, already timed out");
        }
        return (HttpServletResponse)response;
    }

    @Override
    protected void complete() {
        try {
            this.asyncContext.complete();
        }
        catch (IllegalStateException e) {
            LOGGER.trace("Error calling servlet container's AsyncContext#complete() method", e);
        }
    }

    @Override
    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    @Override
    public void onComplete(AsyncEvent event) throws IOException {
        LOGGER.trace("Completed asynchronous processing of HTTP request: {}", (Object)event.getSuppliedRequest());
        this.responseSent(this.responseMessage);
    }

    @Override
    public void onTimeout(AsyncEvent event) throws IOException {
        LOGGER.trace("Asynchronous processing of HTTP request timed out: {}", (Object)event.getSuppliedRequest());
        this.responseException(new Exception("Asynchronous request timed out"));
    }

    @Override
    public void onError(AsyncEvent event) throws IOException {
        LOGGER.trace("Asynchronous processing of HTTP request error", event.getThrowable());
        this.responseException(event.getThrowable());
    }

    @Override
    public String toString() {
        return "" + this.hashCode();
    }
}

