/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item;

import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.AudioItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.StorageMediumValue;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class MusicTrack
extends AudioItem {
    private static final UPNP.Class CLASS = new UPNP.Class("object.item.audioItem.musicTrack");

    public MusicTrack() {
        this.setUpnpClass(CLASS);
    }

    public MusicTrack(Item other) {
        super(other);
    }

    public MusicTrack(String id, Container parent, String title, String creator, String album, String artist, Res ... resource) {
        this(id, parent.getId(), title, creator, album, artist, resource);
    }

    public MusicTrack(String id, Container parent, String title, String creator, String album, UPNP.Artist artist, Res ... resource) {
        this(id, parent.getId(), title, creator, album, artist, resource);
    }

    public MusicTrack(String id, String parentID, String title, String creator, String album, String artist, Res ... resource) {
        this(id, parentID, title, creator, album, artist == null ? null : new UPNP.Artist(artist), resource);
    }

    public MusicTrack(String id, String parentID, String title, String creator, String album, UPNP.Artist artist, Res ... resource) {
        super(id, parentID, title, creator, resource);
        this.setUpnpClass(CLASS);
        if (album != null) {
            this.setAlbum(album);
        }
        if (artist != null) {
            this.properties.add(artist);
        }
    }

    public UPNP.Artist getFirstArtist() {
        return this.properties.get(UPNP.Artist.class);
    }

    public List<UPNP.Artist> getArtists() {
        return this.properties.getAll(UPNP.Artist.class);
    }

    public MusicTrack addArtist(UPNP.Artist artist) {
        this.properties.add(artist);
        return this;
    }

    public MusicTrack setArtists(UPNP.Artist[] artists) {
        this.properties.remove(UPNP.Artist.class);
        for (UPNP.Artist artist : artists) {
            this.properties.add(artist);
        }
        return this;
    }

    public String getAlbum() {
        return (String)this.properties.getValue(UPNP.Album.class);
    }

    public final MusicTrack setAlbum(String album) {
        this.properties.set(new UPNP.Album(album));
        return this;
    }

    public Integer getOriginalTrackNumber() {
        return (Integer)this.properties.getValue(UPNP.OriginalTrackNumber.class);
    }

    public MusicTrack setOriginalTrackNumber(Integer number) {
        this.properties.set(new UPNP.OriginalTrackNumber(number));
        return this;
    }

    public String getFirstPlaylist() {
        return (String)this.properties.getValue(UPNP.Playlist.class);
    }

    public String[] getPlaylists() {
        List list = this.properties.getValues(UPNP.Playlist.class);
        return (String[])list.toArray(String[]::new);
    }

    public MusicTrack setPlaylists(String[] playlists) {
        this.properties.remove(UPNP.Playlist.class);
        for (String playlist : playlists) {
            this.properties.add(new UPNP.Playlist(playlist));
        }
        return this;
    }

    public String getStorageMedium() {
        return (String)this.properties.getValue(UPNP.StorageMedium.class);
    }

    public MusicTrack setStorageMedium(String storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public MusicTrack setStorageMedium(StorageMediumValue storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public String getFirstContributor() {
        return (String)this.properties.getValue(DC.Contributor.class);
    }

    public String[] getContributors() {
        List list = this.properties.getValues(DC.Contributor.class);
        return (String[])list.toArray(String[]::new);
    }

    public MusicTrack setContributors(String[] contributors) {
        this.properties.remove(DC.Contributor.class);
        for (String contributor : contributors) {
            this.properties.add(new DC.Contributor(contributor));
        }
        return this;
    }

    public String getDate() {
        return (String)this.properties.getValue(DC.Date.class);
    }

    public MusicTrack setDate(String date) {
        this.properties.set(new DC.Date(date));
        return this;
    }
}

