/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item;

import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.AudioItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.StorageMediumValue;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class AudioBook
extends AudioItem {
    private static final UPNP.Class CLASS = new UPNP.Class("object.item.audioItem.audioBook");

    public AudioBook() {
        this.setUpnpClass(CLASS);
    }

    public AudioBook(Item other) {
        super(other);
    }

    public AudioBook(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, (String)null, (String)null, (String)null, resource);
    }

    public AudioBook(String id, Container parent, String title, String creator, String producer, String contributor, String date, Res ... resource) {
        this(id, parent.getId(), title, creator, producer, contributor, date, resource);
    }

    public AudioBook(String id, String parentID, String title, String creator, String producer, String contributor, String date, Res ... resource) {
        super(id, parentID, title, creator, resource);
        this.setUpnpClass(CLASS);
        if (producer != null) {
            this.properties.add(new UPNP.Producer(producer));
        }
        if (contributor != null) {
            this.properties.add(new DC.Contributor(contributor));
        }
        if (date != null) {
            this.setDate(date);
        }
    }

    public String getStorageMedium() {
        return (String)this.properties.getValue(UPNP.StorageMedium.class);
    }

    public AudioBook setStorageMedium(String storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public AudioBook setStorageMedium(StorageMediumValue storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public String getFirstProducer() {
        return (String)this.properties.getValue(UPNP.Producer.class);
    }

    public String[] getProducers() {
        List list = this.properties.getValues(UPNP.Producer.class);
        return (String[])list.toArray(String[]::new);
    }

    public AudioBook setProducers(String[] producers) {
        this.properties.remove(UPNP.Producer.class);
        for (String producer : producers) {
            this.properties.add(new UPNP.Producer(producer));
        }
        return this;
    }

    public String getFirstContributor() {
        return (String)this.properties.getValue(DC.Contributor.class);
    }

    public String[] getContributors() {
        List list = this.properties.getValues(DC.Contributor.class);
        return (String[])list.toArray(String[]::new);
    }

    public AudioBook setContributors(String[] contributors) {
        this.properties.remove(DC.Contributor.class);
        for (String contributor : contributors) {
            this.properties.add(new DC.Contributor(contributor));
        }
        return this;
    }

    public String getDate() {
        return (String)this.properties.getValue(DC.Date.class);
    }

    public final AudioBook setDate(String date) {
        this.properties.set(new DC.Date(date));
        return this;
    }
}

