/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite;

import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Property;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.DIDL_LITE;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Desc;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.WriteStatusValue;

public abstract class BaseObject
extends Property {
    protected BaseObject(String qualifiedName) {
        super(null, qualifiedName);
    }

    protected BaseObject(String qualifiedName, BaseObject other) {
        this(qualifiedName, other.getId(), other.getParentID(), other.getTitle(), other.getCreator(), other.isRestricted(), WriteStatusValue.valueOf(other.getWriteStatus()), other.getUpnpClass(), null, other.getProperties().get(), other.getDescriptions());
    }

    protected BaseObject(String qualifiedName, String id, String parentID, String title, String creator, boolean restricted, WriteStatusValue writeStatus, UPNP.Class upnpClass, List<Res> resources, List<Property<?>> properties, List<Desc> descriptions) {
        super(null, qualifiedName);
        this.properties.set(properties);
        this.setId(id);
        this.setParentID(parentID);
        this.setRestricted(restricted);
        this.setTitle(title);
        this.setUpnpClass(upnpClass);
        this.setCreator(creator);
        this.setWriteStatus(writeStatus);
        if (resources != null) {
            this.setResources(resources);
        }
        if (descriptions != null) {
            this.setDescriptions(descriptions);
        }
    }

    public String getId() {
        return (String)this.dependentProperties.getValue(DIDL_LITE.Id.class);
    }

    public final BaseObject setId(String id) {
        this.dependentProperties.set(new DIDL_LITE.Id(id));
        return this;
    }

    public String getParentID() {
        return (String)this.dependentProperties.getValue(DIDL_LITE.ParentID.class);
    }

    public final BaseObject setParentID(String parentID) {
        this.dependentProperties.set(new DIDL_LITE.ParentID(parentID));
        return this;
    }

    public boolean isRestricted() {
        return (Boolean)this.dependentProperties.getValue(DIDL_LITE.Restricted.class);
    }

    public final BaseObject setRestricted(boolean restricted) {
        this.dependentProperties.set(new DIDL_LITE.Restricted(restricted));
        return this;
    }

    public String getTitle() {
        return (String)this.properties.getValue(DC.Title.class);
    }

    public final BaseObject setTitle(String title) {
        this.properties.set(new DC.Title(title));
        return this;
    }

    public String getUpnpClassName() {
        return (String)this.properties.getValue(UPNP.Class.class);
    }

    public UPNP.Class getUpnpClass() {
        return this.properties.get(UPNP.Class.class);
    }

    public final BaseObject setUpnpClass(UPNP.Class upnpClass) {
        this.properties.set(upnpClass);
        return this;
    }

    public String getCreator() {
        return (String)this.properties.getValue(DC.Creator.class);
    }

    public final BaseObject setCreator(String creator) {
        this.properties.set(new DC.Creator(creator));
        return this;
    }

    public Res getFirstResource() {
        return this.properties.get(Res.class);
    }

    public List<Res> getResources() {
        return this.properties.getAll(Res.class);
    }

    public final BaseObject setResources(List<Res> resources) {
        this.properties.remove(Res.class);
        for (Res resource : resources) {
            this.properties.add(resource);
        }
        return this;
    }

    public BaseObject setResources(Res[] resources) {
        this.properties.remove(Res.class);
        this.properties.addAll(resources);
        return this;
    }

    public BaseObject addResource(Res resource) {
        return this.addProperty(resource);
    }

    public List<Desc> getDescriptions() {
        return this.properties.getAll(Desc.class);
    }

    public final BaseObject setDescriptions(List<Desc> descriptions) {
        this.properties.remove(Desc.class);
        for (Desc description : descriptions) {
            this.properties.add(description);
        }
        return this;
    }

    public BaseObject setDescriptions(Desc[] descriptions) {
        this.properties.remove(Desc.class);
        this.properties.addAll(descriptions);
        return this;
    }

    public BaseObject addDescription(Desc description) {
        return this.addProperty(description);
    }

    public BaseObject addProperty(Property<?> property) {
        this.properties.add(property);
        return this;
    }

    public String getWriteStatus() {
        return (String)this.properties.getValue(UPNP.WriteStatus.class);
    }

    public final BaseObject setWriteStatus(WriteStatusValue writeStatus) {
        this.properties.set(new UPNP.WriteStatus(writeStatus));
        return this;
    }

    public BaseObject setWriteStatus(String writeStatus) {
        this.properties.set(new UPNP.WriteStatus(WriteStatusValue.valueOf(writeStatus)));
        return this;
    }

    public UnsignedInteger getObjectUpdateID() {
        return (UnsignedInteger)this.properties.getValue(UPNP.ObjectUpdateID.class);
    }

    public final void setObjectUpdateID(UnsignedInteger objectUpdateID) {
        this.properties.set(new UPNP.ObjectUpdateID(objectUpdateID));
    }

    public boolean isValid() {
        return this.dependentProperties.hasProperty(DIDL_LITE.Id.class) && this.dependentProperties.hasProperty(DIDL_LITE.ParentID.class) && this.dependentProperties.hasProperty(DIDL_LITE.Restricted.class) && this.properties.hasProperty(DC.Title.class) && this.properties.hasProperty(UPNP.Class.class);
    }
}

