/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import java.util.ArrayList;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Generator;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.BaseObject;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Desc;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;

public class Result {
    public static final String NAMESPACE_URI = "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/";
    protected List<Container> containers = new ArrayList<Container>();
    protected List<Item> items = new ArrayList<Item>();
    protected List<Desc> descriptions = new ArrayList<Desc>();

    public Result addContainer(Container container) {
        this.containers.add(container);
        return this;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public Result addObject(BaseObject object) {
        if (object instanceof Item) {
            Item item = (Item)object;
            this.addItem(item);
        } else if (object instanceof Container) {
            Container container = (Container)object;
            this.addContainer(container);
        }
        return this;
    }

    public Result addItem(Item item) {
        this.items.add(item);
        return this;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Result addDescription(Desc description) {
        this.descriptions.add(description);
        return this;
    }

    public List<Desc> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Desc> descriptions) {
        this.descriptions = descriptions;
    }

    public long getCount() {
        return this.containers.size() + this.items.size();
    }

    public String toString() {
        return new Generator().generate(this);
    }
}

