/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.model.meta;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.mediaserver.jupnp.model.meta.UmsDeviceDetailsProvider;
import net.pms.network.mediaserver.jupnp.support.connectionmanager.UmsConnectionManagerService;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.UmsContentDirectoryService;
import net.pms.network.mediaserver.jupnp.support.xmicrosoft.UmsMediaReceiverRegistrarService;
import org.jupnp.binding.annotations.AnnotationLocalServiceBinder;
import org.jupnp.model.DefaultServiceManager;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.profile.DeviceDetailsProvider;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsLocalDevice
extends LocalDevice {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsLocalDevice.class);
    private final DeviceDetailsProvider deviceDetailsProvider = new UmsDeviceDetailsProvider();
    private final UmsContentDirectoryService contentDirectoryService = this.getServiceImplementation(UmsContentDirectoryService.class);
    private final UmsConnectionManagerService connectionManagerService = this.getServiceImplementation(UmsConnectionManagerService.class);
    private final UmsMediaReceiverRegistrarService mediaReceiverRegistrarService = this.getServiceImplementation(UmsMediaReceiverRegistrarService.class);

    public UmsLocalDevice() throws ValidationException {
        super(new DeviceIdentity(new UDN(MediaServer.getUuid())), (DeviceType)new UDADeviceType("MediaServer"), (DeviceDetails)null, UmsLocalDevice.createDeviceIcons(), (LocalService[])UmsLocalDevice.createMediaServerServices(), (LocalDevice[])null);
    }

    @Override
    public DeviceDetails getDetails(RemoteClientInfo info) {
        if (this.deviceDetailsProvider != null) {
            return this.deviceDetailsProvider.provide(info);
        }
        return this.getDetails();
    }

    public UmsContentDirectoryService getContentDirectoryService() {
        return this.contentDirectoryService;
    }

    public UmsConnectionManagerService getConnectionManagerService() {
        return this.connectionManagerService;
    }

    public UmsMediaReceiverRegistrarService getMediaReceiverRegistrarService() {
        return this.mediaReceiverRegistrarService;
    }

    private <T> T getServiceImplementation(Class<T> baseClass) {
        for (LocalService service : this.getServices()) {
            if (service == null || !service.getManager().getImplementation().getClass().equals(baseClass)) continue;
            return service.getManager().getImplementation();
        }
        return null;
    }

    public static UmsLocalDevice createMediaServerDevice() {
        try {
            return new UmsLocalDevice();
        }
        catch (ValidationException e) {
            LOGGER.debug("Error in upnp local device creation: {}", e);
            return null;
        }
    }

    private static Icon[] createDeviceIcons() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        try {
            icons.add(new Icon("image/png", 256, 256, 24, "images/icon-square-256.png", UmsLocalDevice.getResourceInputStream("images/icon-square-256.png")));
            icons.add(new Icon("image/png", 128, 128, 24, "images/icon-square-128.png", UmsLocalDevice.getResourceInputStream("images/icon-square-128.png")));
            icons.add(new Icon("image/png", 120, 120, 24, "images/icon-square-120.png", UmsLocalDevice.getResourceInputStream("images/icon-square-120.png")));
            icons.add(new Icon("image/png", 48, 48, 24, "images/icon-square-48.png", UmsLocalDevice.getResourceInputStream("images/icon-square-48.png")));
            icons.add(new Icon("image/jpeg", 128, 128, 24, "images/icon-square-128.jpg", UmsLocalDevice.getResourceInputStream("images/icon-square-128.jpg")));
            icons.add(new Icon("image/jpeg", 120, 120, 24, "images/icon-square-120.jpg", UmsLocalDevice.getResourceInputStream("images/icon-square-120.jpg")));
            icons.add(new Icon("image/jpeg", 48, 48, 24, "images/icon-square-48.jpg", UmsLocalDevice.getResourceInputStream("images/icon-square-48.jpg")));
        }
        catch (IOException ex) {
            LOGGER.debug("Error in device icons creation: {}", ex);
        }
        return (Icon[])icons.toArray(Icon[]::new);
    }

    private static InputStream getResourceInputStream(String fileName) {
        fileName = "/resources/" + (String)fileName;
        fileName = ((String)fileName).replace("//", "/");
        ClassLoader cll = UmsLocalDevice.class.getClassLoader();
        InputStream is = cll.getResourceAsStream(((String)fileName).substring(1));
        while (is == null && cll.getParent() != null) {
            cll = cll.getParent();
            is = cll.getResourceAsStream(((String)fileName).substring(1));
        }
        return is;
    }

    private static LocalService<?>[] createMediaServerServices() {
        ArrayList<LocalService> services = new ArrayList<LocalService>();
        services.add(UmsLocalDevice.createContentDirectoryService());
        services.add(UmsLocalDevice.createServerConnectionManagerService());
        services.add(UmsLocalDevice.createMediaReceiverRegistrarService());
        return (LocalService[])services.toArray(LocalService[]::new);
    }

    private static LocalService createContentDirectoryService() {
        LocalService contentDirectoryService = new AnnotationLocalServiceBinder().read(UmsContentDirectoryService.class);
        contentDirectoryService.setManager(new DefaultServiceManager<UmsContentDirectoryService>(contentDirectoryService, null){

            @Override
            protected void lock() {
            }

            @Override
            protected void unlock() {
            }

            @Override
            protected UmsContentDirectoryService createServiceInstance() throws Exception {
                return new UmsContentDirectoryService();
            }
        });
        return contentDirectoryService;
    }

    private static LocalService createServerConnectionManagerService() {
        LocalService connectionManagerService = new AnnotationLocalServiceBinder().read(UmsConnectionManagerService.class);
        connectionManagerService.setManager(new DefaultServiceManager<UmsConnectionManagerService>(connectionManagerService, UmsConnectionManagerService.class){

            @Override
            protected int getLockTimeoutMillis() {
                return 1000;
            }

            @Override
            protected UmsConnectionManagerService createServiceInstance() throws Exception {
                return new UmsConnectionManagerService();
            }
        });
        return connectionManagerService;
    }

    private static LocalService createMediaReceiverRegistrarService() {
        LocalService mediaReceiverRegistrarService = new AnnotationLocalServiceBinder().read(UmsMediaReceiverRegistrarService.class);
        mediaReceiverRegistrarService.setManager(new DefaultServiceManager<UmsMediaReceiverRegistrarService>(mediaReceiverRegistrarService, null){

            @Override
            protected int getLockTimeoutMillis() {
                return 1000;
            }

            @Override
            protected UmsMediaReceiverRegistrarService createServiceInstance() throws Exception {
                return new UmsMediaReceiverRegistrarService();
            }
        });
        return mediaReceiverRegistrarService;
    }
}

