/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.UUID;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.gui.GuiManager;
import net.pms.network.configuration.NetworkConfiguration;
import net.pms.network.configuration.NetworkInterfaceAssociation;
import net.pms.network.mediaserver.jupnp.UmsUpnpService;
import net.pms.network.mediaserver.mdns.MDNS;
import net.pms.renderers.JUPnPDeviceHelper;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaServer.class);
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static boolean isStarted = false;
    private static ServerStatus status = ServerStatus.STOPPED;
    private static int port = CONFIGURATION.getMediaServerPort();
    private static String hostname;
    private static InetAddress inetAddress;
    private static NetworkInterface networkInterface;
    private static String serverName;
    private static String uuid;
    public static UmsUpnpService upnpService;

    private static boolean init() {
        port = CONFIGURATION.getMediaServerPort();
        NetworkInterfaceAssociation ia = NetworkConfiguration.getNetworkInterfaceAssociationFromConfig();
        if (ia != null) {
            inetAddress = ia.getAddr();
            hostname = inetAddress.getHostAddress();
            networkInterface = ia.getIface();
            return true;
        }
        return false;
    }

    public static synchronized boolean start() {
        while (status == ServerStatus.STOPPING) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.info("Starting media server interrupted.");
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (!(isStarted || status != ServerStatus.STOPPED && status != ServerStatus.WAITING)) {
            status = ServerStatus.STARTING;
            if (!MediaServer.init()) {
                LOGGER.info("Network not available with the config values.");
                LOGGER.info("Waiting network scanner discovering.");
                isStarted = false;
                MediaServer.setWaiting();
                return isStarted;
            }
            if (CONFIGURATION.isUpnpEnabled()) {
                if (upnpService == null) {
                    LOGGER.debug("Starting UPnP (JUPnP) services.");
                    upnpService = new UmsUpnpService();
                    upnpService.startup();
                }
                try {
                    isStarted = upnpService.getRouter().isEnabled();
                }
                catch (RouterException ex) {
                    isStarted = false;
                }
                if (!isStarted) {
                    LOGGER.error("FATAL ERROR: Unable to start upnp service");
                } else {
                    upnpService.sendAlive();
                    JUPnPDeviceHelper.searchMediaRendererDevices();
                    LOGGER.debug("UPnP (JUPnP) services are online, listening for media renderers");
                }
            }
            if (isStarted && !(isStarted = MDNS.start(inetAddress))) {
                LOGGER.error("FATAL ERROR: Unable to start mDNS service");
                MediaServer.stop();
            }
            status = isStarted ? ServerStatus.STARTED : ServerStatus.STOPPED;
        } else {
            LOGGER.debug("try to start the media server, but it's already started");
        }
        GuiManager.updateServerStatus();
        return isStarted;
    }

    public static synchronized void stop() {
        status = ServerStatus.STOPPING;
        MDNS.stop();
        if (upnpService != null) {
            LOGGER.debug("Shutting down UPnP (JUPnP) service");
            upnpService.shutdown();
            upnpService = null;
            LOGGER.debug("UPnP service stopped");
        }
        status = ServerStatus.STOPPED;
        isStarted = false;
        GuiManager.updateServerStatus();
    }

    public static boolean isStarted() {
        return status == ServerStatus.STARTED;
    }

    public static void setPort(int localPort) {
        port = localPort;
    }

    public static String getURL() {
        return "http://" + MediaServer.getAddress();
    }

    public static String getAddress() {
        return MediaServer.getHost() + ":" + MediaServer.getPort();
    }

    public static String getHost() {
        if (hostname != null) {
            return hostname;
        }
        if (CONFIGURATION.getServerHostname() != null) {
            return CONFIGURATION.getServerHostname();
        }
        return "localhost";
    }

    public static int getPort() {
        return port;
    }

    public static NetworkInterface getNetworkInterface() {
        return networkInterface;
    }

    public static InetAddress getInetAddress() {
        return inetAddress;
    }

    private static void setWaiting() {
        status = ServerStatus.WAITING;
        MediaServer.startIfPossible();
    }

    public static void checkNetworkConfiguration() {
        if (status == ServerStatus.WAITING) {
            MediaServer.startIfPossible();
        } else if (status == ServerStatus.STARTED) {
            MediaServer.resetIfNeeded();
        }
    }

    private static void startIfPossible() {
        NetworkInterfaceAssociation ia = NetworkConfiguration.getNetworkInterfaceAssociationFromConfig();
        if (ia != null) {
            LOGGER.info("Starting the media server as network interface association was found");
            MediaServer.start();
        }
    }

    public static void resetIfNeeded() {
        NetworkInterfaceAssociation ia = NetworkConfiguration.getNetworkInterfaceAssociationFromConfig();
        if (ia == null || ia.getAddr() != inetAddress || ia.getIface() != networkInterface) {
            LOGGER.info("Restarting the media server as network configuration has changed");
            MediaServer.stop();
            MediaServer.start();
        }
    }

    public static String getServerName() {
        if (serverName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(System.getProperty("os.name").replace(" ", "_"));
            sb.append('-');
            sb.append(System.getProperty("os.arch").replace(" ", "_"));
            sb.append('-');
            sb.append(System.getProperty("os.version").replace(" ", "_"));
            sb.append(", UPnP/1.0 DLNADOC/1.50, UMS/").append(PMS.getVersion());
            serverName = sb.toString();
        }
        return serverName;
    }

    public static String getUniqueDeviceName() {
        return "uuid:" + MediaServer.getUuid();
    }

    public static synchronized String getUuid() {
        if (uuid == null) {
            uuid = CONFIGURATION.getUuid();
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                LOGGER.info("Generated new random UUID: {}", (Object)uuid);
                CONFIGURATION.setUuid(uuid);
                CONFIGURATION.saveConfiguration();
            }
            LOGGER.info("Using the following UUID configured in UMS.conf: {}", (Object)uuid);
        }
        return uuid;
    }

    private static enum ServerStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        WAITING;

    }
}

