/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.configuration;

import com.google.gson.JsonArray;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.configuration.NetworkConfigurationListenerInterface;
import net.pms.network.configuration.NetworkInterfaceAssociation;
import net.pms.network.mediaserver.MediaServerNetworkConfigurationListener;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkConfiguration.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final int CHECK_DELAY = 5000;
    private static final Map<Integer, NetworkInterfaceAssociation> INTERFACES_ASSOCIATIONS = new LinkedHashMap<Integer, NetworkInterfaceAssociation>();
    private static final List<Integer> INTERFACES_WITH_ASSOCIATED_ADDRESS = new ArrayList<Integer>();
    private static final Map<Integer, Set<InetAddress>> ADDRESS_MAP = new HashMap<Integer, Set<InetAddress>>();
    private static final List<String> SKIP_NETWORK_INTERFACES = PMS.getConfiguration().getSkipNetworkInterfaces();
    private static final List<NetworkConfigurationListenerInterface> LISTENERS = new ArrayList<NetworkConfigurationListenerInterface>();
    private static final List<NetworkConfigurationListenerInterface> LISTENERS_REMOVED = new ArrayList<NetworkConfigurationListenerInterface>();
    private static boolean isInitiated = false;
    private static boolean isRunning = false;
    private static Thread watcherThread;

    private NetworkConfiguration() {
    }

    public static void init() {
        LOGGER.trace("Initializing the network scanner");
        System.setProperty("java.net.preferIPv4Stack", "true");
        NetworkConfiguration.checkNetworkInterfaces(true);
        LISTENERS.add(new MediaServerNetworkConfigurationListener());
        isInitiated = true;
    }

    public static void start() {
        if (!isInitiated) {
            NetworkConfiguration.init();
        }
        isRunning = true;
        if (watcherThread == null) {
            watcherThread = new Thread(NetworkConfiguration.run(), "NetworkConfiguration Watcher");
            watcherThread.start();
        }
    }

    public static void stop() {
        isRunning = false;
        if (watcherThread != null) {
            LOGGER.trace("Stopping the network scanner");
            watcherThread.interrupt();
            watcherThread = null;
        }
    }

    private static Runnable run() {
        return () -> {
            LOGGER.trace("Starting the network scanner");
            while (isRunning) {
                UMSUtils.sleep(5000);
                LOGGER.trace("Checking network configuration changes");
                NetworkConfiguration.checkKnownValues();
                NetworkConfiguration.checkNetworkInterfaces(false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(NetworkConfigurationListenerInterface listener) {
        NetworkConfiguration.cleanListeners();
        List<NetworkConfigurationListenerInterface> list = LISTENERS;
        synchronized (list) {
            LISTENERS.add(listener);
        }
    }

    public static void removeListener(NetworkConfigurationListenerInterface listener) {
        LISTENERS_REMOVED.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanListeners() {
        List<NetworkConfigurationListenerInterface> list = LISTENERS;
        synchronized (list) {
            if (!LISTENERS_REMOVED.isEmpty()) {
                for (NetworkConfigurationListenerInterface listener : LISTENERS_REMOVED) {
                    LISTENERS.remove(listener);
                }
                LISTENERS_REMOVED.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkKnownValues() {
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            for (NetworkInterfaceAssociation netInterface : INTERFACES_ASSOCIATIONS.values()) {
                if (!netInterface.statusChanged()) continue;
                if (netInterface.wasUp()) {
                    LOGGER.trace("interface {} with associated address {}: Interface is down", netInterface.iface.getName(), netInterface.iface.getIndex(), netInterface.getAddr());
                    for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                        listener.networkInterfaceDown(netInterface);
                    }
                    NetworkConfiguration.cleanListeners();
                } else {
                    LOGGER.trace("interface {} with associated address {}: Interface is up", netInterface.iface.getName(), netInterface.iface.getIndex(), netInterface.getAddr());
                    for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                        listener.networkInterfaceUp(netInterface);
                    }
                    NetworkConfiguration.cleanListeners();
                }
                netInterface.updateStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addressMapStore(NetworkInterface networkInterface, Set<InetAddress> addrSet) {
        Map<Integer, Set<InetAddress>> map = ADDRESS_MAP;
        synchronized (map) {
            int interfaceIndex = networkInterface.getIndex();
            if (ADDRESS_MAP.containsKey(interfaceIndex)) {
                Set<InetAddress> oldAddrSet = ADDRESS_MAP.get(interfaceIndex);
                HashSet<InetAddress> removedAddresses = new HashSet<InetAddress>();
                HashSet<InetAddress> addedAddresses = new HashSet<InetAddress>();
                for (InetAddress address : oldAddrSet) {
                    if (addrSet.contains(address)) continue;
                    removedAddresses.add(address);
                    LOGGER.trace("address {} is no more mapped to the interface {}({})", address, networkInterface.getName(), interfaceIndex);
                }
                for (InetAddress address : addrSet) {
                    if (oldAddrSet.contains(address)) continue;
                    addedAddresses.add(address);
                    LOGGER.trace("new found address {} is mapped to the interface {}({})", address, networkInterface.getName(), interfaceIndex);
                }
                if (!removedAddresses.isEmpty() || !addedAddresses.isEmpty()) {
                    ADDRESS_MAP.put(interfaceIndex, addrSet);
                    for (InetAddress address : removedAddresses) {
                        for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                            listener.networkInterfaceAddressRemoved(networkInterface, address);
                        }
                        NetworkConfiguration.cleanListeners();
                    }
                    for (InetAddress address : addedAddresses) {
                        for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                            listener.networkInterfaceAddressAdded(networkInterface, address);
                        }
                        NetworkConfiguration.cleanListeners();
                    }
                }
            } else {
                ADDRESS_MAP.put(interfaceIndex, addrSet);
                for (InetAddress address : addrSet) {
                    for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                        listener.networkInterfaceAddressAdded(networkInterface, address);
                    }
                    NetworkConfiguration.cleanListeners();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interfacesStore(int interfaceIndex, NetworkInterfaceAssociation ia) {
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            if (INTERFACES_ASSOCIATIONS.containsKey(interfaceIndex)) {
                NetworkInterfaceAssociation oldIa = INTERFACES_ASSOCIATIONS.get(interfaceIndex);
                if (oldIa.addr == null && ia.addr != null || oldIa.addr != null && !oldIa.addr.equals(ia.addr) || oldIa.parentName == null && ia.parentName != null || oldIa.parentName != null && !oldIa.parentName.equals(ia.parentName)) {
                    INTERFACES_ASSOCIATIONS.put(interfaceIndex, ia);
                    LOGGER.trace("changed interface {}({}) with newly associated address {}", ia.iface.getName(), interfaceIndex, ia.getAddr());
                    for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                        listener.networkInterfaceDefaultAddressChanged(ia.iface, ia.addr);
                    }
                    NetworkConfiguration.cleanListeners();
                }
            } else {
                INTERFACES_ASSOCIATIONS.put(interfaceIndex, ia);
                for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                    listener.networkInterfaceAdded(ia.iface, ia.addr);
                }
                NetworkConfiguration.cleanListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interfacesWithAssociatedAddressStore(int interfaceIndex) {
        boolean changed = false;
        List<Integer> list = INTERFACES_WITH_ASSOCIATED_ADDRESS;
        synchronized (list) {
            if (!INTERFACES_WITH_ASSOCIATED_ADDRESS.contains(interfaceIndex)) {
                LOGGER.trace("available multicast interface with address #{}", (Object)interfaceIndex);
                INTERFACES_WITH_ASSOCIATED_ADDRESS.add(interfaceIndex);
                changed = true;
            }
        }
        if (changed) {
            for (NetworkConfigurationListenerInterface listener : LISTENERS) {
                listener.networkInterfaceWithAddressAdded();
            }
        }
    }

    private static Set<InetAddress> addAvailableAddresses(NetworkInterface networkInterface, boolean showTrace) {
        HashSet<InetAddress> addrSet = new HashSet<InetAddress>();
        if (showTrace) {
            LOGGER.trace("available addresses for {} is: {}", (Object)networkInterface.getName(), (Object)Collections.list(networkInterface.getInetAddresses()));
        }
        for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
            if (address == null || !NetworkConfiguration.isRelevantAddress(address)) continue;
            addrSet.add(address);
        }
        if (showTrace) {
            LOGGER.trace("non loopback/ipv4 addresses: {}", (Object)addrSet);
        }
        NetworkConfiguration.addressMapStore(networkInterface, addrSet);
        return addrSet;
    }

    private static void checkNetworkInterfaces(boolean showTrace) {
        block2: {
            try {
                NetworkConfiguration.checkNetworkInterface(NetworkInterface.getNetworkInterfaces(), null, showTrace);
            }
            catch (SocketException ex) {
                if (!showTrace) break block2;
                LOGGER.error("Inspecting the network failed: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkNetworkInterface(Enumeration<NetworkInterface> networkInterfaces, String parentName, boolean showTrace) {
        if (networkInterfaces == null) {
            return;
        }
        if (showTrace) {
            LOGGER.trace("checkNetworkInterface(parent = {}, child interfaces = {})", (Object)parentName, (Object)networkInterfaces);
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            if (!NetworkConfiguration.skipNetworkInterface(ni.getName(), ni.getDisplayName())) {
                NetworkConfiguration.checkNetworkInterface(ni, parentName, showTrace);
                continue;
            }
            if (!showTrace) continue;
            List<String> list = SKIP_NETWORK_INTERFACES;
            synchronized (list) {
                LOGGER.trace("child network interface ({},{}) skipped, because skip_network_interfaces='{}'", ni.getName(), ni.getDisplayName(), SKIP_NETWORK_INTERFACES);
            }
        }
        if (showTrace) {
            LOGGER.trace("checkNetworkInterface(parent = {}) finished", (Object)parentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<InetAddress> getAllAvailableAddresses(Enumeration<NetworkInterface> networkInterfaces) {
        HashSet<InetAddress> addrSet = new HashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Map<Integer, Set<InetAddress>> map = ADDRESS_MAP;
            synchronized (map) {
                Set<InetAddress> set = ADDRESS_MAP.get(ni.getIndex());
                if (set != null) {
                    addrSet.addAll(set);
                }
            }
        }
        return addrSet;
    }

    private static void checkNetworkInterface(NetworkInterface networkInterface, String parentName, boolean showTrace) {
        int interfaceIndex = networkInterface.getIndex();
        if (showTrace) {
            LOGGER.trace("checking {}({}), display name: {}", networkInterface.getName(), interfaceIndex, networkInterface.getDisplayName());
        }
        NetworkConfiguration.addAvailableAddresses(networkInterface, showTrace);
        NetworkConfiguration.checkNetworkInterface(networkInterface.getSubInterfaces(), networkInterface.getName(), showTrace);
        Set<InetAddress> subAddress = NetworkConfiguration.getAllAvailableAddresses(networkInterface.getSubInterfaces());
        if (showTrace) {
            LOGGER.trace("sub address for {}({}) is {}", networkInterface.getName(), interfaceIndex, subAddress);
        }
        boolean foundAddress = false;
        for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
            if (address == null) continue;
            if (showTrace) {
                LOGGER.trace("checking {} on {}({})", address, networkInterface.getName(), interfaceIndex);
            }
            if (NetworkConfiguration.isRelevantAddress(address)) {
                block13: {
                    if (subAddress.contains(address)) continue;
                    if (showTrace) {
                        LOGGER.trace("found {}({}) -> {}", networkInterface.getName(), interfaceIndex, address.getHostAddress());
                    }
                    NetworkInterfaceAssociation ia = new NetworkInterfaceAssociation(address, networkInterface, parentName);
                    NetworkConfiguration.interfacesStore(interfaceIndex, ia);
                    try {
                        if (networkInterface.supportsMulticast()) {
                            NetworkConfiguration.interfacesWithAssociatedAddressStore(interfaceIndex);
                        } else if (showTrace) {
                            LOGGER.trace("Ignoring interface {}({}) with associated address {} because it does not seem to support multicast", networkInterface.getName(), interfaceIndex, ia.getAddr());
                        }
                    }
                    catch (SocketException e) {
                        if (!showTrace) break block13;
                        LOGGER.trace("Interface {}({}) raised exception when checking the multicast capability", (Object)networkInterface.getName(), (Object)interfaceIndex);
                    }
                }
                foundAddress = true;
                continue;
            }
            if (!showTrace) continue;
            LOGGER.trace("has {}, which is skipped, because loopback={}, ipv6={}", address, address.isLoopbackAddress(), address instanceof Inet6Address);
        }
        if (!foundAddress) {
            NetworkConfiguration.interfacesStore(interfaceIndex, new NetworkInterfaceAssociation(null, networkInterface, parentName));
            if (showTrace) {
                LOGGER.trace("found {}({}), without valid address", (Object)networkInterface.getName(), (Object)interfaceIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDisplayNamesWithAddress() {
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            ArrayList<String> result = new ArrayList<String>(INTERFACES_ASSOCIATIONS.size());
            for (NetworkInterfaceAssociation i : INTERFACES_ASSOCIATIONS.values()) {
                result.add(i.getDisplayNameWithAddress());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDisplayNames() {
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            ArrayList<String> result = new ArrayList<String>(INTERFACES_ASSOCIATIONS.size());
            for (NetworkInterfaceAssociation i : INTERFACES_ASSOCIATIONS.values()) {
                result.add(i.getDisplayName());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonArray getNetworkInterfacesAsJsonArray() {
        HashMap<String, String> interfaces = new HashMap<String, String>();
        interfaces.put("", "i18n@AutoDetect");
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            for (NetworkInterfaceAssociation i : INTERFACES_ASSOCIATIONS.values()) {
                interfaces.put(i.getDisplayNameWithAddress(), i.getDisplayName());
            }
        }
        String[] values = (String[])interfaces.values().toArray(String[]::new);
        String[] labels = (String[])interfaces.keySet().toArray(String[]::new);
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkInterfaceAssociation getDefaultNetworkInterfaceAddress() {
        Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
        synchronized (map) {
            LOGGER.trace("default network interface address from {}", (Object)INTERFACES_ASSOCIATIONS);
        }
        NetworkInterfaceAssociation association = NetworkConfiguration.getFirstInterfaceWithAddress();
        if (association != null) {
            if (association.getParentName() != null) {
                NetworkInterfaceAssociation ia = NetworkConfiguration.getAddressForNetworkInterfaceName(association.getParentName());
                LOGGER.trace("first association has parent: {} -> {}", (Object)association, (Object)ia);
                return ia;
            }
            LOGGER.trace("first network interface: {}", (Object)association);
            return association;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NetworkInterfaceAssociation getFirstInterfaceWithAddress() {
        List<Integer> list = INTERFACES_WITH_ASSOCIATED_ADDRESS;
        synchronized (list) {
            if (INTERFACES_WITH_ASSOCIATED_ADDRESS.isEmpty()) {
                return null;
            }
            ArrayList<Integer> virtualInterfaces = new ArrayList<Integer>();
            for (Integer interfaceIndex : INTERFACES_WITH_ASSOCIATED_ADDRESS) {
                if (INTERFACES_ASSOCIATIONS.get(interfaceIndex).getDisplayName().toLowerCase().contains("virtual")) {
                    virtualInterfaces.add(interfaceIndex);
                    continue;
                }
                return INTERFACES_ASSOCIATIONS.get(interfaceIndex);
            }
            if (!virtualInterfaces.isEmpty()) {
                return INTERFACES_ASSOCIATIONS.get(virtualInterfaces.get(0));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean skipNetworkInterface(String name, String displayName) {
        List<String> list = SKIP_NETWORK_INTERFACES;
        synchronized (list) {
            for (String current : SKIP_NETWORK_INTERFACES) {
                if (current == null) continue;
                if (name != null && name.toLowerCase().startsWith(current.toLowerCase())) {
                    return true;
                }
                if (displayName == null || !displayName.toLowerCase().startsWith(current.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    public static NetworkInterface getNetworkInterfaceByServerName() throws SocketException, UnknownHostException {
        String hostname = CONFIGURATION.getServerHostname();
        if (hostname != null) {
            LOGGER.trace("Searching network interface for {}", (Object)hostname);
            return NetworkInterface.getByInetAddress(InetAddress.getByName(hostname));
        }
        return null;
    }

    public static NetworkInterfaceAssociation getNetworkInterfaceAssociationFromConfig() {
        boolean forcedNetworkInterface = StringUtils.isNotEmpty(CONFIGURATION.getNetworkInterface());
        boolean forcedInetAddress = StringUtils.isNotBlank(CONFIGURATION.getServerHostname());
        NetworkInterfaceAssociation ia = null;
        if (forcedNetworkInterface) {
            LOGGER.debug("Using forced network interface: {}", (Object)CONFIGURATION.getNetworkInterface());
            ia = NetworkConfiguration.getAddressForNetworkInterfaceName(CONFIGURATION.getNetworkInterface());
            if (ia == null) {
                LOGGER.error("Forced network interface {} not found on this system", (Object)CONFIGURATION.getNetworkInterface().trim().replace('\n', ' '));
                return null;
            }
            if (!ia.isUp()) {
                LOGGER.error("Forced network interface {} is down", (Object)CONFIGURATION.getNetworkInterface().trim().replace('\n', ' '));
                return null;
            }
        }
        String hostname = CONFIGURATION.getServerHostname();
        if (forcedInetAddress) {
            LOGGER.debug("Using forced address: {}", (Object)hostname);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(hostname);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (inetAddress == null) {
                LOGGER.error("Forced address {} is unknowned on this system", (Object)hostname);
                if (ia != null) {
                    Set<InetAddress> set = ADDRESS_MAP.get(ia.iface.getIndex());
                    LOGGER.info("Good addresses for the requested network interface are: {}", (Object)set);
                }
                return null;
            }
            hostname = inetAddress.getHostAddress();
            try {
                NetworkInterface tmpNetworkInterface = NetworkInterface.getByInetAddress(inetAddress);
                if (ia == null) {
                    if (tmpNetworkInterface.isUp()) {
                        return new NetworkInterfaceAssociation(inetAddress, tmpNetworkInterface, null);
                    }
                    LOGGER.error("Forced address {} network interface {} is down", (Object)hostname, (Object)tmpNetworkInterface.getName().trim().replace('\n', ' '));
                    return null;
                }
                Set<InetAddress> set = ADDRESS_MAP.get(ia.iface.getIndex());
                if (set.contains(inetAddress)) {
                    return new NetworkInterfaceAssociation(inetAddress, ia.iface, ia.parentName);
                }
                LOGGER.error("Forced address {} is unknowned on the requested network interface", (Object)hostname);
                LOGGER.info("Good addresses for the requested network interface {} are:{}", (Object)CONFIGURATION.getNetworkInterface().trim().replace('\n', ' '), (Object)set);
                return null;
            }
            catch (SocketException ex) {
                LOGGER.error("Forced address {} network interface not found on this system", (Object)hostname);
                return null;
            }
        }
        if (ia != null) {
            if (ia.addr != null) {
                return ia;
            }
            LOGGER.error("Forced network interface {} don't have any IP address assigned", (Object)ia.iface.getName().trim().replace('\n', ' '));
            return null;
        }
        ia = NetworkConfiguration.getDefaultNetworkInterfaceAddress();
        if (ia != null) {
            return ia;
        }
        LOGGER.error("No default network interface found on this system");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceShortInterfaceNameByDisplayName(String interfaceName) {
        if (StringUtils.isNotBlank(interfaceName)) {
            Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
            synchronized (map) {
                for (NetworkInterfaceAssociation netInterface : INTERFACES_ASSOCIATIONS.values()) {
                    if (!netInterface.getShortName().equals(interfaceName)) continue;
                    interfaceName = netInterface.getDisplayName();
                    break;
                }
            }
        }
        return interfaceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkInterfaceAssociation getInterfaceAssociationFromDisplayName(String interfaceName) {
        if (StringUtils.isNotBlank(interfaceName = NetworkConfiguration.replaceShortInterfaceNameByDisplayName(interfaceName))) {
            Map<Integer, NetworkInterfaceAssociation> map = INTERFACES_ASSOCIATIONS;
            synchronized (map) {
                for (NetworkInterfaceAssociation netInterface : INTERFACES_ASSOCIATIONS.values()) {
                    if (!netInterface.getDisplayName().equals(interfaceName)) continue;
                    return netInterface;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkInterfaceAssociation getAddressForNetworkInterfaceName(String name) {
        NetworkInterfaceAssociation ia = NetworkConfiguration.getInterfaceAssociationFromDisplayName(name);
        if (ia != null) {
            List<Integer> list = INTERFACES_WITH_ASSOCIATED_ADDRESS;
            synchronized (list) {
                if (INTERFACES_WITH_ASSOCIATED_ADDRESS.contains(ia.iface.getIndex())) {
                    return ia;
                }
            }
        }
        return null;
    }

    private static boolean isRelevantAddress(InetAddress address) {
        return address != null && !(address instanceof Inet6Address) && !address.isLoopbackAddress();
    }
}

