/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.video.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.media.video.metadata.ApiCountryArray;
import net.pms.media.video.metadata.ApiCredits;
import net.pms.media.video.metadata.ApiExternalIDs;
import net.pms.media.video.metadata.ApiImages;
import net.pms.media.video.metadata.ApiProductionCompanyArray;
import net.pms.media.video.metadata.ApiRatingSourceArray;
import net.pms.media.video.metadata.ApiStringArray;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaVideoMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaVideoMetadata.class);
    private static final Gson GSON = new Gson();
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private Long fileId;
    private String imdbID;
    private Integer year;
    private String title;
    private Long tvSeriesId;
    private Integer tvSeason;
    private String tvEpisodeNumber;
    private String extraInformation;
    private boolean isTvEpisode;
    private boolean isSample;
    private ApiStringArray actors;
    private String awards;
    private Long budget;
    private ApiStringArray countries;
    private ApiCredits credits;
    private ApiStringArray directors;
    private ApiExternalIDs externalIDs;
    private ApiStringArray genres;
    private String homepage;
    private ApiImages images;
    private String originalLanguage;
    private String originalTitle;
    private String overview;
    private String poster;
    private ApiProductionCompanyArray productionCompanies;
    private ApiCountryArray productionCountries;
    private String rated;
    private Double rating;
    private ApiRatingSourceArray ratings;
    private LocalDate released;
    private Long revenue;
    private TvSeriesMetadata seriesMetadata;
    private String tagline;
    private Long tmdbId;
    private Long tmdbTvId;
    private String version;
    private String votes;
    private Map<String, VideoMetadataLocalized> translations;

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long value) {
        this.fileId = value;
    }

    public String getIMDbID() {
        return this.imdbID;
    }

    public void setIMDbID(String value) {
        this.imdbID = value;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer value) {
        this.year = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public Long getTvSeriesId() {
        return this.tvSeriesId;
    }

    public void setTvSeriesId(Long value) {
        this.tvSeriesId = value;
    }

    public Integer getTvSeason() {
        return this.tvSeason;
    }

    public void setTvSeason(Integer value) {
        this.tvSeason = value;
    }

    public String getTvEpisodeNumber() {
        return this.tvEpisodeNumber;
    }

    public String getTvEpisodeNumberUnpadded() {
        if (StringUtils.isNotBlank(this.tvEpisodeNumber) && this.tvEpisodeNumber.length() > 1 && this.tvEpisodeNumber.startsWith("0")) {
            return this.tvEpisodeNumber.substring(1);
        }
        return this.tvEpisodeNumber;
    }

    public Integer getFirstTvEpisodeNumber() {
        if (this.tvEpisodeNumber != null) {
            String firstEpisode = this.tvEpisodeNumber;
            if (firstEpisode.contains("-")) {
                firstEpisode = firstEpisode.substring(0, firstEpisode.indexOf("-"));
            }
            Integer result = null;
            if (firstEpisode != null) {
                try {
                    result = Integer.valueOf(firstEpisode);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }
        return null;
    }

    public void setTvEpisodeNumber(String value) {
        this.tvEpisodeNumber = value;
    }

    public String getTvEpisodeName() {
        if (this.isTvEpisode) {
            return this.getTitle(null);
        }
        return null;
    }

    public String getTvEpisodeName(String lang) {
        if (this.isTvEpisode) {
            return this.getTitle(lang);
        }
        return null;
    }

    public boolean isTvEpisode() {
        return this.isTvEpisode;
    }

    public void setIsTvEpisode(boolean value) {
        this.isTvEpisode = value;
    }

    public Integer getTvSeriesStartYear() {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getStartYear();
        }
        return null;
    }

    public String getTvSeriesTitle() {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getTitle(null);
        }
        return null;
    }

    public String getTvSeriesTitle(String lang) {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getTitle(lang);
        }
        return null;
    }

    public boolean isSample() {
        return this.isSample;
    }

    public void setIsSample(boolean value) {
        this.isSample = value;
    }

    public String getExtraInformation() {
        return this.extraInformation;
    }

    public void setExtraInformation(String value) {
        this.extraInformation = value;
    }

    public ApiStringArray getActors() {
        return this.actors;
    }

    public void setActors(ApiStringArray value) {
        this.actors = value;
    }

    public void setActors(String value) {
        try {
            this.actors = GSON.fromJson(value, ApiStringArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing actors: {}", (Object)e.getMessage());
            this.actors = null;
        }
    }

    public String getAwards() {
        return this.awards;
    }

    public void setAwards(String value) {
        this.awards = value;
    }

    public Long getBudget() {
        return this.budget;
    }

    public void setBudget(Long value) {
        this.budget = value;
    }

    public ApiStringArray getCountries() {
        return this.countries;
    }

    public void setCountries(ApiStringArray value) {
        this.countries = value;
    }

    public ApiCredits getCredits() {
        return this.credits;
    }

    public void setCredits(ApiCredits value) {
        this.credits = value;
    }

    public void setCredits(String value) {
        try {
            this.credits = GSON.fromJson(value, ApiCredits.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing credits: {}", (Object)e.getMessage());
            this.credits = null;
        }
    }

    public ApiStringArray getDirectors() {
        return this.directors;
    }

    public void setDirectors(ApiStringArray value) {
        this.directors = value;
    }

    public void setDirectors(String value) {
        try {
            this.directors = GSON.fromJson(value, ApiStringArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing directors: {}", (Object)e.getMessage());
            this.directors = null;
        }
    }

    public ApiExternalIDs getExternalIDs() {
        return this.externalIDs;
    }

    public void setExternalIDs(ApiExternalIDs value) {
        this.externalIDs = value;
    }

    public void setExternalIDs(String value) {
        try {
            this.externalIDs = GSON.fromJson(value, ApiExternalIDs.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing ExternalIDs: {}", (Object)e.getMessage());
            this.externalIDs = null;
        }
    }

    public ApiStringArray getGenres() {
        return this.genres;
    }

    public void setGenres(ApiStringArray value) {
        this.genres = value;
    }

    public void setGenres(String value) {
        try {
            this.genres = GSON.fromJson(value, ApiStringArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing genres: {}", (Object)e.getMessage());
            this.genres = null;
        }
    }

    public String getHomepage() {
        return this.getHomepage(null);
    }

    public void setHomepage(String value) {
        this.homepage = value;
    }

    public ApiImages getImages() {
        return this.images;
    }

    public void setImages(ApiImages value) {
        this.images = value;
    }

    public void setImages(String value) {
        try {
            this.images = GSON.fromJson(value, ApiImages.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing Images: {}", (Object)e.getMessage());
            this.images = null;
        }
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String value) {
        this.originalLanguage = value;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String value) {
        this.originalTitle = value;
    }

    public String getOverview() {
        return this.getOverview(null);
    }

    public void setOverview(String value) {
        this.overview = value;
    }

    public String getPoster() {
        return this.getPoster(null);
    }

    public void setPoster(String value) {
        this.poster = value;
    }

    public ApiProductionCompanyArray getProductionCompanies() {
        return this.productionCompanies;
    }

    public void setProductionCompanies(ApiProductionCompanyArray value) {
        this.productionCompanies = value;
    }

    public void setProductionCompanies(String value) {
        try {
            this.productionCompanies = GSON.fromJson(value, ApiProductionCompanyArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing production companies: {}", (Object)e.getMessage());
            this.productionCompanies = null;
        }
    }

    public ApiCountryArray getProductionCountries() {
        return this.productionCountries;
    }

    public void setProductionCountries(ApiCountryArray value) {
        this.productionCountries = value;
    }

    public void setProductionCountries(String value) {
        try {
            this.productionCountries = GSON.fromJson(value, ApiCountryArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing production countries: {}", (Object)e.getMessage());
            this.productionCountries = null;
        }
    }

    public String getRated() {
        return this.rated;
    }

    public void setRated(String value) {
        this.rated = value;
    }

    public Double getRating() {
        return this.rating;
    }

    public void setRating(Double value) {
        this.rating = value;
    }

    public ApiRatingSourceArray getRatings() {
        return this.ratings;
    }

    public void setRatings(ApiRatingSourceArray value) {
        this.ratings = value;
    }

    public void setRatings(String value) {
        try {
            this.ratings = GSON.fromJson(value, ApiRatingSourceArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing ratings: {}", (Object)e.getMessage());
            this.ratings = null;
        }
    }

    public LocalDate getReleased() {
        return this.released;
    }

    public void setReleased(LocalDate value) {
        this.released = value;
    }

    public void setReleased(String value) {
        LocalDate localDate = null;
        if (value != null) {
            try {
                localDate = LocalDate.parse(value.length() > 10 ? value.substring(0, 10) : value);
            }
            catch (IllegalArgumentException | NullPointerException | DateTimeParseException e) {
                LOGGER.trace("String \"{}\" cannot converts to LocalDate", (Object)value);
            }
        }
        this.released = localDate;
    }

    public Long getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Long value) {
        this.revenue = value;
    }

    public TvSeriesMetadata getSeriesMetadata() {
        return this.seriesMetadata;
    }

    public void setSeriesMetadata(TvSeriesMetadata value) {
        this.seriesMetadata = value;
    }

    public String getTagline() {
        return this.getTagline(null);
    }

    public void setTagline(String value) {
        this.tagline = value;
    }

    public Long getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(Long value) {
        this.tmdbId = value;
    }

    public Long getTmdbTvId() {
        return this.tmdbTvId;
    }

    public void setTmdbTvId(Long value) {
        this.tmdbTvId = value;
    }

    public String getVotes() {
        return this.votes;
    }

    public void setVotes(String value) {
        this.votes = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setApiVersion(String value) {
        this.version = value;
    }

    public String getMovieOrShowName() {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getTitle();
        }
        return this.title;
    }

    public String getMovieOrShowName(String lang) {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getTitle(lang);
        }
        return this.getTitle(lang);
    }

    public Integer getMovieOrShowYear() {
        if (this.isTvEpisode && this.seriesMetadata != null) {
            return this.seriesMetadata.getStartYear();
        }
        return this.year;
    }

    public void setTranslations(Map<String, VideoMetadataLocalized> value) {
        this.translations = value;
    }

    public void ensureHavingTranslation(String lang) {
        VideoMetadataLocalized loc;
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && !"en-us".equals(lang) && !this.hasTranslation(lang) && this.fileId != null && this.fileId > -1L && (loc = this.isTvEpisode ? MediaTableVideoMetadataLocalized.getVideoMetadataLocalized(this.fileId, false, lang, this.imdbID, "tv_episode", this.tmdbTvId, this.tvSeason, this.tvEpisodeNumber) : MediaTableVideoMetadataLocalized.getVideoMetadataLocalized(this.fileId, false, lang, this.imdbID, "movie", this.tmdbId, null, null)) != null) {
            this.addTranslation(lang, loc);
        }
    }

    private void addTranslation(String lang, VideoMetadataLocalized value) {
        if (lang == null || value == null) {
            return;
        }
        if (this.translations == null) {
            this.translations = new HashMap<String, VideoMetadataLocalized>();
        }
        this.translations.put(lang.toLowerCase(), value);
    }

    private boolean hasTranslation(String lang) {
        return this.translations != null && this.translations.containsKey(lang.toLowerCase());
    }

    private VideoMetadataLocalized getTranslation(String lang) {
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && this.hasTranslation(lang)) {
            return this.translations.get(lang);
        }
        return null;
    }

    public String getHomepage(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getHomepage())) {
            return translation.getHomepage();
        }
        return this.homepage;
    }

    public String getOverview(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getOverview())) {
            return translation.getOverview();
        }
        return this.overview;
    }

    public String getPoster(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getPoster())) {
            return translation.getPoster();
        }
        return this.poster;
    }

    public String getTagline(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getTagline())) {
            return translation.getTagline();
        }
        return this.tagline;
    }

    public String getTitle(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getTitle())) {
            return translation.getTitle();
        }
        return this.title;
    }

    public JsonObject asJsonObject(String lang) {
        lang = CONFIGURATION.getTranslationLanguage(lang);
        this.ensureHavingTranslation(lang);
        JsonObject result = new JsonObject();
        result.addProperty("imdbID", this.imdbID);
        result.add("actors", GSON.toJsonTree(this.actors));
        result.addProperty("awards", this.awards);
        result.add("countries", GSON.toJsonTree(this.countries));
        result.add("directors", GSON.toJsonTree(this.directors));
        result.add("externalIDs", GSON.toJsonTree(this.externalIDs));
        result.add("genres", GSON.toJsonTree(this.genres));
        result.addProperty("homepage", this.getHomepage(lang));
        result.add("images", GSON.toJsonTree(this.images));
        result.addProperty("mediaType", this.isTvEpisode ? "tv_episode" : "movie");
        if (!this.isTvEpisode && this.originalTitle != null && !this.originalTitle.equals(this.getMovieOrShowName(lang))) {
            result.addProperty("originalLanguage", this.originalLanguage);
            result.addProperty("originalTitle", this.originalTitle);
        }
        result.addProperty("overview", this.getOverview(lang));
        result.addProperty("poster", this.getPoster(lang));
        result.addProperty("rated", this.rated);
        result.addProperty("rating", this.rating);
        result.add("ratings", GSON.toJsonTree(this.ratings));
        if (this.released != null) {
            result.addProperty("released", this.released.toString());
        }
        result.addProperty("tagline", this.getTagline(lang));
        result.addProperty("tmdbID", this.tmdbId);
        result.addProperty("tmdbTvID", this.tmdbTvId);
        result.addProperty("tvEpisode", this.tvEpisodeNumber);
        result.addProperty("tvSeason", this.tvSeason);
        result.addProperty("votes", this.votes);
        if (this.isTvEpisode && this.seriesMetadata != null) {
            result.add("seriesImages", GSON.toJsonTree(this.seriesMetadata.getImages()));
        }
        return result;
    }
}

