/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.audio;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.pms.media.MediaLang;
import org.apache.commons.lang3.StringUtils;

public class MediaAudio
extends MediaLang
implements Cloneable {
    public static final int DEFAULT_BIT_DEPTH = 16;
    public static final int DEFAULT_SAMPLE_RATE = 48000;
    public static final int DEFAULT_NUMBER_OF_CHANNELS = 2;
    private Integer streamOrder;
    private boolean defaultFlag;
    private boolean forcedFlag;
    private String codec;
    private Long optionalId;
    private String title;
    private String muxingMode;
    private int numberOfChannels = 2;
    private int bitsDepth = 16;
    private int bitRate;
    private int sampleRate = 48000;
    private int videoDelay = 0;

    public Integer getStreamOrder() {
        return this.streamOrder;
    }

    public void setStreamOrder(Integer streamIndex) {
        this.streamOrder = streamIndex;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void setDefault(boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public boolean isForced() {
        return this.forcedFlag;
    }

    public void setForced(boolean forcedFlag) {
        this.forcedFlag = forcedFlag;
    }

    public Long getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Long optionalId) {
        this.optionalId = optionalId;
    }

    public int getBitDepth() {
        return this.bitsDepth;
    }

    public void setBitDepth(int bitsDepth) {
        this.bitsDepth = bitsDepth;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int bitRate) {
        this.bitRate = bitRate;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec != null ? codec.toLowerCase(Locale.ROOT) : null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getMuxingMode() {
        return this.muxingMode;
    }

    public void setMuxingMode(String muxingMode) {
        this.muxingMode = muxingMode;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public void setNumberOfChannels(int numberOfChannels) {
        if (numberOfChannels < 1) {
            throw new IllegalArgumentException("Channel number can't be less than 1.");
        }
        this.numberOfChannels = numberOfChannels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleFrequency) {
        if (sampleFrequency < 1) {
            throw new IllegalArgumentException("Sample frequency can't be less than 1 Hz.");
        }
        this.sampleRate = sampleFrequency;
    }

    public int getVideoDelay() {
        return this.videoDelay;
    }

    public void setVideoDelay(int videoDelay) {
        this.videoDelay = videoDelay;
    }

    public String getAudioCodec() {
        if (this.isAACLC()) {
            return "AAC-LC";
        }
        if (this.isAC3()) {
            return "AC3";
        }
        if (this.isACELP()) {
            return "ACELP";
        }
        if (this.isADPCM()) {
            return "ADPCM";
        }
        if (this.isAIFF()) {
            return "AIFF";
        }
        if (this.isALAC()) {
            return "ALAC";
        }
        if (this.isALS()) {
            return "ALS";
        }
        if (this.isAtmos()) {
            return "Atmos";
        }
        if (this.isATRAC()) {
            return "ATRAC";
        }
        if (this.isCook()) {
            return "Cook";
        }
        if (this.isDFF()) {
            return "DFF";
        }
        if (this.isDSF()) {
            return "DSF";
        }
        if (this.isDolbyE()) {
            return "Dolby E";
        }
        if (this.isDTS()) {
            return "DTS";
        }
        if (this.isDTSHD()) {
            return "DTS-HD";
        }
        if (this.isEAC3()) {
            return "Enhanced AC-3";
        }
        if (this.isERBSAC()) {
            return "ER BSAC";
        }
        if (this.isFLAC()) {
            return "FLAC";
        }
        if (this.isG729()) {
            return "G.729";
        }
        if (this.isHEAAC()) {
            return "HE-AAC";
        }
        if (this.isMLP()) {
            return "MLP";
        }
        if (this.isMonkeysAudio()) {
            return "Monkey's Audio";
        }
        if (this.isMP3()) {
            return "MP3";
        }
        if (this.isMpegAudio()) {
            return "Mpeg Audio";
        }
        if (this.isMPC()) {
            return "Musepack";
        }
        if (this.isOpus()) {
            return "Opus";
        }
        if (this.isPCM()) {
            return "LPCM";
        }
        if (this.isQDesign()) {
            return "QDesign";
        }
        if (this.isRealAudio144()) {
            return "RealAudio 14.4";
        }
        if (this.isRealAudio288()) {
            return "RealAudio 28.8";
        }
        if (this.isRALF()) {
            return "RealAudio Lossless";
        }
        if (this.isShorten()) {
            return "Shorten";
        }
        if (this.isSipro()) {
            return "Sipro";
        }
        if (this.isSLS()) {
            return "SLS";
        }
        if (this.isTrueHD()) {
            return "TrueHD";
        }
        if (this.isTTA()) {
            return "TTA";
        }
        if (this.isVorbis()) {
            return "Vorbis";
        }
        if (this.isWAV()) {
            return "WAV";
        }
        if (this.isWavPack()) {
            return "WavPack";
        }
        if (this.isWMA()) {
            return "WMA";
        }
        if (this.isWMA10()) {
            return "WMA 10";
        }
        if (this.isWMALossless()) {
            return "WMA Lossless";
        }
        if (this.isWMAPro()) {
            return "WMA Pro";
        }
        if (this.isWMAVoice()) {
            return "WMA Voice";
        }
        return this.getCodec() != null ? this.getCodec() : "-";
    }

    public boolean isAAC() {
        return this.isAACLC() || this.isHEAAC();
    }

    public boolean isAACLC() {
        return "aac-lc".equalsIgnoreCase(this.getCodec());
    }

    public boolean isAC3() {
        return "ac3".equalsIgnoreCase(this.getCodec()) || this.getCodec() != null && this.getCodec().contains("a52");
    }

    public boolean isAC4() {
        return "ac4".equalsIgnoreCase(this.getCodec());
    }

    public boolean isACELP() {
        return "acelp".equalsIgnoreCase(this.getCodec());
    }

    public boolean isADPCM() {
        return "adpcm".equalsIgnoreCase(this.getCodec());
    }

    public boolean isAIFF() {
        return "aiff".equalsIgnoreCase(this.getCodec());
    }

    public boolean isALAC() {
        return "alac".equalsIgnoreCase(this.getCodec());
    }

    public boolean isALS() {
        return "als".equalsIgnoreCase(this.getCodec());
    }

    public boolean isAtmos() {
        return "atmos".equalsIgnoreCase(this.getCodec());
    }

    public boolean isATRAC() {
        return "atrac".equalsIgnoreCase(this.getCodec());
    }

    public boolean isCook() {
        return "cook".equalsIgnoreCase(this.getCodec());
    }

    public boolean isDolbyE() {
        return "dolbye".equalsIgnoreCase(this.getCodec());
    }

    public boolean isDFF() {
        return "dff".equalsIgnoreCase(this.getCodec());
    }

    public boolean isDSF() {
        return "dsf".equalsIgnoreCase(this.getCodec());
    }

    public boolean isDTS() {
        return "dts".equalsIgnoreCase(this.getCodec()) || this.getCodec() != null && this.getCodec().contains("dca");
    }

    public boolean isDTSHD() {
        return "dtshd".equalsIgnoreCase(this.getCodec());
    }

    public boolean isEAC3() {
        return "eac3".equalsIgnoreCase(this.getCodec());
    }

    public boolean isERBSAC() {
        return "erbsac".equalsIgnoreCase(this.getCodec());
    }

    public boolean isFLAC() {
        return "flac".equalsIgnoreCase(this.getCodec());
    }

    public boolean isG729() {
        return "g729".equalsIgnoreCase(this.getCodec());
    }

    public boolean isHEAAC() {
        return "he-aac".equalsIgnoreCase(this.getCodec());
    }

    public boolean isMLP() {
        return "mlp".equalsIgnoreCase(this.getCodec());
    }

    public boolean isMonkeysAudio() {
        return "ape".equalsIgnoreCase(this.getCodec());
    }

    public boolean isMP3() {
        return "mp3".equalsIgnoreCase(this.getCodec());
    }

    public boolean isMpegAudio() {
        return "mp2".equalsIgnoreCase(this.getCodec()) || "mpa".equalsIgnoreCase(this.getCodec());
    }

    public boolean isMPC() {
        return "mpc".equalsIgnoreCase(this.getCodec());
    }

    public boolean isOpus() {
        return "opus".equalsIgnoreCase(this.getCodec());
    }

    public boolean isPCM() {
        return "lpcm".equals(this.getCodec()) || this.getCodec() != null && this.getCodec().startsWith("pcm");
    }

    public boolean isQDesign() {
        return "qdmc".equalsIgnoreCase(this.getCodec());
    }

    public boolean isRALF() {
        return "ralf".equalsIgnoreCase(this.getCodec());
    }

    public boolean isRealAudio144() {
        return "ra14.4".equalsIgnoreCase(this.getCodec());
    }

    public boolean isRealAudio288() {
        return "ra28.8".equalsIgnoreCase(this.getCodec());
    }

    public boolean isShorten() {
        return "shn".equalsIgnoreCase(this.getCodec());
    }

    public boolean isSipro() {
        return "sipro".equalsIgnoreCase(this.getCodec());
    }

    public boolean isSLS() {
        return "sls".equalsIgnoreCase(this.getCodec());
    }

    public boolean isTrueHD() {
        return "truehd".equalsIgnoreCase(this.getCodec());
    }

    public boolean isTTA() {
        return "tta".equalsIgnoreCase(this.getCodec());
    }

    public boolean isVorbis() {
        return "vorbis".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWAV() {
        return "wav".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWavPack() {
        return "wavpack".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWMA() {
        return "wma".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWMA10() {
        return "wma10".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWMALossless() {
        return "wmalossless".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWMAPro() {
        return "wmapro".equalsIgnoreCase(this.getCodec());
    }

    public boolean isWMAVoice() {
        return "wmavoice".equalsIgnoreCase(this.getCodec());
    }

    public boolean isNonPCMEncodedAudio() {
        return this.isAC3() || this.isAtmos() || this.isDTS() || this.isTrueHD() || this.isDTSHD();
    }

    public boolean isLossless() {
        return this.getCodec() != null && (this.isAIFF() || this.isALAC() || this.isALS() || this.isFLAC() || this.isMLP() || this.isMonkeysAudio() || this.isPCM() || this.isRALF() || this.isShorten() || this.isSLS() || this.isTrueHD() || this.isTTA() || this.isWAV() || this.isWavPack() || this.isWMALossless() || this.isDTSHD());
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("id", this.getId());
        result.addProperty("default", this.isDefault());
        result.addProperty("forced", this.isForced());
        if (StringUtils.isNotBlank(this.getTitle())) {
            result.addProperty("title", this.getTitle());
        }
        if (StringUtils.isNotBlank(this.getLang()) && !"und".equals(this.getLang())) {
            result.addProperty("lang", this.getLang());
        }
        result.addProperty("codec", this.getAudioCodec());
        result.addProperty("stream", this.getStreamOrder());
        result.addProperty("bitrate", this.getBitRate());
        result.addProperty("bitdepth", this.getBitDepth());
        result.addProperty("channel", this.getNumberOfChannels());
        result.addProperty("samplerate", this.getSampleRate());
        result.addProperty("muxing", this.getMuxingMode());
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Audio Id: ").append(this.getId());
        if (this.isDefault()) {
            result.append(", Default");
        }
        if (this.isForced()) {
            result.append(", Forced");
        }
        if (StringUtils.isNotBlank(this.getTitle())) {
            result.append(", Title: ").append(this.getTitle());
        }
        if (StringUtils.isNotBlank(this.getLang()) && !"und".equals(this.getLang())) {
            result.append(", Language Code: ").append(this.getLang());
        }
        result.append(", Codec: ").append(this.getAudioCodec());
        if (this.getOptionalId() != null && this.getOptionalId() > 10L) {
            result.append(", Optional Id: ").append(this.getOptionalId());
        }
        if (this.getStreamOrder() != null) {
            result.append(", Stream Order: ").append(this.getStreamOrder());
        }
        result.append(", Bitrate: ").append(this.getBitRate());
        if (this.getBitDepth() != 16) {
            result.append(", Bits per Sample: ").append(this.getBitDepth());
        }
        if (this.getNumberOfChannels() == 1) {
            result.append(", Channel: ").append(this.getNumberOfChannels());
        } else {
            result.append(", Channels: ").append(this.getNumberOfChannels());
        }
        result.append(", Sample Frequency: ").append(this.getSampleRate()).append(" Hz");
        if (this.getVideoDelay() != 0) {
            result.append(", Video Delay: ").append(this.getVideoDelay());
        }
        if (StringUtils.isNotBlank(this.getMuxingMode())) {
            result.append(", Muxing Mode: ").append(this.getMuxingMode());
        }
        return result.toString();
    }
}

