/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import net.pms.logging.UmsRollingPolicy;
import org.apache.commons.io.FileUtils;

public class UmsFileAppender<E>
extends RollingFileAppender<E> {
    @Override
    public void start() {
        this.savePreviousFile();
        super.start();
    }

    private void savePreviousFile() {
        if (!(this.getRollingPolicy() instanceof UmsRollingPolicy)) {
            return;
        }
        this.append = false;
        File currentFile = new File(this.getFile());
        if (currentFile.exists()) {
            String baseFileName = currentFile.getAbsolutePath() + ".zip";
            String savedFileName = currentFile.getAbsolutePath() + ".prev.zip";
            this.addInfo("The previous log will be compressed to [" + savedFileName + "].");
            this.getRollingPolicy().rollover();
            try {
                File newFile;
                File logFile = new File(savedFileName);
                if (logFile.exists()) {
                    FileUtils.deleteQuietly(logFile);
                }
                if ((logFile = new File(baseFileName)).exists() && !logFile.renameTo(newFile = new File(savedFileName))) {
                    this.addWarn("Could not rename \"" + baseFileName + "\" to \"" + savedFileName + "\"");
                }
            }
            catch (Exception e) {
                this.addWarn("Could not rename \"" + baseFileName + "\" to \"" + savedFileName + "\"", e);
            }
        }
    }
}

