/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.ErrorStatus;
import java.nio.charset.StandardCharsets;
import net.pms.gui.GuiManager;

public class GuiManagerAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private Encoder<E> encoder;

    @Override
    public void start() {
        boolean error = false;
        if (this.encoder == null) {
            error = true;
            this.addStatus(new ErrorStatus("No encoder set for the appender named [" + this.name + "].", this));
        }
        if (!error) {
            super.start();
        }
    }

    @Override
    protected synchronized void append(E eventObject) {
        String msg = new String(this.encoder.encode(eventObject), StandardCharsets.UTF_8);
        GuiManager.appendLog(msg);
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

