/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebounceTraceLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebounceTraceLogger.class);
    private Timer timer = new Timer();
    private long debounceDelay = 300L;

    public void log(final String logMessage) {
        try {
            this.timer.cancel();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LOGGER.trace(logMessage);
                }
            }, this.debounceDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

