/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.pms.io.BufferedOutputFile;
import net.pms.io.BufferedOutputFileImpl;
import net.pms.io.OutputConsumer;
import net.pms.io.OutputParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputBufferConsumer
extends OutputConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputBufferConsumer.class);
    private final BufferedOutputFile outputBuffer;
    private static final int PIPE_BUFFER_SIZE = 500000;

    public OutputBufferConsumer(InputStream inputStream, OutputParams params) {
        super(inputStream);
        this.outputBuffer = new BufferedOutputFileImpl(params);
    }

    @Override
    public void run() {
        try {
            int n;
            byte[] buf = new byte[500000];
            while ((n = this.inputStream.read(buf)) > 0) {
                this.outputBuffer.write(buf, 0, n);
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Error consuming stream of spawned process: " + ioe.getMessage());
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        }
    }

    @Override
    public BufferedOutputFile getBuffer() {
        return this.outputBuffer;
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

