/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.photoshop.PsdHeaderDirectory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

public class PSDInfo
extends ImageInfo {
    protected final ColorMode colorMode;
    protected final Integer channelCount;

    protected PSDInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.colorMode = ((PSDParseInfo)this.parsedInfo).colorMode;
        this.channelCount = ((PSDParseInfo)this.parsedInfo).channelCount;
    }

    protected PSDInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.colorMode = ((PSDParseInfo)this.parsedInfo).colorMode;
        this.channelCount = ((PSDParseInfo)this.parsedInfo).channelCount;
    }

    protected PSDInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.colorMode = ((PSDParseInfo)this.parsedInfo).colorMode;
        this.channelCount = ((PSDParseInfo)this.parsedInfo).channelCount;
    }

    protected PSDInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, ColorMode colorMode, Integer channelCount) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
        this.colorMode = colorMode;
        this.channelCount = channelCount;
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new PSDParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            Integer i;
            if (!(directory instanceof PsdHeaderDirectory)) continue;
            PsdHeaderDirectory psdHeaderDirectory = (PsdHeaderDirectory)directory;
            this.parsedInfo.format = ImageFormat.PSD;
            if (psdHeaderDirectory.containsTag(3) && psdHeaderDirectory.containsTag(2)) {
                this.parsedInfo.width = psdHeaderDirectory.getInteger(3);
                this.parsedInfo.height = psdHeaderDirectory.getInteger(2);
            }
            if (psdHeaderDirectory.containsTag(4) && (i = psdHeaderDirectory.getInteger(4)) != null) {
                this.parsedInfo.bitDepth = i;
            }
            if (psdHeaderDirectory.containsTag(5) && (i = psdHeaderDirectory.getInteger(5)) != null) {
                ((PSDParseInfo)this.parsedInfo).colorMode = ColorMode.typeOf(i);
                switch (((PSDParseInfo)this.parsedInfo).colorMode) {
                    case GRAYSCALE: {
                        this.parsedInfo.numComponents = 1;
                        this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_GRAY;
                        break;
                    }
                    case INDEXED: 
                    case RGB: {
                        this.parsedInfo.numComponents = 3;
                        this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                        break;
                    }
                    case CMYK: {
                        this.parsedInfo.numComponents = 4;
                        this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_CMYK;
                        break;
                    }
                    case LAB: {
                        this.parsedInfo.numComponents = 3;
                        this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_Lab;
                        break;
                    }
                }
            }
            if (!psdHeaderDirectory.containsTag(1) || (i = psdHeaderDirectory.getInteger(1)) == null) continue;
            ((PSDParseInfo)this.parsedInfo).channelCount = i;
        }
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public Integer getChannelCount() {
        return this.channelCount;
    }

    @Override
    public PSDInfo copy() {
        return new PSDInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport, this.colorMode, this.channelCount);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.colorMode != null) {
            sb.append(", Color Mode = ").append((Object)this.colorMode);
        }
        if (this.channelCount != null) {
            sb.append(", Channel Count = ").append(this.channelCount);
        }
    }

    protected static class PSDParseInfo
    extends ImageInfo.ParseInfo {
        ColorMode colorMode;
        Integer channelCount;

        protected PSDParseInfo() {
        }
    }

    public static enum ColorMode {
        BITMAP,
        GRAYSCALE,
        INDEXED,
        RGB,
        CMYK,
        MULTI_CHANNEL,
        DUOTONE,
        LAB;


        public static ColorMode typeOf(int value) {
            return switch (value) {
                case 0 -> BITMAP;
                case 1 -> GRAYSCALE;
                case 2 -> INDEXED;
                case 3 -> RGB;
                case 4 -> CMYK;
                case 7 -> MULTI_CHANNEL;
                case 8 -> DUOTONE;
                case 9 -> LAB;
                default -> null;
            };
        }
    }
}

