/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.ico.IcoDirectory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

public class ICOInfo
extends ImageInfo {
    protected ICOInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
    }

    protected ICOInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
    }

    protected ICOInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
    }

    protected ICOInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new ImageInfo.ParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof IcoDirectory)) continue;
            IcoDirectory icoDirectory = (IcoDirectory)directory;
            this.parsedInfo.format = ImageFormat.ICO;
            if (!icoDirectory.containsTag(2) || !icoDirectory.containsTag(3)) continue;
            this.parsedInfo.width = icoDirectory.getInteger(2);
            this.parsedInfo.height = icoDirectory.getInteger(3);
        }
    }

    @Override
    public ICOInfo copy() {
        return new ICOInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
    }
}

