/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum SubtitleType {
    UNKNOWN(0, "Generic", "Unknown", SubtitleType.list(new String[0]), SubtitleType.list(new String[0]), Category.UNDEF),
    SUBRIP(1, "SubRip", "SubRip", SubtitleType.list("srt"), SubtitleType.list("S_TEXT/UTF8", "S_UTF8", "Subrip"), Category.TEXT),
    TEXT(2, "Text", "Text", SubtitleType.list("txt"), SubtitleType.list(new String[0]), Category.TEXT),
    MICRODVD(3, "MicroDVD", "MicroDVD", SubtitleType.list("sub"), SubtitleType.list(new String[0]), Category.TEXT),
    SAMI(4, "Synchronized Accessible Media Interchange", "SAMI", SubtitleType.list("smi"), SubtitleType.list(new String[0]), Category.TEXT),
    ASS(5, "(Advanced) Sub Station Alpha", "SSA", SubtitleType.list("ass", "ssa"), SubtitleType.list("S_TEXT/SSA", "S_TEXT/ASS", "S_SSA", "S_ASS", "SSA", "ASS"), Category.TEXT),
    VOBSUB(6, "VobSub", "VobSub", SubtitleType.list("idx"), SubtitleType.list("S_VOBSUB", "subp", "mp4s", "E0", "RLE"), Category.PICTURE),
    UNSUPPORTED(7, "Unsupported", "Unsupported", SubtitleType.list(new String[0]), SubtitleType.list(new String[0]), Category.UNDEF),
    USF(8, "Universal Subtitle Format", "USF", SubtitleType.list(new String[0]), SubtitleType.list("S_TEXT/USF", "S_USF"), Category.TEXT),
    BMP(9, "Bitmap", "BMP", SubtitleType.list(new String[0]), SubtitleType.list("S_IMAGE/BMP"), Category.PICTURE),
    DIVX(10, "DivX subtitles", "DIVX", SubtitleType.list(new String[0]), SubtitleType.list("DXSB"), Category.PICTURE),
    TX3G(11, "3GPP Timed Text", "TX3G", SubtitleType.list(new String[0]), SubtitleType.list("tx3g"), Category.TEXT),
    PGS(12, "Presentation Graphic Stream", "PGS", SubtitleType.list("sup"), SubtitleType.list("S_HDMV/PGS", "PGS", "144"), Category.PICTURE),
    WEBVTT(13, "Web Video Text Tracks", "WebVTT", SubtitleType.list("vtt"), SubtitleType.list("WebVTT", "S_TEXT/WEBVTT"), Category.TEXT),
    TEXTST(14, "HDMV Text SubTitles", "HDMV", SubtitleType.list(new String[0]), SubtitleType.list("S_HDMV/TEXTST"), Category.TEXT),
    DVBSUB(15, "DVB Subtitles", "DVB", SubtitleType.list(new String[0]), SubtitleType.list("S_DVBSUB"), Category.PICTURE),
    EIA608(16, "EIA-608 subtitles", "EIA-608", SubtitleType.list(new String[0]), SubtitleType.list("EIA-608"), Category.TEXT);

    private static final Map<Integer, SubtitleType> STABLE_INDEX_TO_SUBTITLE_TYPE_MAP;
    private static final Map<String, SubtitleType> FILE_EXTENSION_TO_SUBTITLE_TYPE_MAP;
    private static final Map<String, SubtitleType> LIBMEDIAINFO_CODEC_TO_SUBTITLE_TYPE_MAP;
    private final int index;
    private final String description;
    private final String shortName;
    private final List<String> fileExtensions;
    private final List<String> libMediaInfoCodecs;
    private final Category category;
    public static final Set<String> SUPPORTED_FILE_EXTENSIONS;

    private static List<String> list(String ... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }

    public static SubtitleType valueOfStableIndex(int stableIndex) {
        SubtitleType subtitleType = STABLE_INDEX_TO_SUBTITLE_TYPE_MAP.get(stableIndex);
        if (subtitleType == null) {
            subtitleType = UNKNOWN;
        }
        return subtitleType;
    }

    public static SubtitleType valueOfFileExtension(String fileExtension) {
        if (StringUtils.isBlank(fileExtension)) {
            return UNKNOWN;
        }
        SubtitleType subtitleType = FILE_EXTENSION_TO_SUBTITLE_TYPE_MAP.get(fileExtension.toLowerCase());
        if (subtitleType == null) {
            subtitleType = UNKNOWN;
        }
        return subtitleType;
    }

    public static SubtitleType valueOfMediaInfoValue(String value) {
        return SubtitleType.valueOfMediaInfoValue(value, UNKNOWN);
    }

    public static SubtitleType valueOfMediaInfoValue(String value, SubtitleType defaultType) {
        if (StringUtils.isBlank(value)) {
            return defaultType;
        }
        SubtitleType subtitleType = LIBMEDIAINFO_CODEC_TO_SUBTITLE_TYPE_MAP.get(StringUtils.trim(value).toLowerCase(Locale.ROOT));
        if (subtitleType == null) {
            subtitleType = defaultType;
        }
        return subtitleType;
    }

    public static Set<String> getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    private SubtitleType(int index, String description, String shortName, List<String> fileExtensions, List<String> libMediaInfoCodecs, Category category) {
        this.index = index;
        this.description = description;
        this.shortName = shortName;
        this.fileExtensions = fileExtensions;
        this.libMediaInfoCodecs = libMediaInfoCodecs;
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getExtension() {
        if (this.fileExtensions.isEmpty()) {
            return "";
        }
        return this.fileExtensions.get(0);
    }

    public int getStableIndex() {
        return this.index;
    }

    public boolean isText() {
        return this.category == Category.TEXT;
    }

    public boolean isPicture() {
        return this.category == Category.PICTURE;
    }

    static {
        STABLE_INDEX_TO_SUBTITLE_TYPE_MAP = new HashMap<Integer, SubtitleType>();
        FILE_EXTENSION_TO_SUBTITLE_TYPE_MAP = new HashMap<String, SubtitleType>();
        LIBMEDIAINFO_CODEC_TO_SUBTITLE_TYPE_MAP = new HashMap<String, SubtitleType>();
        for (SubtitleType subtitleType : SubtitleType.values()) {
            STABLE_INDEX_TO_SUBTITLE_TYPE_MAP.put(subtitleType.getStableIndex(), subtitleType);
            for (String fileExtension : subtitleType.fileExtensions) {
                FILE_EXTENSION_TO_SUBTITLE_TYPE_MAP.put(fileExtension.toLowerCase(Locale.ROOT), subtitleType);
            }
            for (String codec : subtitleType.libMediaInfoCodecs) {
                LIBMEDIAINFO_CODEC_TO_SUBTITLE_TYPE_MAP.put(codec.toLowerCase(Locale.ROOT), subtitleType);
            }
        }
        SUPPORTED_FILE_EXTENSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(FILE_EXTENSION_TO_SUBTITLE_TYPE_MAP.keySet()));
    }

    public static enum Category {
        TEXT,
        PICTURE,
        UNDEF;

    }
}

