/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats;

import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.FileUtil;

public class WEB
extends Format {
    protected String url = null;

    @Override
    public Format.Identifier getIdentifier() {
        return Format.Identifier.WEB;
    }

    @Override
    public boolean match(String filename) {
        String protocol = FileUtil.getProtocol(filename);
        if (protocol == null) {
            return false;
        }
        this.url = filename;
        this.setMatchedExtension(protocol);
        return true;
    }

    @Override
    public boolean transcodable() {
        return true;
    }

    @Override
    public boolean isCompatible(StoreItem resource, Renderer renderer) {
        return this.type == 2;
    }

    @Override
    public String mimeType() {
        Format f;
        if (this.url != null && (f = FormatFactory.getAssociatedFormat("." + FileUtil.getUrlExtension(this.url))) != null) {
            return f.mimeType();
        }
        return super.mimeType();
    }
}

