/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.tmdb;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.find.FindExternalSource;
import com.universalmediaserver.tmdbapi.endpoint.movie.MovieIdAppendToResponse;
import com.universalmediaserver.tmdbapi.endpoint.movie.MovieIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.search.SearchMovieEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.search.SearchTvEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.TvIdAppendToResponse;
import com.universalmediaserver.tmdbapi.endpoint.tv.episode.TvEpisodeAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.IntegerIdNameSchema;
import com.universalmediaserver.tmdbapi.schema.collection.CollectionDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.configuration.ConfigurationSchema;
import com.universalmediaserver.tmdbapi.schema.country.CountrySimpleSchema;
import com.universalmediaserver.tmdbapi.schema.find.FindSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieReleaseDateSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieReleaseDatesResultSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieReleaseDatesSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortResultsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTypedSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonJobCreditSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonRoleCreditSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvAlternativeTitleSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvContentRatingSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvContentRatingsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleResultsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTypedSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeTypedSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonDetailsSchema;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFailedLookups;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.external.umsapi.APIUtils;
import net.pms.gui.GuiManager;
import net.pms.logging.DebounceTraceLogger;
import net.pms.media.MediaInfo;
import net.pms.media.video.metadata.ApiStringArray;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaStore;
import net.pms.store.MediaStoreIds;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileNameMetadata;
import net.pms.util.FileUtil;
import net.pms.util.ImdbUtil;
import net.pms.util.SimpleThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(TMDB.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final TMDbClient CLIENT = new TMDbClient();
    private static final Gson GSON = new Gson();
    private static final DebounceTraceLogger DEBOUNCED_TRACE_LOGGER = new DebounceTraceLogger();
    private static final ThreadPoolExecutor BACKGROUND_EXECUTOR = new ThreadPoolExecutor(0, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SimpleThreadFactory("Lookup TMDB Metadata background worker", "Lookup TMDB Metadata background workers group", 4));
    private static String tmdbImageBaseURL;

    private TMDB() {
    }

    public static boolean isReady() {
        if (!CONFIGURATION.isUseInfoFromTMDB() || StringUtils.isBlank(CONFIGURATION.getTmdbApiKey())) {
            return false;
        }
        if (!CONFIGURATION.getTmdbApiKey().equals(CLIENT.getApiKey())) {
            CLIENT.setApiKey(CONFIGURATION.getTmdbApiKey());
        }
        return true;
    }

    private static boolean shouldLookupAndAddMetadata(File file, MediaInfo mediaInfo) {
        if (BACKGROUND_EXECUTOR.isShutdown()) {
            DEBOUNCED_TRACE_LOGGER.log("Not doing background API lookup because background executor is shut down");
            return false;
        }
        if (!CONFIGURATION.getExternalNetwork()) {
            DEBOUNCED_TRACE_LOGGER.log("Not doing background API lookup because external network is disabled");
            return false;
        }
        if (!MediaDatabase.isAvailable()) {
            DEBOUNCED_TRACE_LOGGER.log("Not doing background API lookup because database is closed");
            return false;
        }
        if (!CONFIGURATION.isUseInfoFromTMDB()) {
            DEBOUNCED_TRACE_LOGGER.log("Not doing background TMDB lookup because isUseInfoFromTMDB is disabled, passing to UMS API");
            APIUtils.backgroundLookupAndAddMetadata(file, mediaInfo);
            return false;
        }
        if (!TMDB.isReady()) {
            DEBOUNCED_TRACE_LOGGER.log("Not doing background TMDB lookup because no/bad api key found, passing to UMS API");
            APIUtils.backgroundLookupAndAddMetadata(file, mediaInfo);
            return false;
        }
        return true;
    }

    public static void backgroundLookupAndAddMetadata(File file, MediaInfo mediaInfo) {
        if (!TMDB.shouldLookupAndAddMetadata(file, mediaInfo)) {
            return;
        }
        long elapsed = System.currentTimeMillis() - mediaInfo.getLastExternalLookup();
        if (elapsed < 300000L) {
            return;
        }
        mediaInfo.setLastExternalLookup(System.currentTimeMillis());
        Runnable r = () -> {
            try {
                MediaStore.waitWorkers();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!TMDB.shouldLookupAndAddMetadata(file, mediaInfo)) {
                return;
            }
            try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
                if (connection == null) {
                    return;
                }
                if (MediaTableVideoMetadata.doesLatestApiMetadataExist(connection, file.getAbsolutePath(), file.lastModified())) {
                    LOGGER.trace("The latest metadata already exists for {}", (Object)file.getName());
                    return;
                }
                if (MediaTableFailedLookups.hasLookupFailedRecently(connection, file.getAbsolutePath(), true)) {
                    LOGGER.trace("Lookup recently failed for {}", (Object)file.getName());
                    return;
                }
                GuiManager.setSecondaryStatusLine(Messages.getString("GettingTMDBInfoFor") + " " + file.getName());
                connection.setAutoCommit(false);
                if (mediaInfo.hasVideoMetadata() && mediaInfo.getVideoMetadata().isTvEpisode()) {
                    TMDB.lookupAndAddTvEpisodeMetadata(connection, file, mediaInfo);
                } else {
                    TMDB.lookupAndAddMovieMetadata(connection, file, mediaInfo);
                }
                TMDB.exitLookupAndAddMetadata(connection);
            }
            catch (SQLException ex) {
                LOGGER.trace("Error in TMDB parsing:", ex);
            }
        };
        LOGGER.trace("Queuing background TMDB lookup for {}", (Object)file.getName());
        BACKGROUND_EXECUTOR.execute(r);
    }

    private static void exitLookupAndAddMetadata(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOGGER.error("Error in commit in TMDB.backgroundLookupAndAddMetadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        GuiManager.setSecondaryStatusLine(null);
    }

    private static void lookupAndAddMovieMetadata(Connection connection, File file, MediaInfo mediaInfo) throws SQLException {
        MovieDetailsSchema movieDetails;
        MediaVideoMetadata videoMetadata = mediaInfo.hasVideoMetadata() ? mediaInfo.getVideoMetadata() : new MediaVideoMetadata();
        Integer year = videoMetadata.getYear();
        String titleFromFilename = videoMetadata.getTitle();
        try {
            String yearRegex;
            int yearIndex;
            String imdbID = ImdbUtil.extractImdbId(file.toPath(), false);
            if (StringUtils.isBlank(titleFromFilename)) {
                titleFromFilename = FileUtil.getFileNameWithoutExtension(file.getName());
            }
            if ((yearIndex = FileUtil.indexOf(Pattern.compile("\\s\\(" + (yearRegex = year != null ? year.toString() : "(?:19|20)\\d{2}") + "\\)"), titleFromFilename)) > -1) {
                titleFromFilename = titleFromFilename.substring(0, yearIndex);
            }
            if ((movieDetails = TMDB.getMovieInfo(titleFromFilename, year, imdbID)) == null) {
                LOGGER.trace("Failed TMDB lookup for " + file.getName());
                MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "", true);
                return;
            }
            LOGGER.trace("Found a TMDB match for " + file.getName());
        }
        catch (IOException ex) {
            LOGGER.debug("Likely transient error", ex);
            return;
        }
        LOGGER.trace("TMDB data matches filename data for " + file.getName());
        Long fileId = MediaTableFiles.getFileId(connection, file.getAbsolutePath(), file.lastModified());
        TMDB.setMovieMetadata(connection, fileId, mediaInfo, movieDetails);
        MediaStoreIds.incrementUpdateIdForFilename(connection, file.getAbsolutePath());
        LOGGER.info("TMDB lookups remaining: {}", (Object)BACKGROUND_EXECUTOR.getQueue().size());
    }

    private static void setMovieMetadata(Connection connection, Long fileId, MediaInfo mediaInfo, MovieDetailsSchema movieDetails) throws SQLException {
        MediaVideoMetadata videoMetadata = mediaInfo.hasVideoMetadata() ? mediaInfo.getVideoMetadata() : new MediaVideoMetadata();
        String titleFromFilename = videoMetadata.getTitle();
        String title = StringUtils.isNotBlank(movieDetails.getTitle()) ? movieDetails.getTitle() : titleFromFilename;
        videoMetadata.setFileId(fileId);
        videoMetadata.setTitle(title);
        videoMetadata.setYear(FileUtil.getYearFromYearString(movieDetails.getReleaseDate()));
        videoMetadata.setIMDbID(movieDetails.getImdbId());
        videoMetadata.setTmdbId(movieDetails.getId());
        String posterFromTMDB = TMDB.getPosterUrl(movieDetails.getPosterPath());
        if (posterFromTMDB != null) {
            videoMetadata.setPoster(posterFromTMDB);
        }
        if (movieDetails.getCredits() != null && movieDetails.getCredits().getCast() != null) {
            videoMetadata.setActors(TMDB.getActors(movieDetails.getCredits().getCast()));
        }
        videoMetadata.setBudget(movieDetails.getBudget());
        if (movieDetails.getProductionCountries() != null) {
            videoMetadata.setCountries(TMDB.getCountries(movieDetails.getProductionCountries()));
        }
        if (movieDetails.getCredits() != null) {
            videoMetadata.setCredits("[" + GSON.toJson(movieDetails.getCredits()) + "]");
        }
        if (movieDetails.getCredits() != null && movieDetails.getCredits().getCrew() != null) {
            videoMetadata.setDirectors(TMDB.getDirectors(movieDetails.getCredits().getCrew()));
        }
        if (movieDetails.getExternalIds() != null) {
            videoMetadata.setExternalIDs("[" + GSON.toJson(movieDetails.getExternalIds()) + "]");
        }
        videoMetadata.setGenres(TMDB.getApiStringArrayFromList(movieDetails.getGenres()));
        videoMetadata.setHomepage(movieDetails.getHomepage());
        if (movieDetails.getImages() != null) {
            videoMetadata.setImages("[" + GSON.toJson(movieDetails.getImages()) + "]");
        }
        videoMetadata.setOriginalLanguage(movieDetails.getOriginalLanguage());
        videoMetadata.setOriginalTitle(movieDetails.getOriginalTitle());
        videoMetadata.setOverview(movieDetails.getOverview());
        if (movieDetails.getProductionCompanies() != null) {
            videoMetadata.setProductionCompanies(GSON.toJson(movieDetails.getProductionCompanies()));
        }
        if (movieDetails.getProductionCountries() != null) {
            videoMetadata.setProductionCountries(GSON.toJson(movieDetails.getProductionCountries()));
        }
        if (movieDetails.getReleaseDates() != null) {
            videoMetadata.setRated(TMDB.getUsCertification(movieDetails.getReleaseDates()));
        }
        videoMetadata.setRating(movieDetails.getVoteAverage());
        videoMetadata.setReleased(movieDetails.getReleaseDate());
        videoMetadata.setRevenue(movieDetails.getRevenue());
        videoMetadata.setTagline(movieDetails.getTagline());
        videoMetadata.setVotes(movieDetails.getVoteCount().toString());
        videoMetadata.setTranslations(null);
        mediaInfo.setVideoMetadata(videoMetadata);
        MediaTableVideoMetadataLocalized.clearVideoMetadataLocalized(connection, fileId, false);
        LOGGER.trace("setting movie metadata for " + title);
        MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, fileId, mediaInfo, true);
        videoMetadata.ensureHavingTranslation(null);
        if (!StringUtils.isBlank(videoMetadata.getPoster(null))) {
            mediaInfo.waitMediaParsing(5);
            mediaInfo.setParsing(true);
            DLNAThumbnail thumbnail = JavaHttpClient.getThumbnail(videoMetadata.getPoster(null));
            if (thumbnail != null) {
                Long thumbnailId = ThumbnailStore.getId(thumbnail);
                mediaInfo.setThumbnailSource(ThumbnailSource.TMDB_LOC);
                mediaInfo.setThumbnailId(thumbnailId);
                MediaTableFiles.updateThumbnailId(connection, fileId, thumbnailId, ThumbnailSource.TMDB_LOC.toString());
            }
            mediaInfo.setParsing(false);
        }
    }

    private static void lookupAndAddTvEpisodeMetadata(Connection connection, File file, MediaInfo mediaInfo) throws SQLException {
        Integer tvEpisodeNumberFromTMDB;
        TvEpisodeDetailsSchema tvEpisodeDetails;
        Long tvShowId;
        MediaVideoMetadata videoMetadata;
        MediaVideoMetadata mediaVideoMetadata = videoMetadata = mediaInfo.hasVideoMetadata() ? mediaInfo.getVideoMetadata() : new MediaVideoMetadata();
        if (videoMetadata.getTvSeriesId() == null) {
            Integer startYearFromFilename;
            FileNameMetadata metadataFromFilename = FileUtil.getFileNameMetadata(file.getName(), file.getAbsolutePath());
            String titleFromFilename = metadataFromFilename.getMovieOrShowName();
            Long tvSeriesId = MediaTableTVSeries.getIdBySimilarTitle(connection, titleFromFilename, startYearFromFilename = metadataFromFilename.getYear());
            if (tvSeriesId == null) {
                tvSeriesId = MediaTableTVSeries.set(connection, titleFromFilename, startYearFromFilename);
            }
            videoMetadata.setTvSeriesId(tvSeriesId);
        }
        if (videoMetadata.getSeriesMetadata() == null) {
            TvSeriesMetadata tvSeriesMetadata = MediaInfoStore.getTvSeriesMetadata(videoMetadata.getTvSeriesId());
            videoMetadata.setSeriesMetadata(tvSeriesMetadata);
        }
        Long l = tvShowId = videoMetadata.getSeriesMetadata() != null ? videoMetadata.getSeriesMetadata().getTmdbId() : null;
        if (tvShowId == null) {
            String yearRegex;
            int yearIndex;
            int yearIndex2;
            String showNameFromFilename = videoMetadata.getMovieOrShowName();
            Integer tvSeriesStartYear = videoMetadata.getTvSeriesStartYear();
            if (tvSeriesStartYear != null && (yearIndex2 = FileUtil.indexOf(Pattern.compile("\\s\\(" + tvSeriesStartYear + "\\)"), showNameFromFilename)) == -1) {
                tvSeriesStartYear = null;
            }
            String imdbId = ImdbUtil.extractImdbId(file.toPath(), false);
            if (StringUtils.isBlank(showNameFromFilename)) {
                showNameFromFilename = FileUtil.getFileNameWithoutExtension(file.getName());
            }
            if ((yearIndex = FileUtil.indexOf(Pattern.compile("\\s\\(" + (yearRegex = tvSeriesStartYear != null ? tvSeriesStartYear.toString() : "(?:19|20)\\d{2}") + "\\)"), showNameFromFilename)) > -1) {
                showNameFromFilename = showNameFromFilename.substring(0, yearIndex);
            }
            try {
                tvShowId = MediaTableTVSeries.getTmdbIdByTitle(connection, showNameFromFilename, tvSeriesStartYear);
                if (tvShowId == null) {
                    Object failedLookupKey = showNameFromFilename;
                    if (imdbId != null) {
                        LOGGER.trace("Failed lookup for " + file.getName());
                        failedLookupKey = (String)failedLookupKey + imdbId;
                    }
                    if (MediaTableFailedLookups.hasLookupFailedRecently(connection, (String)failedLookupKey, false)) {
                        return;
                    }
                    TvDetailsSchema tvDetails = TMDB.getTvShowFromEpisode(showNameFromFilename, tvSeriesStartYear, imdbId);
                    if (tvDetails == null) {
                        LOGGER.trace("Failed lookup for " + file.getName());
                        LOGGER.trace("Did not find matching series for the episode in TMDB for {}", (Object)file.getName());
                        MediaTableFailedLookups.set(connection, (String)failedLookupKey, "tvShow not found", false);
                        MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "tvShow not found", true);
                        return;
                    }
                    tvShowId = tvDetails.getId();
                    TMDB.insertTvShowMetadata(connection, showNameFromFilename, videoMetadata, tvDetails);
                }
                TvSeriesMetadata tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadataFromTmdbId(connection, tvShowId);
                videoMetadata.setTvSeriesId(tvSeriesMetadata.getTvSeriesId());
                videoMetadata.setTmdbTvId(tvShowId);
                videoMetadata.setSeriesMetadata(MediaInfoStore.getTvSeriesMetadata(tvSeriesMetadata.getTvSeriesId()));
            }
            catch (IOException ex) {
                LOGGER.debug("Likely transient error", ex);
                return;
            }
        } else if (videoMetadata.getTmdbTvId() == null) {
            videoMetadata.setTmdbTvId(tvShowId);
        }
        Integer tvEpisodeNumberFromFilename = videoMetadata.getFirstTvEpisodeNumber();
        if (videoMetadata.getTvSeason() == null) {
            LOGGER.trace("Failed lookup for " + file.getName());
            MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "season number missing", true);
            return;
        }
        if (tvEpisodeNumberFromFilename == null) {
            LOGGER.trace("Failed lookup for " + file.getName());
            MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "episodeNumber missing", true);
            return;
        }
        try {
            tvEpisodeDetails = TMDB.getTvEpisodeInfo(tvShowId, videoMetadata.getTvSeason(), tvEpisodeNumberFromFilename);
        }
        catch (IOException ex) {
            LOGGER.debug("Likely transient error", ex);
            return;
        }
        if (tvEpisodeDetails == null) {
            LOGGER.trace("Failed lookup for " + file.getName());
            MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "tvEpisode not found", true);
            return;
        }
        LOGGER.trace("Found an TMDB match for " + file.getName());
        Integer tvSeasonFromTMDB = tvEpisodeDetails.getSeasonNumber() != null ? Integer.valueOf(tvEpisodeDetails.getSeasonNumber().intValue()) : null;
        Integer n = tvEpisodeNumberFromTMDB = tvEpisodeDetails.getEpisodeNumber() != null ? Integer.valueOf(tvEpisodeDetails.getEpisodeNumber().intValue()) : null;
        if (!videoMetadata.getTvSeason().equals(tvSeasonFromTMDB) || !tvEpisodeNumberFromFilename.equals(tvEpisodeNumberFromTMDB)) {
            LOGGER.debug("TMDB data was different to our parsed data, not storing it.");
            MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "Data mismatch", true);
            LOGGER.trace("Filename data: " + String.valueOf(mediaInfo));
            LOGGER.trace("TMDB data: " + String.valueOf(tvEpisodeDetails));
            return;
        }
        mediaInfo.setVideoMetadata(videoMetadata);
        LOGGER.trace("TMDB data matches filename data for " + file.getName());
        Long fileId = MediaTableFiles.getFileId(connection, file.getAbsolutePath(), file.lastModified());
        TMDB.setTvEpisodeMetadata(connection, fileId, mediaInfo, tvEpisodeDetails);
        MediaStoreIds.incrementUpdateIdForFilename(connection, file.getAbsolutePath());
        LOGGER.info("TMDB lookups remaining: {}", (Object)BACKGROUND_EXECUTOR.getQueue().size());
    }

    private static void setTvEpisodeMetadata(Connection connection, Long fileId, MediaInfo mediaInfo, TvEpisodeDetailsSchema tvEpisodeDetails) throws SQLException {
        MediaVideoMetadata videoMetadata = mediaInfo.hasVideoMetadata() ? mediaInfo.getVideoMetadata() : new MediaVideoMetadata();
        String tvEpisodeTitleFromTMDB = tvEpisodeDetails.getName();
        Integer tvSeasonFromTMDB = tvEpisodeDetails.getSeasonNumber().intValue();
        Integer tvEpisodeNumberFromTMDB = tvEpisodeDetails.getEpisodeNumber().intValue();
        if (StringUtils.isNotBlank(tvEpisodeTitleFromTMDB)) {
            LOGGER.trace("Setting episode name from TMDB: " + tvEpisodeTitleFromTMDB);
            videoMetadata.setTitle(tvEpisodeTitleFromTMDB);
        }
        videoMetadata.setYear(FileUtil.getYearFromYearString(tvEpisodeDetails.getAirDate()));
        videoMetadata.setTmdbId(tvEpisodeDetails.getId());
        videoMetadata.setIMDbID(tvEpisodeDetails.getExternalIds() != null ? tvEpisodeDetails.getExternalIds().getImdbId() : null);
        String posterFromTMDB = TMDB.getStillUrl(tvEpisodeDetails.getStillPath());
        if (posterFromTMDB != null) {
            videoMetadata.setPoster(posterFromTMDB);
        }
        videoMetadata.setTvSeason(tvSeasonFromTMDB);
        videoMetadata.setTvEpisodeNumber(tvEpisodeNumberFromTMDB.toString());
        if (tvEpisodeDetails.getCredits() != null && tvEpisodeDetails.getCredits().getCast() != null) {
            videoMetadata.setActors(TMDB.getActors(tvEpisodeDetails.getCredits().getCast()));
        }
        if (tvEpisodeDetails.getCredits() != null) {
            videoMetadata.setCredits("[" + GSON.toJson(tvEpisodeDetails.getCredits()) + "]");
        }
        if (tvEpisodeDetails.getCredits() != null && tvEpisodeDetails.getCredits().getCrew() != null) {
            videoMetadata.setDirectors(TMDB.getDirectors(tvEpisodeDetails.getCredits().getCrew()));
        }
        videoMetadata.setExternalIDs("[" + GSON.toJson(tvEpisodeDetails.getExternalIds()) + "]");
        if (tvEpisodeDetails.getImages() != null) {
            videoMetadata.setImages("[" + GSON.toJson(tvEpisodeDetails.getImages()) + "]");
        }
        videoMetadata.setOverview(tvEpisodeDetails.getOverview());
        videoMetadata.setVotes(tvEpisodeDetails.getVoteAverage().toString());
        videoMetadata.setTranslations(null);
        mediaInfo.setVideoMetadata(videoMetadata);
        MediaTableVideoMetadataLocalized.clearVideoMetadataLocalized(connection, fileId, false);
        LOGGER.trace("setting tv episode metadata for " + videoMetadata.getTvSeriesTitle() + " " + tvSeasonFromTMDB + "-" + tvEpisodeNumberFromTMDB);
        MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, fileId, mediaInfo, true);
        videoMetadata.ensureHavingTranslation(null);
        if (!StringUtils.isBlank(videoMetadata.getPoster(null))) {
            mediaInfo.waitMediaParsing(5);
            mediaInfo.setParsing(true);
            DLNAThumbnail thumbnail = JavaHttpClient.getThumbnail(videoMetadata.getPoster(null));
            if (thumbnail != null) {
                Long thumbnailId = ThumbnailStore.getId(thumbnail);
                mediaInfo.setThumbnailSource(ThumbnailSource.TMDB_LOC);
                mediaInfo.setThumbnailId(thumbnailId);
                MediaTableFiles.updateThumbnailId(connection, fileId, thumbnailId, ThumbnailSource.TMDB_LOC.toString());
            }
            mediaInfo.setParsing(false);
        }
    }

    private static TvSeriesMetadata setTvShowMetadata(Connection connection, TvDetailsSchema tvDetails) {
        DLNAThumbnail thumbnail;
        Integer startYear;
        if (tvDetails == null) {
            return null;
        }
        String title = tvDetails.getName();
        Long tvSeriesId = MediaTableTVSeries.set(connection, title, startYear = TMDB.getYear(tvDetails.getFirstAirDate()));
        if (tvSeriesId == null) {
            LOGGER.debug("tvSeriesDatabaseId was not set, something went wrong");
            return null;
        }
        TvSeriesMetadata tvSeriesMetadata = new TvSeriesMetadata();
        tvSeriesMetadata.setTvSeriesId(tvSeriesId);
        if (tvDetails.getCredits() != null && tvDetails.getCredits().getCast() != null) {
            tvSeriesMetadata.setActors(TMDB.getActors(tvDetails.getCredits().getCast()));
        }
        tvSeriesMetadata.setCountries(TMDB.getApiStringArrayFromStringList(tvDetails.getOriginCountry()));
        tvSeriesMetadata.setCreatedBy(GSON.toJson(tvDetails.getCreatedBy()));
        if (tvDetails.getCredits() != null) {
            tvSeriesMetadata.setCredits("[" + GSON.toJson(tvDetails.getCredits()) + "]");
        }
        if (Boolean.FALSE.equals(tvDetails.getInProduction())) {
            Integer endYear = TMDB.getYear(tvDetails.getLastAirDate());
            tvSeriesMetadata.setEndYear(endYear);
        }
        if (tvDetails.getExternalIds() != null) {
            tvSeriesMetadata.setExternalIDs("[" + GSON.toJson(tvDetails.getExternalIds()) + "]");
        }
        tvSeriesMetadata.setFirstAirDate(tvDetails.getFirstAirDate());
        tvSeriesMetadata.setGenres(TMDB.getApiStringArrayFromList(tvDetails.getGenres()));
        tvSeriesMetadata.setHomepage(tvDetails.getHomepage());
        if (tvDetails.getImages() != null) {
            tvSeriesMetadata.setImages("[" + GSON.toJson(tvDetails.getImages()) + "]");
        }
        tvSeriesMetadata.setIMDbID(tvDetails.getExternalIds() != null ? tvDetails.getExternalIds().getImdbId() : null);
        tvSeriesMetadata.setInProduction(tvDetails.getInProduction());
        tvSeriesMetadata.setLanguages(TMDB.getApiStringArrayFromStringList(tvDetails.getLanguages()));
        tvSeriesMetadata.setLastAirDate(tvDetails.getLastAirDate());
        if (tvDetails.getNetworks() != null) {
            tvSeriesMetadata.setNetworks(GSON.toJson(tvDetails.getNetworks()));
        }
        tvSeriesMetadata.setNumberOfEpisodes(tvDetails.getNumberOfEpisodes().doubleValue());
        tvSeriesMetadata.setNumberOfSeasons(tvDetails.getNumberOfSeasons().doubleValue());
        tvSeriesMetadata.setOriginCountry(TMDB.getApiStringArrayFromStringList(tvDetails.getOriginCountry()));
        tvSeriesMetadata.setOriginalLanguage(tvDetails.getOriginalLanguage());
        tvSeriesMetadata.setOriginalTitle(tvDetails.getOriginalName());
        tvSeriesMetadata.setOverview(tvDetails.getOverview());
        String posterFromTMDB = TMDB.getPosterUrl(tvDetails.getPosterPath());
        tvSeriesMetadata.setPoster(posterFromTMDB);
        if (tvDetails.getProductionCompanies() != null) {
            tvSeriesMetadata.setProductionCompanies(GSON.toJson(tvDetails.getProductionCompanies()));
        }
        if (tvDetails.getProductionCountries() != null) {
            tvSeriesMetadata.setProductionCountries(GSON.toJson(tvDetails.getProductionCountries()));
        }
        tvSeriesMetadata.setRated(TMDB.getUsContentRating(tvDetails.getContentRatings()));
        tvSeriesMetadata.setRating(tvDetails.getVoteAverage());
        if (tvDetails.getSeasons() != null) {
            tvSeriesMetadata.setSeasons(GSON.toJson(tvDetails.getSeasons()));
        }
        tvSeriesMetadata.setSeriesType(tvDetails.getType());
        if (tvDetails.getSpokenLanguages() != null) {
            tvSeriesMetadata.setSpokenLanguages(GSON.toJson(tvDetails.getSpokenLanguages()));
        }
        tvSeriesMetadata.setStartYear(startYear);
        tvSeriesMetadata.setStatus(tvDetails.getStatus());
        tvSeriesMetadata.setTagline(tvDetails.getTagline());
        tvSeriesMetadata.setTmdbId(tvDetails.getId());
        tvSeriesMetadata.setTitle(tvDetails.getName());
        tvSeriesMetadata.setTotalSeasons(tvDetails.getNumberOfSeasons().doubleValue());
        tvSeriesMetadata.setVotes(tvDetails.getVoteCount().toString());
        tvSeriesMetadata.setTranslations(null);
        MediaTableVideoMetadataLocalized.clearVideoMetadataLocalized(connection, tvSeriesId, true);
        MediaInfoStore.updateTvSeriesMetadata(tvSeriesMetadata, tvSeriesId);
        tvSeriesMetadata.ensureHavingTranslation(null);
        if (!StringUtils.isBlank(tvSeriesMetadata.getPoster(null)) && (thumbnail = JavaHttpClient.getThumbnail(tvSeriesMetadata.getPoster(null))) != null) {
            Long thumbnailId = ThumbnailStore.getIdForTvSeries(thumbnail, tvSeriesId, ThumbnailSource.TMDB_LOC);
            tvSeriesMetadata.setThumbnailSource(ThumbnailSource.TMDB_LOC);
            tvSeriesMetadata.setThumbnailId(thumbnailId);
            MediaTableTVSeries.updateThumbnailId(connection, tvSeriesId, thumbnailId, ThumbnailSource.TMDB_LOC.toString());
        }
        return tvSeriesMetadata;
    }

    private static Long insertTvShowMetadata(Connection connection, String titleFromFilename, MediaVideoMetadata videoMetadata, TvDetailsSchema tvDetails) {
        Long tvSeriesId = null;
        TvSeriesMetadata tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadataFromTmdbId(connection, tvDetails.getId());
        if (tvSeriesMetadata != null && tvSeriesMetadata.getTvSeriesId() != null) {
            tvSeriesId = tvSeriesMetadata.getTvSeriesId();
            LOGGER.trace("TV series with TMDB data already found in database {}", (Object)tvSeriesMetadata.getTitle());
        } else {
            LOGGER.trace("TMDB metadata for TV series {} (TMDB ID: {}) does not already exist in the database", (Object)titleFromFilename, (Object)tvDetails.getId());
            tvSeriesMetadata = TMDB.setTvShowMetadata(connection, tvDetails);
            if (tvSeriesMetadata != null) {
                tvSeriesId = tvSeriesMetadata.getTvSeriesId();
                String title = tvSeriesMetadata.getTitle();
                String titleSimplified = FileUtil.getSimplifiedShowName(title);
                String titleSimplifiedFromFilename = FileUtil.getSimplifiedShowName(titleFromFilename);
                if (titleFromFilename != null && titleSimplifiedFromFilename != null && !title.equals(titleFromFilename) && titleSimplified.equals(titleSimplifiedFromFilename)) {
                    LOGGER.trace("Converting rows in FILES table with the show name " + titleFromFilename + " to " + title);
                    MediaTableVideoMetadata.updateMovieOrShowName(connection, titleFromFilename, title);
                }
            }
        }
        if (videoMetadata != null && tvSeriesId != null) {
            videoMetadata.setTvSeriesId(tvSeriesId);
            videoMetadata.setTmdbTvId(tvDetails.getId());
            videoMetadata.setSeriesMetadata(MediaInfoStore.getTvSeriesMetadata(tvSeriesId));
        }
        return tvSeriesId;
    }

    private static TvDetailsSchema getMatchingTvShow(Long tvShowId, String titleSimplified, Integer year) throws IOException {
        String nameSimplified;
        TvDetailsSchema tvDetails = TMDB.getTvShowInfo(tvShowId);
        if (year != null) {
            Integer firstAirYear = TMDB.getYear(tvDetails.getFirstAirDate());
            Integer lastAirYear = TMDB.getYear(tvDetails.getLastAirDate());
            if (firstAirYear == null) {
                firstAirYear = 0;
            }
            if (lastAirYear == null) {
                lastAirYear = 9999;
            }
            if (year < firstAirYear || year > lastAirYear) {
                return null;
            }
        }
        if (titleSimplified.equals(nameSimplified = FileUtil.getSimplifiedShowName(tvDetails.getName()))) {
            return tvDetails;
        }
        if (tvDetails.getAlternativeTitles() != null && !tvDetails.getAlternativeTitles().getResults().isEmpty()) {
            for (TvAlternativeTitleSchema tvAlternativeTitle : tvDetails.getAlternativeTitles().getResults()) {
                nameSimplified = FileUtil.getSimplifiedShowName(tvAlternativeTitle.getTitle());
                if (!titleSimplified.equals(nameSimplified)) continue;
                return tvDetails;
            }
        }
        return null;
    }

    private static TvDetailsSchema getTvShowFromEpisode(String title, Integer year, String imdbId) throws IOException {
        SearchTvEndpoint searchTvEndpoint;
        TvSimpleResultsSchema tvSimpleResultsSchema;
        String titleSimplified = FileUtil.getSimplifiedShowName(title);
        ArrayList<Long> tvShowIds = new ArrayList<Long>();
        if (imdbId != null) {
            TvDetailsSchema tvDetails;
            Long tvShowId;
            FindSchema findResult = CLIENT.find(imdbId, FindExternalSource.IMDB_ID).getResults();
            if (!findResult.getTvEpisodeResults().isEmpty()) {
                for (TvEpisodeTypedSchema tvEpisodeTyped : findResult.getTvEpisodeResults()) {
                    tvShowId = tvEpisodeTyped.getShowId();
                    if (tvShowId == null || tvShowIds.contains(tvShowId)) continue;
                    tvDetails = TMDB.getMatchingTvShow(tvShowId, titleSimplified, year);
                    if (tvDetails != null) {
                        return tvDetails;
                    }
                    tvShowIds.add(tvShowId);
                }
            }
            if (!findResult.getTvResults().isEmpty()) {
                for (TvTypedSchema tvTyped : findResult.getTvResults()) {
                    tvShowId = tvTyped.getId();
                    if (tvShowId == null || tvShowIds.contains(tvShowId)) continue;
                    tvDetails = TMDB.getMatchingTvShow(tvShowId, titleSimplified, year);
                    if (tvDetails != null) {
                        return tvDetails;
                    }
                    tvShowIds.add(tvShowId);
                }
            }
        }
        if ((tvSimpleResultsSchema = (searchTvEndpoint = CLIENT.search(title).forTvShow()).getResults()) != null && tvSimpleResultsSchema.getTotalResults() > 0L) {
            for (TvSimpleSchema tvSimple : tvSimpleResultsSchema.getResults()) {
                Long tvShowId = tvSimple.getId();
                if (tvShowId == null || tvShowIds.contains(tvShowId)) continue;
                TvDetailsSchema tvDetails = TMDB.getMatchingTvShow(tvShowId, titleSimplified, year);
                if (tvDetails != null) {
                    return tvDetails;
                }
                tvShowIds.add(tvShowId);
            }
        }
        return null;
    }

    public static boolean updateTvShowForEpisode(MediaInfo mediaInfo, long tvShowId) {
        Integer episode = mediaInfo.getVideoMetadata().getFirstTvEpisodeNumber();
        Integer season = mediaInfo.getVideoMetadata().getTvSeason();
        if (season == null || episode == null) {
            return false;
        }
        try {
            TvDetailsSchema tvDetails = TMDB.getTvShowInfo(tvShowId);
            return TMDB.updateTvShowForEpisode(mediaInfo, tvShowId, season, episode, tvDetails);
        }
        catch (IOException ex) {
            LOGGER.trace("Error in updateTvShowForEpisode:", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean updateTvShowForEpisode(MediaInfo mediaInfo, long tvShowId, int season, int episode, TvDetailsSchema tvDetails) {
        Connection connection = null;
        try {
            TvEpisodeDetailsSchema tvEpisodeDetails = TMDB.getTvEpisodeInfo(tvShowId, season, episode);
            if (tvDetails != null && tvEpisodeDetails != null && mediaInfo.getFileId() != null) {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) {
                    boolean bl = false;
                    MediaDatabase.close(connection);
                    return bl;
                }
                TMDB.insertTvShowMetadata(connection, null, mediaInfo.getVideoMetadata(), tvDetails);
                TMDB.setTvEpisodeMetadata(connection, mediaInfo.getFileId(), mediaInfo, tvEpisodeDetails);
                String filename = MediaTableFiles.getFilenameById(connection, mediaInfo.getFileId());
                if (filename != null) {
                    MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
                }
                boolean bl = true;
                MediaDatabase.close(connection);
                return bl;
            }
            MediaDatabase.close(connection);
            return false;
        }
        catch (IOException | SQLException ex) {
            LOGGER.trace("Error in setMovieMetadata:", ex);
            return false;
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTvShowMetadata(Long tvSeriesId, long tvShowId) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            TvDetailsSchema tvDetails = TMDB.getTvShowInfo(tvShowId);
            TvSeriesMetadata tvSeriesMetadata = TMDB.setTvShowMetadata(connection, tvDetails);
            Long newTvSeriesId = tvSeriesMetadata.getTvSeriesId();
            MediaInfoStore.updateTvEpisodesTvSeriesId(tvSeriesId, newTvSeriesId);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.trace("Error in updateTvShowMetadata:", ex);
        }
        finally {
            MediaDatabase.close(connection);
        }
        return false;
    }

    public static JsonArray getTvShowsFromEpisode(String title, Integer year, String lang, Long currentId) throws IOException {
        JsonArray result = new JsonArray();
        SearchTvEndpoint searchTvEndpoint = CLIENT.search(title).forTvShow();
        if (year != null && year > 0) {
            searchTvEndpoint.setFirstAirDateYear(year);
        }
        if (lang != null) {
            searchTvEndpoint.setLanguage(lang);
        }
        TvSimpleResultsSchema tvSimpleResultsSchema = searchTvEndpoint.getResults();
        for (TvSimpleSchema tvShow : tvSimpleResultsSchema.getResults()) {
            JsonObject tvShowObject = new JsonObject();
            tvShowObject.addProperty("id", tvShow.getId());
            tvShowObject.addProperty("title", tvShow.getName());
            tvShowObject.addProperty("poster", TMDB.getStillUrl(tvShow.getPosterPath()));
            tvShowObject.addProperty("overview", tvShow.getOverview());
            tvShowObject.addProperty("year", tvShow.getFirstAirDate());
            tvShowObject.addProperty("original_language", tvShow.getOriginalLanguage());
            tvShowObject.addProperty("original_title", tvShow.getOriginalName());
            tvShowObject.addProperty("selected", tvShow.getId().equals(currentId));
            result.add(tvShowObject);
        }
        return result;
    }

    public static JsonArray getMovies(String title, Integer year, String lang, Long currentId) throws IOException {
        JsonArray result = new JsonArray();
        SearchMovieEndpoint searchMovieEndpoint = CLIENT.search(title).forMovie();
        if (year != null && year != 0) {
            searchMovieEndpoint.setYear(year);
        }
        if (lang != null) {
            searchMovieEndpoint.setLanguage(lang);
        }
        MovieShortResultsSchema movieShortResults = searchMovieEndpoint.getResults();
        for (MovieShortSchema movie : movieShortResults.getResults()) {
            JsonObject movieObject = new JsonObject();
            movieObject.addProperty("id", movie.getId());
            movieObject.addProperty("title", movie.getTitle());
            movieObject.addProperty("poster", TMDB.getPosterUrl(movie.getPosterPath()));
            movieObject.addProperty("overview", movie.getOverview());
            movieObject.addProperty("year", movie.getReleaseDate());
            movieObject.addProperty("original_language", movie.getOriginalLanguage());
            movieObject.addProperty("original_title", movie.getOriginalTitle());
            movieObject.addProperty("selected", movie.getId().equals(currentId));
            result.add(movieObject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateMovieMetadata(MediaInfo mediaInfo, Long tmdbId) {
        Connection connection = null;
        try {
            MovieDetailsSchema movieDetails = TMDB.getMovieInfo(tmdbId, null);
            if (movieDetails != null && mediaInfo.getFileId() != null) {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) {
                    boolean bl = false;
                    MediaDatabase.close(connection);
                    return bl;
                }
                TMDB.setMovieMetadata(connection, mediaInfo.getFileId(), mediaInfo, movieDetails);
                String filename = MediaTableFiles.getFilenameById(connection, mediaInfo.getFileId());
                if (filename != null) {
                    MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
                }
                boolean bl = true;
                MediaDatabase.close(connection);
                return bl;
            }
            MediaDatabase.close(connection);
            return false;
        }
        catch (IOException | SQLException ex) {
            LOGGER.trace("Error in setMovieMetadata:", ex);
            return false;
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    public static synchronized VideoMetadataLocalized getVideoMetadataLocalized(String language, String mediaType, String imdbId, Long tmdbId, Integer season, String episode) {
        if (!CONFIGURATION.getExternalNetwork()) {
            return null;
        }
        if (!TMDB.isReady()) {
            return APIUtils.getVideoMetadataLocalizedFromImdb(language, mediaType, imdbId, tmdbId, season, episode);
        }
        if (StringUtils.isNotBlank(language) && StringUtils.isNotBlank(mediaType) && tmdbId != null && tmdbId > 0L) {
            return switch (mediaType) {
                case "collection" -> TMDB.getCollectionMetadataLocalized(tmdbId, language);
                case "movie" -> TMDB.getMovieMetadataLocalized(tmdbId, language);
                case "tv" -> TMDB.getTvShowMetadataLocalized(tmdbId, language);
                case "tv_season" -> TMDB.getTvSeasonMetadataLocalized(tmdbId, season, language);
                case "tv_episode" -> TMDB.getTvEpisodeMetadataLocalized(tmdbId, season, episode, language);
                default -> null;
            };
        }
        return null;
    }

    private static VideoMetadataLocalized getCollectionMetadataLocalized(Long tmdbId, String language) {
        CollectionDetailsSchema collectionDetailsSchema = CLIENT.collection(tmdbId).setLanguage(language).getDetails();
        VideoMetadataLocalized metadata = new VideoMetadataLocalized();
        metadata.setOverview(collectionDetailsSchema.getOverview());
        if (StringUtils.isNotBlank(collectionDetailsSchema.getPosterPath())) {
            String poster = TMDB.getPosterUrl(collectionDetailsSchema.getPosterPath());
            metadata.setPoster(poster);
        }
        metadata.setTitle(collectionDetailsSchema.getName());
        metadata.setTmdbID(collectionDetailsSchema.getId());
        return metadata;
    }

    private static VideoMetadataLocalized getMovieMetadataLocalized(Long tmdbId, String language) {
        MovieDetailsSchema movieDetailsSchema = CLIENT.movie(tmdbId).setLanguage(language).getDetails();
        VideoMetadataLocalized metadata = new VideoMetadataLocalized();
        metadata.setHomepage(movieDetailsSchema.getHomepage());
        metadata.setOverview(movieDetailsSchema.getOverview());
        if (StringUtils.isNotBlank(movieDetailsSchema.getPosterPath())) {
            String poster = TMDB.getPosterUrl(movieDetailsSchema.getPosterPath());
            metadata.setPoster(poster);
        }
        metadata.setTagline(movieDetailsSchema.getTagline());
        metadata.setTitle(movieDetailsSchema.getTitle());
        metadata.setTmdbID(movieDetailsSchema.getId());
        return metadata;
    }

    private static VideoMetadataLocalized getTvShowMetadataLocalized(Long tmdbId, String language) {
        TvDetailsSchema tvDetailsSchema = CLIENT.tv(tmdbId).setLanguage(language).getDetails();
        VideoMetadataLocalized metadata = new VideoMetadataLocalized();
        metadata.setHomepage(tvDetailsSchema.getHomepage());
        metadata.setOverview(tvDetailsSchema.getOverview());
        metadata.setPoster(tvDetailsSchema.getOverview());
        if (StringUtils.isNotBlank(tvDetailsSchema.getPosterPath())) {
            String poster = TMDB.getPosterUrl(tvDetailsSchema.getPosterPath());
            metadata.setPoster(poster);
        }
        metadata.setTagline(tvDetailsSchema.getTagline());
        metadata.setTitle(tvDetailsSchema.getName());
        metadata.setTmdbID(tvDetailsSchema.getId());
        return metadata;
    }

    private static VideoMetadataLocalized getTvSeasonMetadataLocalized(Long tmdbId, Integer season, String language) {
        if (season == null) {
            return null;
        }
        TvSeasonDetailsSchema tvSeasonDetailsSchema = CLIENT.tvSeason(tmdbId, season.intValue()).setLanguage(language).getDetails();
        VideoMetadataLocalized metadata = new VideoMetadataLocalized();
        metadata.setOverview(tvSeasonDetailsSchema.getOverview());
        if (StringUtils.isNotBlank(tvSeasonDetailsSchema.getPosterPath())) {
            String poster = TMDB.getPosterUrl(tvSeasonDetailsSchema.getPosterPath());
            metadata.setPoster(poster);
        }
        metadata.setTitle(tvSeasonDetailsSchema.getName());
        metadata.setTmdbID(tmdbId);
        return metadata;
    }

    private static VideoMetadataLocalized getTvEpisodeMetadataLocalized(Long tmdbId, Integer season, String episode, String language) {
        if (season == null) {
            return null;
        }
        Long episodeNumber = TMDB.getLong(episode);
        if (episodeNumber == null) {
            return null;
        }
        TvEpisodeDetailsSchema tvEpisodeDetailsSchema = CLIENT.tvEpisode(tmdbId, season.intValue(), episodeNumber).setLanguage(language).getDetails();
        VideoMetadataLocalized metadata = new VideoMetadataLocalized();
        metadata.setOverview(tvEpisodeDetailsSchema.getOverview());
        if (StringUtils.isNotBlank(tvEpisodeDetailsSchema.getStillPath())) {
            String poster = TMDB.getStillUrl(tvEpisodeDetailsSchema.getStillPath());
            metadata.setPoster(poster);
        }
        metadata.setTitle(tvEpisodeDetailsSchema.getName());
        metadata.setTmdbID(tvEpisodeDetailsSchema.getId());
        return metadata;
    }

    private static TvEpisodeDetailsSchema getTvEpisodeInfo(long tvShowId, int seasonNumber, int episodeNumber) throws IOException {
        return CLIENT.tvEpisode(tvShowId, seasonNumber, episodeNumber).appendToResponse(TvEpisodeAppendToResponse.CREDITS).appendToResponse(TvEpisodeAppendToResponse.EXTERNAL_IDS).appendToResponse(TvEpisodeAppendToResponse.IMAGES).appendToResponse(TvEpisodeAppendToResponse.TRANSLATIONS).getDetails();
    }

    private static TvDetailsSchema getTvShowInfo(long tvId) throws IOException {
        return CLIENT.tv(tvId).appendToResponse(TvIdAppendToResponse.ALTERNATIVE_TITLES).appendToResponse(TvIdAppendToResponse.CONTENT_RATINGS).appendToResponse(TvIdAppendToResponse.CREDITS).appendToResponse(TvIdAppendToResponse.EXTERNAL_IDS).appendToResponse(TvIdAppendToResponse.IMAGES).appendToResponse(TvIdAppendToResponse.TRANSLATIONS).getDetails();
    }

    private static MovieDetailsSchema getMovieInfo(String title, Integer year, String imdbID) throws IOException {
        MovieShortResultsSchema movieShortResults;
        FindSchema findResult;
        if (imdbID != null && !(findResult = CLIENT.find(imdbID, FindExternalSource.IMDB_ID).getResults()).getMovieResults().isEmpty()) {
            for (MovieTypedSchema movieTyped : findResult.getMovieResults()) {
                Long tmdbId = movieTyped.getId();
                MovieDetailsSchema movieDetails = TMDB.getMovieInfo(tmdbId, null);
                if (year != null && year != 0) {
                    if (!TMDB.getReleaseYears(movieDetails.getReleaseDates()).contains(year)) continue;
                    return movieDetails;
                }
                return movieDetails;
            }
        }
        SearchMovieEndpoint searchMovieEndpoint = CLIENT.search(title).forMovie();
        if (year != null && year != 0) {
            searchMovieEndpoint.setYear(year);
        }
        if ((movieShortResults = searchMovieEndpoint.getResults()) != null && movieShortResults.getTotalResults() > 0L) {
            for (MovieShortSchema movieShort : movieShortResults.getResults()) {
                Long tmdbId = movieShort.getId();
                MovieDetailsSchema movieDetails = TMDB.getMovieInfo(tmdbId, null);
                if (year != null && year != 0) {
                    if (!TMDB.getReleaseYears(movieDetails.getReleaseDates()).contains(year)) continue;
                    return movieDetails;
                }
                return movieDetails;
            }
        }
        return null;
    }

    private static MovieDetailsSchema getMovieInfo(long tmdbId, String language) throws IOException {
        MovieIdEndpoint movieIdEndpoint = CLIENT.movie(tmdbId).appendToResponse(MovieIdAppendToResponse.ALTERNATIVE_TITLES).appendToResponse(MovieIdAppendToResponse.CREDITS).appendToResponse(MovieIdAppendToResponse.EXTERNAL_IDS).appendToResponse(MovieIdAppendToResponse.IMAGES).appendToResponse(MovieIdAppendToResponse.RELEASE_DATES).appendToResponse(MovieIdAppendToResponse.REVIEWS).appendToResponse(MovieIdAppendToResponse.TRANSLATIONS);
        if (language != null) {
            movieIdEndpoint.setLanguage(language);
        }
        return movieIdEndpoint.getDetails();
    }

    private static ApiStringArray getActors(List<? extends PersonRoleCreditSchema> cast) {
        Collections.sort(cast, (role1, role2) -> role1.getOrder().intValue() - role2.getOrder().intValue());
        ApiStringArray result = new ApiStringArray();
        for (PersonRoleCreditSchema personRoleCreditSchema : cast) {
            result.add(personRoleCreditSchema.getName());
            if (result.size() <= 4) continue;
            break;
        }
        return result;
    }

    private static String getUsCertification(MovieReleaseDatesSchema movieReleaseDates) {
        if (movieReleaseDates == null || movieReleaseDates.getResults() == null || movieReleaseDates.getResults().isEmpty()) {
            return null;
        }
        for (MovieReleaseDatesResultSchema countryReleaseDate : movieReleaseDates.getResults()) {
            if (!"US".equals(countryReleaseDate.getIso3166Part1())) continue;
            for (MovieReleaseDateSchema movieReleaseDate : countryReleaseDate.getReleaseDates()) {
                if (movieReleaseDate.getCertification() == null) continue;
                return movieReleaseDate.getCertification();
            }
        }
        return null;
    }

    private static String getUsContentRating(TvContentRatingsSchema tvContentRatings) {
        if (tvContentRatings == null || tvContentRatings.getResults() == null || tvContentRatings.getResults().isEmpty()) {
            return null;
        }
        for (TvContentRatingSchema tvContentRating : tvContentRatings.getResults()) {
            if (!"US".equals(tvContentRating.getIso3166Part1()) || tvContentRating.getRating() == null) continue;
            return tvContentRating.getRating();
        }
        return null;
    }

    private static ApiStringArray getCountries(List<CountrySimpleSchema> countries) {
        ApiStringArray result = new ApiStringArray();
        for (CountrySimpleSchema country : countries) {
            result.add(country.getIso3166Part1());
        }
        return result;
    }

    private static ApiStringArray getDirectors(List<PersonJobCreditSchema> crew) {
        ApiStringArray result = new ApiStringArray();
        for (PersonJobCreditSchema person : crew) {
            if (!"Directing".equals(person.getDepartment()) || !"Director".equals(person.getJob())) continue;
            result.add(person.getName());
        }
        return result;
    }

    private static List<Integer> getReleaseYears(MovieReleaseDatesSchema movieReleaseDates) {
        if (movieReleaseDates == null || movieReleaseDates.getResults() == null || movieReleaseDates.getResults().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (MovieReleaseDatesResultSchema countryReleaseDate : movieReleaseDates.getResults()) {
            for (MovieReleaseDateSchema movieReleaseDate : countryReleaseDate.getReleaseDates()) {
                Integer year = TMDB.getYear(movieReleaseDate.getReleaseDate());
                if (year == null || result.contains(year)) continue;
                result.add(year);
            }
        }
        return result;
    }

    private static Long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer getYear(String value) {
        if (value == null || value.length() < 4) {
            return null;
        }
        try {
            return Integer.valueOf(value.substring(0, 4));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getTmdbImageBaseURL() {
        if (tmdbImageBaseURL == null && TMDB.isReady()) {
            try {
                ConfigurationSchema configurationSchema = CLIENT.configuration().getConfiguration();
                tmdbImageBaseURL = configurationSchema.getImages().getBaseUrl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tmdbImageBaseURL == null) {
            return APIUtils.getApiImageBaseURL();
        }
        return tmdbImageBaseURL;
    }

    public static String getPosterUrl(String posterPath) {
        if (posterPath != null) {
            return TMDB.getTmdbImageBaseURL() + "original" + posterPath;
        }
        return null;
    }

    public static String getStillUrl(String stillPath) {
        if (stillPath != null) {
            return TMDB.getTmdbImageBaseURL() + "original" + stillPath;
        }
        return null;
    }

    private static ApiStringArray getApiStringArrayFromList(List<IntegerIdNameSchema> element) {
        if (element == null) {
            return null;
        }
        ApiStringArray result = new ApiStringArray();
        Iterator<IntegerIdNameSchema> i = element.iterator();
        while (i.hasNext()) {
            String str = i.next().getName();
            result.add(str);
        }
        return result;
    }

    private static ApiStringArray getApiStringArrayFromStringList(List<String> element) {
        if (element == null) {
            return null;
        }
        ApiStringArray result = new ApiStringArray();
        Iterator<String> i = element.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("TMDB Utils Executor Shutdown Hook"){

            @Override
            public void run() {
                BACKGROUND_EXECUTOR.shutdownNow();
            }
        });
    }
}

