/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import net.pms.encoders.EncodingFormat;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.store.StoreItem;
import net.pms.util.PlayerUtil;

public class VideoLanAudioStreaming
extends VideoLanVideoStreaming {
    public static final EngineId ID = StandardEngineId.VLC_AUDIO_STREAMING;
    public static final String KEY_VLC_LEGACY_AUDIO_EXECUTABLE_TYPE = "vlc_legacy_audio_executable_type";
    public static final String NAME = "VLC Web Audio (Legacy)";

    VideoLanAudioStreaming() {
    }

    @Override
    public int purpose() {
        return 3;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_VLC_LEGACY_AUDIO_EXECUTABLE_TYPE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public String getMimeType() {
        return "audio/wav";
    }

    @Override
    protected String getEncodingArgs() {
        return "acodec=s16l,channels=2";
    }

    @Override
    protected String getMux() {
        return "wav";
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isWebAudio(item);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isAudioFormat();
    }
}

