/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.TsMuxeRAudio;
import net.pms.formats.Format;
import net.pms.io.IPipeProcess;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.PipeIPCProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.io.StreamModifier;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.parsers.FFmpegParser;
import net.pms.platform.PlatformUtils;
import net.pms.platform.windows.NTStatus;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.CodecUtil;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.InputFile;
import net.pms.util.PlayerUtil;
import net.pms.util.UMSUtils;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsMuxeRVideo
extends Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsMuxeRVideo.class);
    public static final EngineId ID = StandardEngineId.TSMUXER_VIDEO;
    public static final String KEY_TSMUXER_PATH = "tsmuxer_path";
    public static final String KEY_TSMUXER_EXECUTABLE_TYPE = "tsmuxer_executable_type";
    public static final String NAME = "tsMuxeR Video";

    TsMuxeRVideo() {
        super(CONFIGURATION.getTsMuxeRPaths());
    }

    @Override
    public boolean excludeFormat(Format format) {
        String extension = format.getMatchedExtension();
        return extension != null && !extension.equals("mp4") && !extension.equals("mkv") && !extension.equals("ts") && !extension.equals("tp") && !extension.equals("m2ts") && !extension.equals("m2t") && !extension.equals("mpg") && !extension.equals("evo") && !extension.equals("mpeg") && !extension.equals("vob") && !extension.equals("m2v") && !extension.equals("mts") && !extension.equals("mov");
    }

    @Override
    public int purpose() {
        return 0;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_TSMUXER_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_TSMUXER_EXECUTABLE_TYPE;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem item, MediaInfo media, OutputParams params) throws IOException {
        ProcessWrapperImpl ffVideo;
        PipeIPCProcess ffVideoPipe;
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        String filename = item.getFileName();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        TsMuxeRVideo.setAudioAndSubs(item, params);
        PipeIPCProcess[] ffAudioPipe = null;
        ProcessWrapperImpl[] ffAudio = null;
        MediaVideo defaultVideoTrack = media.getDefaultVideoTrack();
        MediaAudio audioTrack = params.getAid();
        String fps = TsMuxeRVideo.getValidFps(media.getFrameRate(), false);
        String videoType = "V_MPEG4/ISO/AVC";
        String codecV = defaultVideoTrack.getCodec();
        if (codecV != null) {
            if (codecV.equals("mpeg2")) {
                videoType = "V_MPEG-2";
            } else if (codecV.equals("h265")) {
                videoType = "V_MPEGH/ISO/HEVC";
            }
        }
        boolean aacTranscode = false;
        if (this instanceof TsMuxeRAudio) {
            ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "fakevideo", System.currentTimeMillis() + "videoout", false, true);
            String timeEndValue1 = "-t";
            Object timeEndValue2 = "" + params.getTimeEnd();
            if (params.getTimeEnd() < 1.0) {
                timeEndValue1 = "-y";
                timeEndValue2 = "-y";
            }
            ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), timeEndValue1, timeEndValue2, "-loop", "1", "-i", "DummyInput.jpg", "-f", "h264", "-c:v", "libx264", "-level", "31", "-tune", "zerolatency", "-pix_fmt", "yuv420p", "-an", "-y", ffVideoPipe.getInputPipe()};
            videoType = "V_MPEG4/ISO/AVC";
            ffparams = new OutputParams(configuration);
            ffparams.setMaxBufferSize(1.0);
            ffVideo = new ProcessWrapperImpl(ffmpegCommands, ffparams);
            if (audioTrack != null) {
                if (filename.toLowerCase().endsWith(".flac") && audioTrack.getBitDepth() >= 24 && audioTrack.getSampleRate() % 48000 == 0) {
                    ffAudioPipe = new PipeIPCProcess[]{new PipeIPCProcess(System.currentTimeMillis() + "flacaudio", System.currentTimeMillis() + "audioout", false, true)};
                    String[] flacCmd = new String[]{configuration.getFLACPath(), "--output-name=" + ffAudioPipe[0].getInputPipe(), "-d", "-f", "-F", filename};
                    ffparams = new OutputParams(configuration);
                    ffparams.setMaxBufferSize(1.0);
                    ffAudio = new ProcessWrapperImpl[]{new ProcessWrapperImpl(flacCmd, ffparams)};
                } else {
                    ffAudioPipe = new PipeIPCProcess[]{new PipeIPCProcess(System.currentTimeMillis() + "mlpaudio", System.currentTimeMillis() + "audioout", false, true)};
                    String depth = "pcm_s16le";
                    Object rate = "48000";
                    if (audioTrack.getBitDepth() >= 24) {
                        depth = "pcm_s24le";
                    }
                    if (audioTrack.getSampleRate() > 48000) {
                        rate = "" + audioTrack.getSampleRate();
                    }
                    String[] flacCmd = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-i", filename, "-ar", rate, "-f", "wav", "-acodec", depth, "-y", ffAudioPipe[0].getInputPipe()};
                    ffparams = new OutputParams(configuration);
                    ffparams.setMaxBufferSize(1.0);
                    ffAudio = new ProcessWrapperImpl[]{new ProcessWrapperImpl(flacCmd, ffparams)};
                }
            }
        } else {
            boolean singleMediaAudio;
            byte[] h264AnnexB;
            params.setWaitBeforeStart(5000);
            params.manageFastStart();
            ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegvideo", System.currentTimeMillis() + "videoout", false, true);
            ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-c", "copy", "-f", "h265".equals(codecV) ? "hevc" : "rawvideo", "-y", ffVideoPipe.getInputPipe()};
            InputFile newInput = new InputFile();
            newInput.setFilename(filename);
            newInput.setPush(params.getStdIn());
            if (defaultVideoTrack.isH264() && !this.isVideoWithinH264LevelLimits(defaultVideoTrack, renderer)) {
                LOGGER.info("The video will not play or will show a black screen");
            }
            if ((h264AnnexB = this.getH264AnnexB(newInput, defaultVideoTrack)) != null && h264AnnexB.length > 0) {
                StreamModifier sm = new StreamModifier();
                sm.setHeader(h264AnnexB);
                sm.setH264AnnexB(true);
                ffVideoPipe.setModifier(sm);
            }
            ffparams = new OutputParams(configuration);
            ffparams.setMaxBufferSize(1.0);
            ffparams.setStdIn(params.getStdIn());
            ffVideo = new ProcessWrapperImpl(ffmpegCommands, ffparams);
            int numAudioTracks = 1;
            if (media.getAudioTracks() != null && media.getAudioTracks().size() > 1 && configuration.isMuxAllAudioTracks()) {
                numAudioTracks = media.getAudioTracks().size();
            }
            boolean bl = singleMediaAudio = media.getAudioTracks().size() <= 1;
            if (audioTrack != null) {
                if (numAudioTracks <= 1) {
                    ffAudioPipe = new PipeIPCProcess[numAudioTracks];
                    ffAudioPipe[0] = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
                    encodedAudioPassthrough = configuration.isEncodedAudioPassthrough() && audioTrack.isNonPCMEncodedAudio() && renderer.isWrapEncodedAudioIntoPCM();
                    boolean ac3Remux = audioTrack.isAC3() && configuration.isAudioRemuxAC3() && !encodedAudioPassthrough && !encodingFormat.isTranscodeToAAC();
                    dtsRemux = configuration.isAudioEmbedDtsInPcm() && audioTrack.isDTS() && renderer.isDTSPlayable() && !encodedAudioPassthrough;
                    boolean bl2 = pcm = configuration.isAudioUsePCM() && TsMuxeRVideo.isValidForLPCMTranscoding(media) && (audioTrack.isLossless() || audioTrack.isDTS() && audioTrack.getNumberOfChannels() <= 6 || audioTrack.isTrueHD() || !configuration.isMencoderUsePcmForHQAudioOnly() && (audioTrack.isAC3() || audioTrack.isMP3() || audioTrack.isAAC() || audioTrack.isVorbis() || audioTrack.isMpegAudio())) && renderer.isLPCMPlayable();
                    int channels = ac3Remux ? audioTrack.getNumberOfChannels() : (dtsRemux || encodedAudioPassthrough ? 2 : (pcm ? audioTrack.getNumberOfChannels() : configuration.getAudioChannelCount()));
                    if (!ac3Remux && (dtsRemux || pcm || encodedAudioPassthrough)) {
                        StreamModifier sm = new StreamModifier();
                        sm.setPcm(pcm);
                        sm.setDtsEmbed(dtsRemux);
                        sm.setEncodedAudioPassthrough(encodedAudioPassthrough);
                        sm.setNbChannels(channels);
                        sm.setSampleFrequency(audioTrack.getSampleRate() < 48000 ? 48000 : audioTrack.getSampleRate());
                        sm.setBitsPerSample(16);
                        ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + sm.getNbChannels(), "-f", "ac3", "-c:a", sm.isDtsEmbed() || sm.isEncodedAudioPassthrough() ? "copy" : "pcm", "-y", ffAudioPipe[0].getInputPipe()};
                        if (!renderer.isMuxDTSToMpeg()) {
                            ffAudioPipe[0].setModifier(sm);
                        }
                    } else if (!ac3Remux && encodingFormat.isTranscodeToAAC()) {
                        ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + channels, "-f", "adts", "-c:a", "aac", "-ab", Math.min(configuration.getAudioBitrate(), 320) + "k", "-y", ffAudioPipe[0].getInputPipe()};
                        aacTranscode = true;
                    } else {
                        ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + channels, "-f", "ac3", "-c:a", ac3Remux ? "copy" : "ac3", "-ab", String.valueOf(CodecUtil.getAC3Bitrate(configuration, audioTrack)) + "k", "-y", ffAudioPipe[0].getInputPipe()};
                    }
                    ffparams = new OutputParams(configuration);
                    ffparams.setMaxBufferSize(1.0);
                    ffparams.setStdIn(params.getStdIn());
                    ffAudio = new ProcessWrapperImpl[numAudioTracks];
                    ffAudio[0] = new ProcessWrapperImpl(ffmpegCommands, ffparams);
                } else {
                    ffAudioPipe = new PipeIPCProcess[numAudioTracks];
                    ffAudio = new ProcessWrapperImpl[numAudioTracks];
                    for (int i = 0; i < media.getAudioTracks().size(); ++i) {
                        MediaAudio audio = media.getAudioTracks().get(i);
                        ffAudioPipe[i] = new PipeIPCProcess(System.currentTimeMillis() + "ffmpeg" + i, System.currentTimeMillis() + "audioout" + i, false, true);
                        encodedAudioPassthrough = configuration.isEncodedAudioPassthrough() && audioTrack.isNonPCMEncodedAudio() && renderer.isWrapEncodedAudioIntoPCM();
                        boolean ac3Remux = audio.isAC3() && configuration.isAudioRemuxAC3() && !encodedAudioPassthrough && !encodingFormat.isTranscodeToAAC();
                        dtsRemux = configuration.isAudioEmbedDtsInPcm() && audio.isDTS() && renderer.isDTSPlayable() && !encodedAudioPassthrough;
                        boolean bl3 = pcm = configuration.isAudioUsePCM() && TsMuxeRVideo.isValidForLPCMTranscoding(media) && (audio.isLossless() || audio.isDTS() && audio.getNumberOfChannels() <= 6 || audio.isTrueHD() || !configuration.isMencoderUsePcmForHQAudioOnly() && (audio.isAC3() || audio.isMP3() || audio.isAAC() || audio.isVorbis() || audio.isMpegAudio())) && renderer.isLPCMPlayable();
                        int channels = ac3Remux ? audio.getNumberOfChannels() : (dtsRemux || encodedAudioPassthrough ? 2 : (pcm ? audio.getNumberOfChannels() : configuration.getAudioChannelCount()));
                        if (!ac3Remux && (dtsRemux || pcm || encodedAudioPassthrough)) {
                            StreamModifier sm = new StreamModifier();
                            sm.setPcm(pcm);
                            sm.setDtsEmbed(dtsRemux);
                            sm.setEncodedAudioPassthrough(encodedAudioPassthrough);
                            sm.setNbChannels(channels);
                            sm.setSampleFrequency(audio.getSampleRate() < 48000 ? 48000 : audio.getSampleRate());
                            sm.setBitsPerSample(16);
                            if (!renderer.isMuxDTSToMpeg()) {
                                ffAudioPipe[i].setModifier(sm);
                            }
                            ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + sm.getNbChannels(), "-f", "ac3", singleMediaAudio ? "-y" : "-map", singleMediaAudio ? "-y" : "0:a:" + media.getAudioTracks().indexOf(audio), "-c:a", sm.isDtsEmbed() || sm.isEncodedAudioPassthrough() ? "copy" : "pcm", "-y", ffAudioPipe[i].getInputPipe()};
                        } else if (!ac3Remux && encodingFormat.isTranscodeToAAC()) {
                            ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + channels, "-f", "adts", singleMediaAudio ? "-y" : "-map", singleMediaAudio ? "-y" : "0:a:" + media.getAudioTracks().indexOf(audio), "-c:a", "aac", "-ab", Math.min(configuration.getAudioBitrate(), 320) + "k", "-y", ffAudioPipe[i].getInputPipe()};
                            aacTranscode = true;
                        } else {
                            ffmpegCommands = new String[]{EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO), "-ss", params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0", "-i", filename, "-ac", "" + channels, "-f", "ac3", singleMediaAudio ? "-y" : "-map", singleMediaAudio ? "-y" : "0:a:" + media.getAudioTracks().indexOf(audio), "-c:a", ac3Remux ? "copy" : "ac3", "-ab", String.valueOf(CodecUtil.getAC3Bitrate(configuration, audio)) + "k", "-y", ffAudioPipe[i].getInputPipe()};
                        }
                        ffparams = new OutputParams(configuration);
                        ffparams.setMaxBufferSize(1.0);
                        ffparams.setStdIn(params.getStdIn());
                        ffAudio[i] = new ProcessWrapperImpl(ffmpegCommands, ffparams);
                    }
                }
            }
        }
        File f = new File(CONFIGURATION.getTempFolder(), "ums-tsmuxer.meta");
        params.setLog(false);
        try (PrintWriter pw = new PrintWriter(f);){
            Object videoparams;
            pw.print("MUXOPT --no-pcr-on-video-pid");
            pw.print(" --new-audio-pes");
            pw.print(" --no-asyncio");
            pw.print(" --vbr");
            pw.println(" --vbv-len=500");
            if (this instanceof TsMuxeRAudio) {
                videoparams = "track=224";
            } else if (encodingFormat.isTranscodeToH264()) {
                String sei = "insertSEI";
                if (renderer.isPS3() && this.isWebDl(filename, media, params)) {
                    sei = "forceSEI";
                }
                videoparams = "level=4.1, " + sei + ", contSPS, track=1";
            } else {
                videoparams = "track=1";
            }
            if (configuration.isFix25FPSAvMismatch()) {
                fps = "25";
            }
            pw.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + (String)(fps != null ? "fps=" + fps + ", " : "") + (String)videoparams);
            if (audioTrack != null && ffAudioPipe != null && ffAudioPipe.length == 1) {
                Object timeshift = "";
                boolean encodedAudioPassthrough = configuration.isEncodedAudioPassthrough() && audioTrack.isNonPCMEncodedAudio() && renderer.isWrapEncodedAudioIntoPCM();
                boolean ac3Remux = audioTrack.isAC3() && configuration.isAudioRemuxAC3() && !encodedAudioPassthrough && !encodingFormat.isTranscodeToAAC();
                boolean dtsRemux = configuration.isAudioEmbedDtsInPcm() && audioTrack.isDTS() && renderer.isDTSPlayable() && !encodedAudioPassthrough;
                boolean pcm = configuration.isAudioUsePCM() && TsMuxeRVideo.isValidForLPCMTranscoding(media) && (audioTrack.isLossless() || audioTrack.isDTS() && audioTrack.getNumberOfChannels() <= 6 || audioTrack.isTrueHD() || !configuration.isMencoderUsePcmForHQAudioOnly() && (audioTrack.isAC3() || audioTrack.isMP3() || audioTrack.isAAC() || audioTrack.isVorbis() || audioTrack.isMpegAudio())) && renderer.isLPCMPlayable();
                String type = "A_AC3";
                if (ac3Remux) {
                    type = "A_AC3";
                } else if (aacTranscode) {
                    type = "A_AAC";
                } else {
                    if (pcm || this instanceof TsMuxeRAudio) {
                        type = "A_LPCM";
                    }
                    if (encodedAudioPassthrough || this instanceof TsMuxeRAudio) {
                        type = "A_LPCM";
                    }
                    if (dtsRemux || this instanceof TsMuxeRAudio) {
                        type = "A_LPCM";
                        if (renderer.isMuxDTSToMpeg()) {
                            type = "A_DTS";
                        }
                    }
                }
                if (audioTrack.getVideoDelay() != 0 && params.getTimeSeek() == 0.0) {
                    timeshift = "timeshift=" + audioTrack.getVideoDelay() + "ms, ";
                }
                pw.println(type + ", \"" + ffAudioPipe[0].getOutputPipe() + "\", " + (String)timeshift + "track=2");
            } else if (audioTrack != null && ffAudioPipe != null) {
                for (int i = 0; i < media.getAudioTracks().size(); ++i) {
                    MediaAudio audio = media.getAudioTracks().get(i);
                    Object timeshift = "";
                    boolean encodedAudioPassthrough = configuration.isEncodedAudioPassthrough() && audioTrack.isNonPCMEncodedAudio() && renderer.isWrapEncodedAudioIntoPCM();
                    boolean ac3Remux = audio.isAC3() && configuration.isAudioRemuxAC3() && !encodedAudioPassthrough;
                    boolean dtsRemux = configuration.isAudioEmbedDtsInPcm() && audio.isDTS() && renderer.isDTSPlayable() && !encodedAudioPassthrough;
                    boolean pcm = configuration.isAudioUsePCM() && TsMuxeRVideo.isValidForLPCMTranscoding(media) && (audio.isLossless() || audio.isDTS() && audio.getNumberOfChannels() <= 6 || audio.isTrueHD() || !configuration.isMencoderUsePcmForHQAudioOnly() && (audioTrack.isAC3() || audioTrack.isMP3() || audioTrack.isAAC() || audioTrack.isVorbis() || audioTrack.isMpegAudio())) && renderer.isLPCMPlayable();
                    String type = "A_AC3";
                    if (ac3Remux) {
                        type = "A_AC3";
                    } else {
                        if (pcm) {
                            type = "A_LPCM";
                        }
                        if (encodedAudioPassthrough) {
                            type = "A_LPCM";
                        }
                        if (dtsRemux) {
                            type = "A_LPCM";
                            if (renderer.isMuxDTSToMpeg()) {
                                type = "A_DTS";
                            }
                        }
                    }
                    if (audio.getVideoDelay() != 0 && params.getTimeSeek() == 0.0) {
                        timeshift = "timeshift=" + audio.getVideoDelay() + "ms, ";
                    }
                    pw.println(type + ", \"" + ffAudioPipe[i].getOutputPipe() + "\", " + (String)timeshift + "track=" + (2 + i));
                }
            }
        }
        IPipeProcess tsPipe = PlatformUtils.INSTANCE.getPipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
        String executable = this.getExecutable();
        String[] cmdArray = new String[]{executable, f.getAbsolutePath(), tsPipe.getInputPipe()};
        ProcessWrapperImpl p = new ProcessWrapperImpl(cmdArray, params);
        params.setMaxBufferSize(100.0);
        params.getInputPipes()[0] = tsPipe;
        params.setStdIn(null);
        ProcessWrapper pipeProcess = tsPipe.getPipeProcess();
        p.attachProcess(pipeProcess);
        pipeProcess.runInNewThread();
        UMSUtils.sleep(50);
        tsPipe.deleteLater();
        ProcessWrapper ffPipeProcess = ffVideoPipe.getPipeProcess();
        p.attachProcess(ffPipeProcess);
        ffPipeProcess.runInNewThread();
        UMSUtils.sleep(50);
        ffVideoPipe.deleteLater();
        p.attachProcess(ffVideo);
        ffVideo.runInNewThread();
        UMSUtils.sleep(50);
        if (ffAudioPipe != null && audioTrack != null) {
            for (int i = 0; i < ffAudioPipe.length; ++i) {
                ffPipeProcess = ffAudioPipe[i].getPipeProcess();
                p.attachProcess(ffPipeProcess);
                ffPipeProcess.runInNewThread();
                UMSUtils.sleep(50);
                ffAudioPipe[i].deleteLater();
                p.attachProcess(ffAudio[i]);
                ffAudio[i].runInNewThread();
            }
        }
        UMSUtils.sleep(100);
        p.runInNewThread();
        return p;
    }

    @Override
    public String getMimeType() {
        return "video/transcode";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public boolean isInternalSubtitlesSupported() {
        return false;
    }

    @Override
    public boolean isExternalSubtitlesSupported() {
        return false;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        MediaSubtitle subtitle = item.getMediaSubtitle();
        if (subtitle != null && subtitle.getLang() != null) {
            return false;
        }
        MediaAudio audio = item.getMediaAudio();
        if (audio != null) {
            try {
                String audioTrackName = item.getMediaAudio().toString();
                String defaultAudioTrackName = item.getMediaInfo().getDefaultAudioTrack().toString();
                if (!audioTrackName.equals(defaultAudioTrackName)) {
                    return false;
                }
            }
            catch (NullPointerException e) {
                LOGGER.trace("tsMuxeR cannot determine compatibility based on audio track for " + item.getFileName());
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.trace("tsMuxeR cannot determine compatibility based on default audio track for " + item.getFileName());
            }
        }
        return PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && !encodingFormat.isTranscodeToHLS();
    }

    @Override
    @Nullable
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        String arg = "-v";
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        try {
            ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString(), "-v");
            if (output.getError() != null) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                result.available(Boolean.FALSE);
                LOGGER.debug("\"{} {}\" failed with error: {}", executableInfo.getPath(), "-v", output.getError().getMessage());
                return result.build();
            }
            if (output.getExitCode() == 0) {
                Pattern pattern;
                Matcher matcher;
                if (!output.getOutput().isEmpty() && (matcher = (pattern = Pattern.compile("tsMuxeR\\.\\s+Version\\s(\\S+)\\s+", 2)).matcher((CharSequence)output.getOutput().get(0))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                    result.version(new Version(matcher.group(1)));
                }
                result.available(Boolean.TRUE);
            } else {
                NTStatus ntStatus;
                NTStatus nTStatus = ntStatus = Platform.isWindows() ? NTStatus.typeOf(output.getExitCode()) : null;
                if (ntStatus != null) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + "\n\n" + String.valueOf((Object)ntStatus));
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineNotAvailableExitCode"), this, output.getExitCode()));
                    if (Platform.isLinux() && Platform.is64Bit()) {
                        result.errorType(ExecutableErrorType.GENERAL);
                        result.errorText(result.errorText() + ". \n" + Messages.getString("MakeSureNecessary32bitLibraries"));
                    }
                    result.available(Boolean.FALSE);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }

    public static boolean isValidForLPCMTranscoding(MediaInfo media) {
        return media != null && media.getContainer() != null && media.getDefaultVideoTrack() != null && media.getContainer().equals("mp4") && media.getDefaultVideoTrack().isH264();
    }

    public byte[] getH264AnnexB(InputFile f, MediaVideo video) {
        byte[][] headers;
        if (video.isH264() && (headers = FFmpegParser.getAnnexBFrameHeader(f)) != null && headers[1] != null) {
            byte[] result = new byte[headers[1].length];
            System.arraycopy(headers[1], 0, result, 0, headers[1].length);
            return result;
        }
        return null;
    }
}

