/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.video.metadata.ApiRatingSource;
import net.pms.media.video.metadata.ApiRatingSourceArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataRatings
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataRatings.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_RATINGS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_RATINGSOURCE = "RATINGSOURCE";
    private static final String COL_RATINGVALUE = "RATINGVALUE";
    private static final String TABLE_COL_FILEID = "VIDEO_METADATA_RATINGS.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_RATINGS.TVSERIESID";
    private static final String TABLE_COL_RATINGSOURCE = "VIDEO_METADATA_RATINGS.RATINGSOURCE";
    private static final String TABLE_COL_RATINGVALUE = "VIDEO_METADATA_RATINGS.RATINGVALUE";
    private static final String SQL_GET_RATING_FILEID = "SELECT VIDEO_METADATA_RATINGS.RATINGSOURCE, VIDEO_METADATA_RATINGS.RATINGVALUE FROM VIDEO_METADATA_RATINGS WHERE VIDEO_METADATA_RATINGS.FILEID = ?";
    private static final String SQL_GET_RATING_TVSERIESID = "SELECT VIDEO_METADATA_RATINGS.RATINGSOURCE, VIDEO_METADATA_RATINGS.RATINGVALUE FROM VIDEO_METADATA_RATINGS WHERE VIDEO_METADATA_RATINGS.TVSERIESID = ?";
    private static final String SQL_GET_TVSERIESID_EXISTS = "SELECT ID FROM VIDEO_METADATA_RATINGS WHERE VIDEO_METADATA_RATINGS.TVSERIESID = ? AND VIDEO_METADATA_RATINGS.RATINGSOURCE = ? LIMIT 1";
    private static final String SQL_GET_FILEID_EXISTS = "SELECT ID FROM VIDEO_METADATA_RATINGS WHERE VIDEO_METADATA_RATINGS.FILEID = ? AND VIDEO_METADATA_RATINGS.RATINGSOURCE = ? LIMIT 1";
    private static final String SQL_INSERT_TVSERIESID = "INSERT INTO VIDEO_METADATA_RATINGS (TVSERIESID, RATINGSOURCE, RATINGVALUE) VALUES (?, ?, ?)";
    private static final String SQL_INSERT_FILEID = "INSERT INTO VIDEO_METADATA_RATINGS (FILEID, RATINGSOURCE, RATINGVALUE) VALUES (?, ?, ?)";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataRatings.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataRatings.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataRatings.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataRatings.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataRatings.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "DROP INDEX IF EXISTS FILENAME_RATINGSOURCE_TVSERIESID_IDX");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ADD COLUMN IF NOT EXISTS FILEID INTEGER");
                    if (MediaTableVideoMetadataRatings.isColumnExist(connection, TABLE_NAME, "FILENAME")) {
                        MediaTableVideoMetadataRatings.executeUpdate(connection, "UPDATE VIDEO_METADATA_RATINGS SET FILEID=(SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = VIDEO_METADATA_RATINGS.FILENAME) WHERE VIDEO_METADATA_RATINGS.FILENAME != ''");
                        MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS DROP COLUMN IF EXISTS FILENAME");
                    }
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ALTER COLUMN IF EXISTS TVSERIESID DROP DEFAULT");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "UPDATE VIDEO_METADATA_RATINGS SET TVSERIESID = NULL WHERE VIDEO_METADATA_RATINGS.TVSERIESID = -1");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "UPDATE VIDEO_METADATA_RATINGS SET FILEID = NULL WHERE VIDEO_METADATA_RATINGS.TVSERIESID IS NOT NULL");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "UPDATE VIDEO_METADATA_RATINGS SET FILEID = NULL WHERE VIDEO_METADATA_RATINGS.FILEID = -1");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "DELETE FROM VIDEO_METADATA_RATINGS WHERE EXISTS (SELECT ID FROM VIDEO_METADATA_RATINGS T2 WHERE T2.TVSERIESID = VIDEO_METADATA_RATINGS.TVSERIESID AND T2.FILEID IS NULL AND T2.ID != VIDEO_METADATA_RATINGS.ID AND T2.RATINGSOURCE = VIDEO_METADATA_RATINGS.RATINGSOURCE AND T2.RATINGVALUE = VIDEO_METADATA_RATINGS.RATINGVALUE AND VIDEO_METADATA_RATINGS.ID != (SELECT MIN(T3.ID) FROM VIDEO_METADATA_RATINGS T3 WHERE T3.TVSERIESID = T2.TVSERIESID))");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ADD CONSTRAINT VIDEO_METADATA_RATINGS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ADD CONSTRAINT VIDEO_METADATA_RATINGS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataRatings.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_RATINGS ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataRatings.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataRatings.execute(connection, "CREATE TABLE VIDEO_METADATA_RATINGS(ID IDENTITY PRIMARY KEY, TVSERIESID BIGINT, FILEID BIGINT, RATINGSOURCE VARCHAR(1024) NOT NULL, RATINGVALUE VARCHAR(1024) NOT NULL, CONSTRAINT VIDEO_METADATA_RATINGS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_RATINGS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)");
    }

    public static void set(Connection connection, Long fileId, ApiRatingSourceArray ratings, Long tvSeriesID) {
        long id;
        String sqlInsert;
        String sqlSelect;
        if (ratings == null || ratings.isEmpty()) {
            return;
        }
        if (tvSeriesID != null) {
            sqlSelect = SQL_GET_TVSERIESID_EXISTS;
            sqlInsert = SQL_INSERT_TVSERIESID;
            id = tvSeriesID;
        } else if (fileId != null) {
            sqlSelect = SQL_GET_FILEID_EXISTS;
            sqlInsert = SQL_INSERT_FILEID;
            id = fileId;
        } else {
            return;
        }
        try {
            for (ApiRatingSource rating : ratings) {
                String source = rating.getSource();
                String value = rating.getValue();
                if (source == null) continue;
                PreparedStatement ps = connection.prepareStatement(sqlSelect);
                try {
                    ps.setLong(1, id);
                    ps.setString(2, StringUtils.left(source, 1024));
                    ResultSet rs = ps.executeQuery();
                    try {
                        if (rs.next()) {
                            LOGGER.trace("Record already exists {} {} {}", tvSeriesID, fileId, rating);
                            continue;
                        }
                        PreparedStatement insertStatement = connection.prepareStatement(sqlInsert, 1);
                        try {
                            insertStatement.clearParameters();
                            insertStatement.setLong(1, id);
                            insertStatement.setString(2, StringUtils.left(source, 1024));
                            insertStatement.setString(3, StringUtils.left(value, 1024));
                            insertStatement.executeUpdate();
                            ResultSet rs2 = insertStatement.getGeneratedKeys();
                            try {
                                if (!rs2.next()) continue;
                                LOGGER.trace("Set new entry successfully in VIDEO_METADATA_RATINGS with \"{}\", \"{}\" and \"{}\"", fileId, tvSeriesID, rating);
                            }
                            finally {
                                if (rs2 == null) continue;
                                rs2.close();
                            }
                        }
                        finally {
                            if (insertStatement == null) continue;
                            insertStatement.close();
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fileId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static ApiRatingSourceArray getRatingsForFile(Connection connection, Long fileId) {
        ApiRatingSourceArray result = new ApiRatingSourceArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_RATING_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ApiRatingSource source = new ApiRatingSource();
                    source.setSource(rs.getString(1));
                    source.setValue(rs.getString(2));
                    result.add(source);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_RATINGS for file ID \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForFile(Connection connection, Long fileId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_RATING_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JsonObject jObject = new JsonObject();
                    jObject.addProperty("source", rs.getString(1));
                    jObject.addProperty("value", rs.getString(2));
                    result.add(jObject);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_RATINGS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static ApiRatingSourceArray getRatingsForTvSeries(Connection connection, Long tvSerieId) {
        ApiRatingSourceArray result = new ApiRatingSourceArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_RATING_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ApiRatingSource source = new ApiRatingSource();
                    source.setSource(rs.getString(1));
                    source.setValue(rs.getString(2));
                    result.add(source);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_RATINGS for tv serie ID \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForTvSeries(Connection connection, Long tvSerieId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_RATING_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JsonObject jObject = new JsonObject();
                    jObject.addProperty("source", rs.getString(1));
                    jObject.addProperty("value", rs.getString(2));
                    result.add(jObject);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_RATINGS for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }
}

