/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableTablesVersions;
import net.pms.database.MediaTableTvSeasonMetadataLocalized;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.external.tmdb.TMDB;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataLocalized
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataLocalized.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_LOCALIZED";
    private static final int TABLE_VERSION = 3;
    private static final String COL_LANGUAGE = "LANGUAGE";
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_HOMEPAGE = "HOMEPAGE";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_OVERVIEW = "OVERVIEW";
    private static final String COL_POSTER = "POSTER";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_TAGLINE = "TAGLINE";
    private static final String TABLE_COL_LANGUAGE = "VIDEO_METADATA_LOCALIZED.LANGUAGE";
    private static final String TABLE_COL_FILEID = "VIDEO_METADATA_LOCALIZED.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_LOCALIZED.TVSERIESID";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.FILEID = ?";
    private static final String SQL_GET_ALL_TVSERIESID = "SELECT * FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.TVSERIESID = ?";
    private static final String SQL_GET_ALL_LANGUAGE_FILEID = "SELECT * FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.LANGUAGE = ? AND VIDEO_METADATA_LOCALIZED.FILEID = ?";
    private static final String SQL_GET_ALL_LANGUAGE_TVSERIESID = "SELECT * FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.LANGUAGE = ? AND VIDEO_METADATA_LOCALIZED.TVSERIESID = ?";
    private static final String SQL_GET_TVSERIESID_SIMPLIFIEDTITLE = "SELECT TVSERIESID FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.TVSERIESID IS NOT NULL AND REGEXP_REPLACE(LOWER(TITLE), '[^a-z0-9]', '') = ?";
    private static final String SQL_DELETE_FILEID = "DELETE FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.FILEID = ?";
    private static final String SQL_DELETE_TVSERIESID = "DELETE FROM VIDEO_METADATA_LOCALIZED WHERE VIDEO_METADATA_LOCALIZED.TVSERIESID = ?";
    private static final int SIZE_LANGUAGE = 5;

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataLocalized.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataLocalized.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataLocalized.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataLocalized.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataLocalized.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataLocalized.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_LOCALIZED ADD COLUMN IF NOT EXISTS MODIFIED BIGINT");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataLocalized.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_LOCALIZED ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataLocalized.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_LOCALIZED ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataLocalized.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataLocalized.execute(connection, "CREATE TABLE VIDEO_METADATA_LOCALIZED(ID IDENTITY PRIMARY KEY, LANGUAGE VARCHAR(5) NOT NULL, TVSERIESID BIGINT, FILEID BIGINT, MODIFIED BIGINT, HOMEPAGE VARCHAR, OVERVIEW CLOB, POSTER VARCHAR, TAGLINE VARCHAR, TITLE VARCHAR, CONSTRAINT VIDEO_METADATA_LOCALIZED_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_LOCALIZED_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)", "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_LOCALIZED_LANGUAGE_FILEID_TVSERIESID_IDX ON VIDEO_METADATA_LOCALIZED(LANGUAGE, FILEID, TVSERIESID)");
    }

    private static void set(Connection connection, Long id, boolean fromTvSeries, VideoMetadataLocalized metadata, String language) {
        if (id == null || id < 0L || StringUtils.isBlank(language)) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(fromTvSeries ? SQL_GET_ALL_LANGUAGE_TVSERIESID : SQL_GET_ALL_LANGUAGE_FILEID, 1003, 1008);){
            ps.setString(1, language);
            ps.setLong(2, id);
            try (ResultSet rs = ps.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !rs.next();
                if (isCreatingNewRecord) {
                    rs.moveToInsertRow();
                    rs.updateString(COL_LANGUAGE, StringUtils.left(language, 5));
                    rs.updateLong(fromTvSeries ? COL_TVSERIESID : COL_FILEID, (long)id);
                }
                rs.updateLong(COL_MODIFIED, System.currentTimeMillis());
                rs.updateString(COL_HOMEPAGE, metadata == null ? null : metadata.getHomepage());
                rs.updateString(COL_OVERVIEW, metadata == null ? null : metadata.getOverview());
                rs.updateString(COL_POSTER, metadata == null ? null : metadata.getPoster());
                rs.updateString(COL_TAGLINE, metadata == null ? null : metadata.getTagline());
                rs.updateString(COL_TITLE, metadata == null ? null : metadata.getTitle());
                if (isCreatingNewRecord) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, id, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static Map<String, VideoMetadataLocalized> getAllVideoMetadataLocalized(Connection connection, Long id, boolean fromTvSeries) {
        HashMap<String, VideoMetadataLocalized> result = new HashMap<String, VideoMetadataLocalized>();
        try (PreparedStatement ps = connection.prepareStatement(fromTvSeries ? SQL_GET_ALL_TVSERIESID : SQL_GET_ALL_FILEID);){
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VideoMetadataLocalized metadata = new VideoMetadataLocalized();
                    metadata.setHomepage(rs.getString(COL_HOMEPAGE));
                    metadata.setOverview(rs.getString(COL_OVERVIEW));
                    metadata.setPoster(rs.getString(COL_POSTER));
                    metadata.setTagline(rs.getString(COL_TAGLINE));
                    metadata.setTitle(rs.getString(COL_TITLE));
                    result.put(rs.getString(COL_LANGUAGE), metadata);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_LOCALIZED for \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoMetadataLocalized getVideoMetadataLocalized(Long id, boolean fromTvSeries, String language, String imdbId, String mediaType, Long tmdbId, Integer season, String episode) {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            if (connection == null) return null;
            VideoMetadataLocalized videoMetadataLocalized = MediaTableVideoMetadataLocalized.getVideoMetadataLocalized(connection, id, fromTvSeries, language, imdbId, mediaType, tmdbId, season, episode);
            return videoMetadataLocalized;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting metadata for web interface");
            LOGGER.debug("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoMetadataLocalized getVideoMetadataLocalized(Connection connection, Long id, boolean fromTvSeries, String language, String imdbId, String mediaType, Long tmdbId, Integer season, String episode) {
        VideoMetadataLocalized baseData;
        if (connection == null) return null;
        if (id == null) return null;
        if (id < 0L) return null;
        if (StringUtils.isBlank(language)) {
            return null;
        }
        try (PreparedStatement ps = connection.prepareStatement(fromTvSeries ? SQL_GET_ALL_LANGUAGE_TVSERIESID : SQL_GET_ALL_LANGUAGE_FILEID);){
            ps.setString(1, language);
            ps.setLong(2, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.first()) {
                    VideoMetadataLocalized result = new VideoMetadataLocalized();
                    result.setHomepage(rs.getString(COL_HOMEPAGE));
                    result.setOverview(rs.getString(COL_OVERVIEW));
                    result.setPoster(rs.getString(COL_POSTER));
                    result.setTagline(rs.getString(COL_TAGLINE));
                    result.setTitle(rs.getString(COL_TITLE));
                    VideoMetadataLocalized videoMetadataLocalized = result;
                    return videoMetadataLocalized;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_LOCALIZED for \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        LOGGER.trace("Looking for localized metadata for \"{}\": {}", (Object)mediaType, (Object)id);
        VideoMetadataLocalized result = TMDB.getVideoMetadataLocalized(language, mediaType, imdbId, tmdbId, season, episode);
        if (result != null && (baseData = fromTvSeries ? MediaTableTVSeries.getTvSeriesMetadataUnLocalized(connection, id) : MediaTableVideoMetadata.getVideoMetadataUnLocalized(connection, id)) != null) {
            if (result.getHomepage() != null && result.getHomepage().equals(baseData.getHomepage())) {
                result.setHomepage(null);
            }
            if (result.getOverview() != null && result.getOverview().equals(baseData.getOverview())) {
                result.setOverview(null);
            }
            if (result.getTagline() != null && result.getTagline().equals(baseData.getTagline())) {
                result.setTagline(null);
            }
            if (result.getTitle() != null && result.getTitle().equals(baseData.getTitle())) {
                result.setTitle(null);
            }
        }
        MediaTableVideoMetadataLocalized.set(connection, id, fromTvSeries, result, language);
        return result;
    }

    public static void clearVideoMetadataLocalized(Connection connection, Long id, boolean fromTvSeries) {
        if (connection == null || id == null || id < 0L) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(fromTvSeries ? SQL_DELETE_TVSERIESID : SQL_DELETE_FILEID);){
            ps.setLong(1, id);
            ps.execute();
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_LOCALIZED for deleting \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        if (fromTvSeries) {
            MediaTableTvSeasonMetadataLocalized.clearTvSeasonMetadataLocalized(connection, id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Long getTvSeriesIdFromTitle(Connection connection, String titleSimplified) {
        if (connection == null) return null;
        if (StringUtils.isBlank(titleSimplified)) {
            return null;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_TVSERIESID_SIMPLIFIEDTITLE);){
            ps.setString(1, titleSimplified);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.first()) return null;
                Long l = MediaTableVideoMetadataLocalized.toLong(rs, COL_TVSERIESID);
                return l;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_LOCALIZED for \"{}\": {}", (Object)titleSimplified, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }
}

