/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.dlna.DLNAThumbnail;
import net.pms.media.MediaInfo;
import net.pms.media.chapter.MediaChapter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableChapters
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableChapters.class);
    protected static final String TABLE_NAME = "CHAPTERS";
    private static final int TABLE_VERSION = 2;
    private static final String COL_ID = "ID";
    protected static final String COL_FILEID = "FILEID";
    private static final String COL_LANG = "LANG";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_START_TIME = "START_TIME";
    private static final String COL_END_TIME = "END_TIME";
    private static final String COL_THUMBNAIL = "THUMBNAIL";
    private static final String TABLE_COL_ID = "CHAPTERS.ID";
    private static final String TABLE_COL_FILEID = "CHAPTERS.FILEID";
    private static final String TABLE_COL_LANG = "CHAPTERS.LANG";
    private static final String SQL_GET_ALL_BY_FILEID = "SELECT * FROM CHAPTERS WHERE CHAPTERS.FILEID = ?";
    private static final String SQL_GET_ALL_BY_FILEID_ID_LANG = "SELECT * FROM CHAPTERS WHERE CHAPTERS.FILEID = ? AND CHAPTERS.ID = ? AND CHAPTERS.LANG = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableChapters.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 2) {
                MediaTableChapters.upgradeTable(connection, version);
            } else if (version > 2) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableChapters.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 2);
        block7: for (int version = currentVersion.intValue(); version < 2; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    try {
                        MediaTableChapters.executeUpdate(connection, "ALTER TABLE CHAPTERS RENAME CONSTRAINT PKCHAP TO CHAPTERS_PK");
                    }
                    catch (SQLException sQLException) {}
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(MediaTableChapters.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 2));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableChapters.execute(connection, "CREATE TABLE CHAPTERS (ID INTEGER NOT NULL, FILEID BIGINT NOT NULL, LANG VARCHAR(3), TITLE VARCHAR(255), START_TIME DOUBLE PRECISION, END_TIME DOUBLE PRECISION, THUMBNAIL OTHER, CONSTRAINT CHAPTERS_PK PRIMARY KEY(FILEID, ID, LANG), CONSTRAINT CHAPTERS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)");
    }

    protected static void insertOrUpdateChapters(Connection connection, long fileId, MediaInfo media) throws SQLException {
        if (connection == null || fileId < 0L || media == null || !media.hasChapters()) {
            return;
        }
        try (PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_ALL_BY_FILEID_ID_LANG, 1003, 1008);){
            for (MediaChapter chapter : media.getChapters()) {
                updateStatement.clearParameters();
                updateStatement.setLong(1, fileId);
                updateStatement.setInt(2, chapter.getId());
                updateStatement.setString(3, chapter.getLang());
                ResultSet result = updateStatement.executeQuery();
                try {
                    boolean isCreatingNewRecord;
                    boolean bl = isCreatingNewRecord = !result.next();
                    if (isCreatingNewRecord) {
                        result.moveToInsertRow();
                        result.updateLong(COL_FILEID, fileId);
                        result.updateInt(COL_ID, chapter.getId());
                        result.updateString(COL_LANG, chapter.getLang());
                    }
                    result.updateString(COL_TITLE, StringUtils.left(chapter.getTitle(), 255));
                    result.updateDouble(COL_START_TIME, chapter.getStart());
                    result.updateDouble(COL_END_TIME, chapter.getEnd());
                    result.updateObject(COL_THUMBNAIL, (Object)chapter.getThumbnail());
                    if (isCreatingNewRecord) {
                        result.insertRow();
                        continue;
                    }
                    result.updateRow();
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
        }
    }

    protected static List<MediaChapter> getChapters(Connection connection, long fileId) {
        ArrayList<MediaChapter> result = new ArrayList<MediaChapter>();
        if (connection == null || fileId < 0L) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_BY_FILEID);){
            stmt.setLong(1, fileId);
            try (ResultSet elements = stmt.executeQuery();){
                while (elements.next()) {
                    MediaChapter chapter = new MediaChapter();
                    chapter.setId(elements.getInt(COL_ID));
                    chapter.setLang(elements.getString(COL_LANG));
                    chapter.setTitle(elements.getString(COL_TITLE));
                    chapter.setStart(elements.getDouble(COL_START_TIME));
                    chapter.setEnd(elements.getDouble(COL_END_TIME));
                    chapter.setThumbnail((DLNAThumbnail)elements.getObject(COL_THUMBNAIL));
                    LOGGER.trace("Adding chapter from the database: {}", (Object)chapter.toString());
                    result.add(chapter);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in CHAPTERS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }
}

