/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import java.net.InetAddress;
import java.util.UUID;
import net.pms.PMS;
import net.pms.configuration.ConfigurationReader;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.renderers.ConnectedRenderers;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererDeviceConfiguration
extends RendererConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererDeviceConfiguration.class);
    private static final int DEVICE = 0;
    private static final int RENDERER = 1;
    private PropertiesConfiguration deviceConf = null;
    private RendererConfiguration ref = null;
    protected String uuid;

    public RendererDeviceConfiguration(RendererConfiguration ref, InetAddress ia, String uuid) throws ConfigurationException, InterruptedException {
        this.initDeviceConfiguration(ia, uuid);
        this.inherit(ref);
        if (uuid == null && ia != null) {
            uuid = UUID.nameUUIDFromBytes(ia.getAddress()).toString();
        }
        if (uuid != null) {
            this.uuid = uuid;
        }
    }

    public final void inherit(RendererConfiguration ref) throws ConfigurationException {
        CompositeConfiguration cconf = new CompositeConfiguration();
        cconf.setListDelimiter('\u0000');
        cconf.addConfiguration(this.deviceConf, true);
        if (ref == null) {
            cconf.addConfiguration(this.getConfiguration());
        } else {
            cconf.addConfiguration(ref.getConfiguration());
        }
        UmsConfiguration baseConf = PMS.getConfiguration();
        cconf.addConfiguration(baseConf.getConfiguration());
        this.configuration = cconf;
        this.configurationReader = new ConfigurationReader(this.configuration, true);
        this.umsConfiguration = new UmsConfiguration(this.configuration, this.configurationReader);
        if (ref != null) {
            this.sortedHeaderMatcher = ref.sortedHeaderMatcher;
        }
        this.loaded = true;
        this.ref = ref == null ? this : ref;
        this.init(NOFILE);
    }

    public final void inheritDefault() throws ConfigurationException {
        this.inherit(RendererConfigurations.getDefaultConf());
        this.loaded = false;
    }

    @Override
    public void reset() {
        try {
            this.inherit(this.ref);
        }
        catch (ConfigurationException e) {
            LOGGER.debug("Error reloading device configuration {}: {}", (Object)this, (Object)e);
        }
    }

    public void setUUID(String uuid) {
        if (uuid != null && !uuid.equals(this.uuid)) {
            this.uuid = uuid;
            this.uuidChanged();
            if (RendererConfigurations.isDeviceConfigurationChanged(uuid, this.deviceConf)) {
                this.initDeviceConfiguration(null, uuid);
                this.reset();
            }
        }
    }

    public String getUUID() {
        return this.uuid;
    }

    protected void uuidChanged() {
    }

    public final PropertiesConfiguration initDeviceConfiguration(InetAddress ia, String uuid) {
        String id;
        String string = id = uuid != null ? uuid : ConnectedRenderers.getUuidOf(ia);
        if (!(ia == null || id != null && RendererConfigurations.hasDeviceConfiguration(id))) {
            id = ia.toString().substring(1);
        }
        if (id != null && RendererConfigurations.hasDeviceConfiguration(id)) {
            this.deviceConf = RendererConfigurations.getDeviceConfiguration(id);
            LOGGER.info("Using custom device configuration {} for {}", (Object)this.deviceConf.getFile().getName(), (Object)id);
        } else {
            this.deviceConf = RendererDeviceConfiguration.createPropertiesConfiguration();
        }
        return this.deviceConf;
    }

    public PropertiesConfiguration getConfiguration(int index) {
        CompositeConfiguration c = (CompositeConfiguration)this.configuration;
        return (PropertiesConfiguration)c.getConfiguration(index);
    }

    public PropertiesConfiguration getDeviceConfiguration() {
        return this.getConfiguration(0);
    }

    @Override
    public File getFile() {
        if (this.loaded) {
            File f = this.getConfiguration(0).getFile();
            return f != null && !f.equals(NOFILE) ? f : this.getConfiguration(1).getFile();
        }
        return null;
    }

    public File getParentFile() {
        return this.getConfiguration(1).getFile();
    }

    public RendererConfiguration getRef() {
        return this.ref;
    }

    public boolean isValid() {
        if (this.loaded) {
            File f = this.getConfiguration(0).getFile();
            if (f != null && !f.exists()) {
                this.getConfiguration(0).setFile(NOFILE);
                this.getConfiguration(0).clear();
                RendererConfigurations.removeDeviceConfiguration(this.getUUID());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isCustomized() {
        if (this.isValid()) {
            File f = this.getConfiguration(0).getFile();
            return f != null && !f.equals(NOFILE);
        }
        return false;
    }
}

