/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.pms.configuration.ConfigurationReader;
import net.pms.util.StringUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class BaseConfiguration {
    private static final StringUtil.LaxUnicodeUnescaper LAX_UNICODE_UNESCAPER = new StringUtil.LaxUnicodeUnescaper();
    public static final String EMPTY_LIST_VALUE = "None";
    protected Configuration configuration;
    protected ConfigurationReader configurationReader;

    protected BaseConfiguration(Configuration configuration, ConfigurationReader configurationReader) {
        this.configuration = configuration;
        this.configurationReader = configurationReader;
    }

    protected BaseConfiguration(boolean logOverrides) {
        this.configuration = BaseConfiguration.createPropertiesConfiguration();
        this.configurationReader = new ConfigurationReader(this.configuration, logOverrides);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public int getInt(String key, int def) {
        return this.configurationReader.getInt(key, def);
    }

    public long getLong(String key, long def) {
        return this.configurationReader.getLong(key, def);
    }

    public double getDouble(String key, double def) {
        return this.configurationReader.getDouble(key, def);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.configurationReader.getBoolean(key, def);
    }

    public final String getString(String key, String def) {
        return this.configurationReader.getNonBlankConfigurationString(key, def);
    }

    public List<String> getStringList(String key, String def) {
        List<String> result = this.configurationReader.getStringList(key, def);
        if (result.size() == 1 && result.get(0).equalsIgnoreCase(EMPTY_LIST_VALUE)) {
            return new ArrayList<String>();
        }
        return result;
    }

    public void setStringList(String key, List<String> value) {
        StringBuilder result = new StringBuilder();
        for (String element : value) {
            if (!result.toString().isEmpty()) {
                result.append(", ");
            }
            result.append(element);
        }
        if (result.toString().isEmpty()) {
            result.append(EMPTY_LIST_VALUE);
        }
        this.configuration.setProperty(key, result.toString());
    }

    public static PropertiesConfiguration createPropertiesConfiguration() {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.setListDelimiter('\u0000');
        conf.setIOFactory(new PropertiesConfiguration.DefaultIOFactory(){

            @Override
            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in, char delimiter) {
                return new PropertiesConfiguration.PropertiesReader(in, delimiter){

                    @Override
                    protected void parseProperty(String line) {
                        super.parseProperty(LAX_UNICODE_UNESCAPER.translate(line).replace("\\\\", "\\").replace("\\", "\\\\"));
                    }
                };
            }
        });
        return conf;
    }

    protected String convertMencoderSettingToFFmpegFormat(String mpegSettings) {
        String[] mpegSettingsArray = mpegSettings.split(":");
        StringBuilder returnString = new StringBuilder();
        block12: for (String pair : mpegSettingsArray) {
            String[] pairArray = pair.split("=");
            switch (pairArray[0]) {
                case "keyint": {
                    returnString.append("-g ").append(pairArray[1]).append(' ');
                    continue block12;
                }
                case "vqscale": {
                    returnString.append("-q:v ").append(pairArray[1]).append(' ');
                    continue block12;
                }
                case "vqmin": {
                    returnString.append("-qmin ").append(pairArray[1]).append(' ');
                    continue block12;
                }
                case "vqmax": {
                    returnString.append("-qmax ").append(pairArray[1]).append(' ');
                    continue block12;
                }
            }
        }
        return returnString.toString();
    }
}

