/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public abstract class DNSMessage {
    private int _id;
    boolean _multicast;
    private int _flags;
    protected final List<DNSQuestion> _questions;
    protected final List<DNSRecord> _answers;
    protected final List<DNSRecord> _authoritativeAnswers;
    protected final List<DNSRecord> _additionals;

    protected DNSMessage(int flags, int id, boolean multicast) {
        this._flags = flags;
        this._id = id;
        this._multicast = multicast;
        this._questions = Collections.synchronizedList(new LinkedList());
        this._answers = Collections.synchronizedList(new LinkedList());
        this._authoritativeAnswers = Collections.synchronizedList(new LinkedList());
        this._additionals = Collections.synchronizedList(new LinkedList());
    }

    public int getId() {
        return this._multicast ? 0 : this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public Collection<? extends DNSQuestion> getQuestions() {
        return this._questions;
    }

    public int getNumberOfQuestions() {
        return this.getQuestions().size();
    }

    public List<DNSRecord> getAllAnswers() {
        ArrayList<DNSRecord> aList = new ArrayList<DNSRecord>(this._answers.size() + this._authoritativeAnswers.size() + this._additionals.size());
        aList.addAll(this._answers);
        aList.addAll(this._authoritativeAnswers);
        aList.addAll(this._additionals);
        return aList;
    }

    public Collection<? extends DNSRecord> getAnswers() {
        return this._answers;
    }

    public int getNumberOfAnswers() {
        return this.getAnswers().size();
    }

    public Collection<? extends DNSRecord> getAuthorities() {
        return this._authoritativeAnswers;
    }

    public int getNumberOfAuthorities() {
        return this.getAuthorities().size();
    }

    public Collection<? extends DNSRecord> getAdditionals() {
        return this._additionals;
    }

    public int getNumberOfAdditionals() {
        return this.getAdditionals().size();
    }

    public boolean isValidResponseCode() {
        return (this._flags & 0xF) == 0;
    }

    public int getOperationCode() {
        return (this._flags & 0x7800) >> 11;
    }

    public boolean isTruncated() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isAuthoritativeAnswer() {
        return (this._flags & 0x400) != 0;
    }

    public boolean isQuery() {
        return (this._flags & 0x8000) == 0;
    }

    public boolean isResponse() {
        return (this._flags & 0x8000) == 32768;
    }

    public boolean isEmpty() {
        return this.getNumberOfQuestions() + this.getNumberOfAnswers() + this.getNumberOfAuthorities() + this.getNumberOfAdditionals() == 0;
    }

    protected String print() {
        StringBuilder sb = new StringBuilder(200);
        this.appendStatistics(sb, "questions", this._questions);
        this.appendStatistics(sb, "answers", this._answers);
        this.appendStatistics(sb, "authorities", this._authoritativeAnswers);
        this.appendStatistics(sb, "additionals", this._additionals);
        this.appendDNSEntries(sb, "questions", this._questions);
        this.appendDNSEntries(sb, "answers", this._answers);
        this.appendDNSEntries(sb, "authorities", this._authoritativeAnswers);
        this.appendDNSEntries(sb, "additionals", this._additionals);
        return sb.toString();
    }

    private <T extends DNSEntry> void appendStatistics(StringBuilder sb, String name, List<T> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        sb.append(", ");
        sb.append(name);
        sb.append("=");
        sb.append(entries.size());
    }

    private <T extends DNSEntry> void appendDNSEntries(StringBuilder sb, String name, List<T> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        sb.append("\n");
        sb.append(name);
        sb.append(":");
        for (DNSEntry entry : entries) {
            sb.append("\n\t");
            sb.append(entry);
        }
    }

    protected String print(byte[] data) {
        StringBuilder sb = new StringBuilder(4000);
        int len = data.length;
        for (int off = 0; off < len; off += 32) {
            int index;
            int n = Math.min(32, len - off);
            if (off < 16) {
                sb.append(' ');
            }
            if (off < 256) {
                sb.append(' ');
            }
            if (off < 4096) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(off));
            sb.append(':');
            for (index = 0; index < n; ++index) {
                if (index % 8 == 0) {
                    sb.append(' ');
                }
                sb.append(Integer.toHexString((data[off + index] & 0xF0) >> 4));
                sb.append(Integer.toHexString(data[off + index] & 0xF));
            }
            if (index < 32) {
                for (int i = index; i < 32; ++i) {
                    if (i % 8 == 0) {
                        sb.append(' ');
                    }
                    sb.append("  ");
                }
            }
            sb.append("    ");
            for (index = 0; index < n; ++index) {
                int ch;
                if (index % 8 == 0) {
                    sb.append(' ');
                }
                sb.append((ch = data[off + index] & 0xFF) > 32 && ch < 127 ? (char)ch : (char)'.');
            }
            sb.append("\n");
            if (off + 32 < 2048) continue;
            sb.append("....\n");
            break;
        }
        return sb.toString();
    }
}

