/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.tv.episode;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.episode.TvEpisodeAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeAccountStatesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeExternalIdsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.episode.TvEpisodeTranslationsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.video.VideosResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TvEpisodeTvIdEndpoint
extends Endpoint {
    private static final String V3_TV_ENDPOINT = "/3/tv/";
    private static final String SEASON_ENDPOINT = "/season/";
    private static final String EPISODE_ENDPOINT = "/episode/";
    private static final String ACCOUNT_STATES_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.ACCOUNT_STATES);
    private static final String CREDITS_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.CREDITS);
    private static final String EXTERNAL_IDS_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.EXTERNAL_IDS);
    private static final String IMAGES_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.IMAGES);
    private static final String RATING_ENDPOINT = "/rating";
    private static final String TRANSLATIONS_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.TRANSLATIONS);
    private static final String VIDEOS_ENDPOINT = "/" + String.valueOf((Object)TvEpisodeAppendToResponse.VIDEOS);
    private final long tvId;
    private final long seasonNumber;
    private final long episodeNumber;
    private final List<TvEpisodeAppendToResponse> appendToResponse = new ArrayList<TvEpisodeAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private final List<String> includeVideoLanguage = new ArrayList<String>();
    private String language;

    public TvEpisodeTvIdEndpoint(TMDbClient tmdbClient, long tvId, long seasonNumber, long episodeNumber) {
        super(tmdbClient);
        this.tvId = tvId;
        this.seasonNumber = seasonNumber;
        this.episodeNumber = episodeNumber;
    }

    public TvEpisodeTvIdEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public TvEpisodeTvIdEndpoint appendToResponse(TvEpisodeAppendToResponse ... values) {
        if (values != null) {
            TvEpisodeAppendToResponse[] tvEpisodeAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                TvEpisodeAppendToResponse value = tvEpisodeAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvEpisodeTvIdEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeImageLanguage.contains(value)) {
                    this.includeImageLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvEpisodeTvIdEndpoint includeVideoLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeVideoLanguage.contains(value)) {
                    this.includeVideoLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvEpisodeDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEpisodeTvIdEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        TvEpisodeTvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        TvEpisodeTvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber, TvEpisodeDetailsSchema.class, query);
    }

    public TvEpisodeAccountStatesResponseSchema getAccountStates() {
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + ACCOUNT_STATES_ENDPOINT, TvEpisodeAccountStatesResponseSchema.class, null);
    }

    public TvEpisodeCreditsResponseSchema getCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + CREDITS_ENDPOINT, TvEpisodeCreditsResponseSchema.class, query);
    }

    public TvEpisodeExternalIdsResponseSchema getExternalIds() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + EXTERNAL_IDS_ENDPOINT, TvEpisodeExternalIdsResponseSchema.class, query);
    }

    public TvEpisodeImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEpisodeTvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + IMAGES_ENDPOINT, TvEpisodeImagesResponseSchema.class, query);
    }

    public TvEpisodeTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + TRANSLATIONS_ENDPOINT, TvEpisodeTranslationsResponseSchema.class, query);
    }

    public VideosResponseSchema getVideos() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEpisodeTvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EPISODE_ENDPOINT + this.episodeNumber + VIDEOS_ENDPOINT, VideosResponseSchema.class, query);
    }

    public StatusSchema deleteRating() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        TvEpisodeTvIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        return this.tmdbClient.delete(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + RATING_ENDPOINT, StatusSchema.class, query);
    }

    public StatusSchema postRating(float value) {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEpisodeTvIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        TvEpisodeTvIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", Float.valueOf(value));
        return this.tmdbClient.post(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + RATING_ENDPOINT, StatusSchema.class, query, jsonObject.toString());
    }
}

