/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.tv;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.TvIdAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.account.AccountStatesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.change.ChangesSchema;
import com.universalmediaserver.tmdbapi.schema.credit.AggregateCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.credit.MediaCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.image.ImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.reviews.ReviewsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvAlternativeTitlesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvContentRatingsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvEpisodeGroupsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvExternalIdsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvKeywordsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvScreenedTheatricallyResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleResultsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTranslationsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTypedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.video.VideosResponseSchema;
import com.universalmediaserver.tmdbapi.schema.watchproviders.WatchProvidersResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TvIdEndpoint
extends Endpoint {
    private static final String V3_TV_ENDPOINT = "/3/tv/";
    private static final String ACCOUNT_STATES_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.ACCOUNT_STATES);
    private static final String AGGREGATE_CREDITS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.AGGREGATE_CREDITS);
    private static final String ALTERNATIVE_TITLES_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.ALTERNATIVE_TITLES);
    private static final String CHANGES_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.CHANGES);
    private static final String CONTENT_RATINGS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.CONTENT_RATINGS);
    private static final String CREDITS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.CREDITS);
    private static final String EPISODE_GROUPS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.EPISODE_GROUPS);
    private static final String EXTERNAL_IDS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.EXTERNAL_IDS);
    private static final String IMAGES_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.IMAGES);
    private static final String KEYWORDS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.KEYWORDS);
    private static final String RATING_ENDPOINT = "/rating";
    private static final String RECOMMENDATIONS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.RECOMMENDATIONS);
    private static final String REVIEWS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.REVIEWS);
    private static final String SCREENED_THEATRICALLY_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.SCREENED_THEATRICALLY);
    private static final String SIMILAR_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.SIMILAR);
    private static final String TRANSLATIONS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.TRANSLATIONS);
    private static final String VIDEOS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.VIDEOS);
    private static final String WATCH_PROVIDERS_ENDPOINT = "/" + String.valueOf((Object)TvIdAppendToResponse.WATCH_PROVIDERS);
    private final long tvId;
    private final List<TvIdAppendToResponse> appendToResponse = new ArrayList<TvIdAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private final List<String> includeVideoLanguage = new ArrayList<String>();
    private String language;
    private String startDate;
    private String endDate;
    private int page;

    public TvIdEndpoint(TMDbClient tmdbClient, long tvId) {
        super(tmdbClient);
        this.tvId = tvId;
    }

    public TvIdEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public TvIdEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public TvIdEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public TvIdEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public TvIdEndpoint appendToResponse(TvIdAppendToResponse ... values) {
        if (values != null) {
            TvIdAppendToResponse[] tvIdAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                TvIdAppendToResponse value = tvIdAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvIdEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeImageLanguage.contains(value)) {
                    this.includeImageLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvIdEndpoint includeVideoLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeVideoLanguage.contains(value)) {
                    this.includeVideoLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        TvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        TvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId, TvDetailsSchema.class, query);
    }

    public AccountStatesResponseSchema getAccountStates() {
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + ACCOUNT_STATES_ENDPOINT, AccountStatesResponseSchema.class, null);
    }

    public AggregateCreditsResponseSchema getAggregateCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + AGGREGATE_CREDITS_ENDPOINT, AggregateCreditsResponseSchema.class, query);
    }

    public TvAlternativeTitlesResponseSchema getAlternativeTitles() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + ALTERNATIVE_TITLES_ENDPOINT, TvAlternativeTitlesResponseSchema.class, query);
    }

    public ChangesSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "start_date", this.startDate);
        TvIdEndpoint.addQueryString(query, "end_date", this.endDate);
        TvIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + CHANGES_ENDPOINT, ChangesSchema.class, query);
    }

    public TvContentRatingsResponseSchema getContentRatings() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + CONTENT_RATINGS_ENDPOINT, TvContentRatingsResponseSchema.class, query);
    }

    public MediaCreditsResponseSchema getCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + CREDITS_ENDPOINT, MediaCreditsResponseSchema.class, query);
    }

    public TvEpisodeGroupsResponseSchema getEpisodeGroups() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + EPISODE_GROUPS_ENDPOINT, TvEpisodeGroupsResponseSchema.class, query);
    }

    public TvExternalIdsResponseSchema getExternalIds() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + EXTERNAL_IDS_ENDPOINT, TvExternalIdsResponseSchema.class, query);
    }

    public ImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + IMAGES_ENDPOINT, ImagesResponseSchema.class, query);
    }

    public TvKeywordsResponseSchema getKeywords() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + KEYWORDS_ENDPOINT, TvKeywordsResponseSchema.class, query);
    }

    public TvTypedResultsSchema getRecommendations() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + RECOMMENDATIONS_ENDPOINT, TvTypedResultsSchema.class, query);
    }

    public ReviewsResponseSchema getReviews() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + REVIEWS_ENDPOINT, ReviewsResponseSchema.class, query);
    }

    public TvScreenedTheatricallyResponseSchema getScreenedTheatrically() {
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SCREENED_THEATRICALLY_ENDPOINT, TvScreenedTheatricallyResponseSchema.class, null);
    }

    public TvSimpleResultsSchema getSimilar() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SIMILAR_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + TRANSLATIONS_ENDPOINT, TvTranslationsResponseSchema.class, query);
    }

    public VideosResponseSchema getVideos() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + VIDEOS_ENDPOINT, VideosResponseSchema.class, query);
    }

    public WatchProvidersResponseSchema getWatchProviders() {
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + WATCH_PROVIDERS_ENDPOINT, WatchProvidersResponseSchema.class, null);
    }

    public StatusSchema deleteRating() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        TvIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        return this.tmdbClient.delete(V3_TV_ENDPOINT + this.tvId + RATING_ENDPOINT, StatusSchema.class, query);
    }

    public StatusSchema postRating(float value) {
        HashMap<String, String> query = new HashMap<String, String>();
        TvIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        TvIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", Float.valueOf(value));
        return this.tmdbClient.post(V3_TV_ENDPOINT + this.tvId + RATING_ENDPOINT, StatusSchema.class, query, jsonObject.toString());
    }
}

