/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.network;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.network.NetworkAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.network.NetworkAlternativeNamesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.network.NetworkDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.network.NetworkImagesResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NetworkEndpoint
extends Endpoint {
    private static final String V3_NETWORK_ENDPOINT = "/3/network/";
    private static final String IMAGES_ENDPOINT = "/images";
    private static final String ALTERNATIVE_NAMES_ENDPOINT = "/alternative_names";
    private final long networkId;
    private final List<NetworkAppendToResponse> appendToResponse = new ArrayList<NetworkAppendToResponse>();

    public NetworkEndpoint(TMDbClient tmdbClient, long networkId) {
        super(tmdbClient);
        this.networkId = networkId;
    }

    public NetworkEndpoint appendToResponse(NetworkAppendToResponse ... values) {
        if (values != null) {
            NetworkAppendToResponse[] networkAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkAppendToResponse networkAppendToResponse = networkAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)networkAppendToResponse)) {
                    this.appendToResponse.add(networkAppendToResponse);
                }
                ++n2;
            }
        }
        return this;
    }

    public NetworkDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        NetworkEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId, NetworkDetailsSchema.class, query);
    }

    public NetworkImagesResponseSchema getImages() {
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId + IMAGES_ENDPOINT, NetworkImagesResponseSchema.class, null);
    }

    public NetworkAlternativeNamesResponseSchema getAlternativeNames() {
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId + ALTERNATIVE_NAMES_ENDPOINT, NetworkAlternativeNamesResponseSchema.class, null);
    }
}

