/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.company;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.company.CompanyAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.network.NetworkAlternativeNamesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.network.NetworkDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.network.NetworkImagesResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompanyEndpoint
extends Endpoint {
    private static final String V3_NETWORK_ENDPOINT = "/3/network/";
    private static final String IMAGES_ENDPOINT = "/images";
    private static final String ALTERNATIVE_NAMES_ENDPOINT = "/alternative_names";
    private final long networkId;
    private final List<CompanyAppendToResponse> appendToResponse = new ArrayList<CompanyAppendToResponse>();

    public CompanyEndpoint(TMDbClient tmdbClient, long networkId) {
        super(tmdbClient);
        this.networkId = networkId;
    }

    public CompanyEndpoint appendToResponse(CompanyAppendToResponse ... values) {
        if (values != null) {
            CompanyAppendToResponse[] companyAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                CompanyAppendToResponse value = companyAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public NetworkDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        CompanyEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId, NetworkDetailsSchema.class, query);
    }

    public NetworkImagesResponseSchema getImages() {
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId + IMAGES_ENDPOINT, NetworkImagesResponseSchema.class, null);
    }

    public NetworkAlternativeNamesResponseSchema getAlternativeNames() {
        return this.tmdbClient.get(V3_NETWORK_ENDPOINT + this.networkId + ALTERNATIVE_NAMES_ENDPOINT, NetworkAlternativeNamesResponseSchema.class, null);
    }
}

