/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.auth;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.auth.AuthAccessTokenSchema;
import com.universalmediaserver.tmdbapi.schema.auth.AuthRequestTokenSchema;
import java.util.HashMap;

public class AuthEndpoint
extends Endpoint {
    private static final String AUTHENTICATION_ENDPOINT = "/4/auth/";
    private static final String REQUEST_TOKEN_ENDPOINT = "/4/auth/request_token";
    private static final String ACCESS_TOKEN_ENDPOINT = "/4/auth/access_token";

    public AuthEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public AuthRequestTokenSchema createRequestToken() {
        return this.createRequestToken(null);
    }

    public AuthRequestTokenSchema createRequestToken(String redirectTo) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("redirect_to", redirectTo);
        return this.tmdbClient.post(REQUEST_TOKEN_ENDPOINT, AuthRequestTokenSchema.class, null, jsonObject.toString());
    }

    public AuthAccessTokenSchema createAccessToken(String requestToken) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("request_token", requestToken);
        return this.tmdbClient.post(ACCESS_TOKEN_ENDPOINT, AuthAccessTokenSchema.class, null, jsonObject.toString());
    }

    public StatusSchema deleteAccessToken(String accessToken) {
        HashMap<String, String> query = new HashMap<String, String>();
        AuthEndpoint.addQueryString(query, "access_token", accessToken);
        return this.tmdbClient.delete(ACCESS_TOKEN_ENDPOINT, StatusSchema.class, null);
    }
}

