/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.account.movie;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.movie.MovieSortBy;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortResultsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTypedResultsSchema;
import java.util.HashMap;

public class AccountMovieV4Endpoint
extends Endpoint {
    private static final String V4_ACCOUNT_ENDPOINT = "/4/account/";
    private static final String V4_ACCOUNT_MOVIE_ENDPOINT = "/movie/";
    private static final String MOVIE_FAVORITES_ENDPOINT = "/movie/favorites";
    private static final String MOVIE_RECOMMENDATIONS_ENDPOINT = "/movie/recommendations";
    private static final String MOVIE_WATCHLIST_ENDPOINT = "/movie/watchlist";
    private static final String MOVIE_RATED_ENDPOINT = "/movie/rated";
    private final String accountId;
    private String sortBy;
    private int page;

    public AccountMovieV4Endpoint(TMDbClient tmdbClient, String accountId) {
        super(tmdbClient);
        this.accountId = accountId;
    }

    public AccountMovieV4Endpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public AccountMovieV4Endpoint sortBy(MovieSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public MovieShortResultsSchema getFavorites() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountMovieV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountMovieV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + MOVIE_FAVORITES_ENDPOINT, MovieShortResultsSchema.class, query);
    }

    public MovieTypedResultsSchema getRecommendations() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountMovieV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountMovieV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + MOVIE_RECOMMENDATIONS_ENDPOINT, MovieTypedResultsSchema.class, query);
    }

    public MovieShortResultsSchema getWatchlist() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountMovieV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountMovieV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + MOVIE_WATCHLIST_ENDPOINT, MovieShortResultsSchema.class, query);
    }

    public MovieShortResultsSchema getRated() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountMovieV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountMovieV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + MOVIE_RATED_ENDPOINT, MovieShortResultsSchema.class, query);
    }
}

