/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.account;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.movie.AccountMovieV4Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.tv.AccountTvV4Endpoint;
import com.universalmediaserver.tmdbapi.schema.list.ListV4SimpleResultsSchema;
import java.util.HashMap;

public class AccountIdV4Endpoint
extends Endpoint {
    private static final String V4_ACCOUNT_ENDPOINT = "/4/account/";
    private static final String LISTS_ENDPOINT = "/lists";
    private final String accountId;
    private int page;

    public AccountIdV4Endpoint(TMDbClient tmdbClient, String accountId) {
        super(tmdbClient);
        this.accountId = accountId;
    }

    public AccountMovieV4Endpoint forMovie() {
        return new AccountMovieV4Endpoint(this.tmdbClient, this.accountId);
    }

    public AccountTvV4Endpoint forTv() {
        return new AccountTvV4Endpoint(this.tmdbClient, this.accountId);
    }

    public AccountIdV4Endpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public ListV4SimpleResultsSchema getLists() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountIdV4Endpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + LISTS_ENDPOINT, ListV4SimpleResultsSchema.class, query);
    }
}

