/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageWriter;
import com.twelvemonkeys.imageio.plugins.psd.PSDProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageWriterSpiBase;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;

public final class PSDImageWriterSpi
extends ImageWriterSpiBase {
    public PSDImageWriterSpi() {
        super(new PSDProviderInfo());
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        try {
            PSDImageWriter.getBitsPerSample(imageTypeSpecifier.getSampleModel());
            PSDImageWriter.getColorMode(imageTypeSpecifier.getColorModel());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return imageTypeSpecifier.getNumBands() <= 56;
    }

    @Override
    public ImageWriter createWriterInstance(Object object) {
        return new PSDImageWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Adobe Photoshop Document (PSD) image writer";
    }
}

