/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderWriter;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOImage;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class PNMHeaderWriter
extends HeaderWriter {
    public PNMHeaderWriter(ImageOutputStream imageOutputStream) {
        super(imageOutputStream);
    }

    @Override
    public void writeHeader(IIOImage iIOImage, ImageWriterSpi imageWriterSpi) throws IOException {
        short s = this.type(iIOImage);
        this.imageOutput.writeShort(s);
        this.imageOutput.write(10);
        this.writeComments(iIOImage.getMetadata(), imageWriterSpi);
        this.imageOutput.write(String.format("%s %s\n", this.getWidth(iIOImage), this.getHeight(iIOImage)).getBytes(StandardCharsets.UTF_8));
        if (s != 20532) {
            this.imageOutput.write(String.format("%s\n", this.getMaxVal(iIOImage)).getBytes(StandardCharsets.UTF_8));
        }
    }

    private short type(IIOImage iIOImage) {
        TupleType tupleType = PNMHeaderWriter.tupleType(iIOImage);
        if (tupleType != null) {
            switch (tupleType) {
                case BLACKANDWHITE_WHITE_IS_ZERO: {
                    return 20532;
                }
                case GRAYSCALE: {
                    return 20533;
                }
                case RGB: {
                    return 20534;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported tupleType: " + (Object)((Object)tupleType));
    }

    private static TupleType tupleType(IIOImage iIOImage) {
        TupleType tupleType;
        TupleType tupleType2 = tupleType = iIOImage.hasRaster() ? TupleType.forPNM(iIOImage.getRaster()) : TupleType.forPNM(ImageTypeSpecifiers.createFromRenderedImage(iIOImage.getRenderedImage()));
        if (tupleType == null) {
            throw new IllegalArgumentException("Unknown TupleType for " + (iIOImage.hasRaster() ? iIOImage.getRaster() : iIOImage.getRenderedImage()));
        }
        return tupleType;
    }
}

