/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.StandardImageMetadataSupport;
import com.twelvemonkeys.imageio.plugins.iff.Form;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.IndexColorModel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageTypeSpecifier;

final class IFFImageMetadata
extends StandardImageMetadataSupport {
    IFFImageMetadata(ImageTypeSpecifier imageTypeSpecifier, Form form, IndexColorModel indexColorModel) {
        this(IFFImageMetadata.builder(imageTypeSpecifier), Validate.notNull(form, "header"), indexColorModel);
    }

    private IFFImageMetadata(StandardImageMetadataSupport.Builder builder, Form form, IndexColorModel indexColorModel) {
        super(builder.withPalette(indexColorModel).withCompressionTypeName(IFFImageMetadata.compressionName(form)).withBitsPerSample(IFFImageMetadata.bitsPerSample(form)).withPlanarConfiguration(IFFImageMetadata.planarConfiguration(form)).withPixelAspectRatio(form.aspect() != 0.0 ? Double.valueOf(form.aspect()) : null).withFormatVersion("1.0").withTextEntries(IFFImageMetadata.textEntries(form)));
    }

    private static String compressionName(Form form) {
        switch (form.compressionType()) {
            case 0: {
                return "None";
            }
            case 1: {
                return "RLE";
            }
            case 4: {
                if (form.formType != 1380401720) break;
                return "RGB8";
            }
        }
        return "Unknown";
    }

    private static int[] bitsPerSample(Form form) {
        int n = form.bitplanes();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new int[]{n};
            }
            case 24: {
                return new int[]{8, 8, 8};
            }
            case 25: {
                if (form.formType != 1380401720) {
                    throw new IllegalArgumentException(String.format("25 bit depth only supported for FORM type RGB8: %s", IFFUtil.toChunkStr(form.formType)));
                }
                return new int[]{8, 8, 8, 1};
            }
            case 32: {
                return new int[]{8, 8, 8, 8};
            }
        }
        throw new IllegalArgumentException("Unknown bit count: " + n);
    }

    private static StandardImageMetadataSupport.PlanarConfiguration planarConfiguration(Form form) {
        switch (form.formType) {
            case 0x44454550: 
            case 1346522400: 
            case 1380401720: 
            case 1414942800: {
                return StandardImageMetadataSupport.PlanarConfiguration.PixelInterleaved;
            }
            case 1229734477: {
                return StandardImageMetadataSupport.PlanarConfiguration.PlaneInterleaved;
            }
        }
        return null;
    }

    private static List<StandardImageMetadataSupport.TextEntry> textEntries(Form form) {
        if (form.meta.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StandardImageMetadataSupport.TextEntry> arrayList = new ArrayList<StandardImageMetadataSupport.TextEntry>();
        for (GenericChunk genericChunk : form.meta) {
            arrayList.add(new StandardImageMetadataSupport.TextEntry(IFFUtil.toChunkStr(genericChunk.chunkId), new String(genericChunk.data, genericChunk.chunkId == 1431586360 ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII)));
        }
        return arrayList;
    }
}

