/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack;

import com.github.junrar.exception.RarException;
import com.github.junrar.unpack.ComprDataIO;
import com.github.junrar.unpack.Unpack20;
import com.github.junrar.unpack.UnpackFilter;
import com.github.junrar.unpack.ppm.BlockTypes;
import com.github.junrar.unpack.ppm.ModelPPM;
import com.github.junrar.unpack.ppm.SubAllocator;
import com.github.junrar.unpack.vm.BitInput;
import com.github.junrar.unpack.vm.RarVM;
import com.github.junrar.unpack.vm.VMPreparedProgram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class Unpack
extends Unpack20 {
    private final ModelPPM ppm = new ModelPPM();
    private int ppmEscChar;
    private final RarVM rarVM = new RarVM();
    private final List<UnpackFilter> filters = new ArrayList<UnpackFilter>();
    private final List<UnpackFilter> prgStack = new ArrayList<UnpackFilter>();
    private final List<Integer> oldFilterLengths = new ArrayList<Integer>();
    private int lastFilter;
    private boolean tablesRead;
    private final byte[] unpOldTable = new byte[404];
    private BlockTypes unpBlockType;
    private long writtenFileSize;
    private boolean fileExtracted;
    private boolean ppmError;
    private int prevLowDist;
    private int lowDistRepCount;
    public static int[] DBitLengthCounts = new int[]{4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 14, 0, 12};

    public Unpack(ComprDataIO DataIO) {
        this.unpIO = DataIO;
        this.window = null;
        this.suspended = false;
        this.unpAllBuf = false;
        this.unpSomeRead = false;
    }

    public void init(byte[] window) {
        this.window = window == null ? new byte[0x400000] : window;
        this.inAddr = 0;
        this.unpInitData(false);
    }

    public void doUnpack(int method, boolean solid) throws IOException, RarException {
        if (this.unpIO.getSubHeader().getUnpMethod() == 48) {
            this.unstoreFile();
        }
        switch (method) {
            case 15: {
                this.unpack15(solid);
                break;
            }
            case 20: 
            case 26: {
                this.unpack20(solid);
                break;
            }
            case 29: 
            case 36: {
                this.unpack29(solid);
            }
        }
    }

    private void unstoreFile() throws IOException, RarException {
        int code;
        byte[] buffer = new byte[65536];
        while ((code = this.unpIO.unpRead(buffer, 0, (int)Math.min((long)buffer.length, this.destUnpSize))) != 0 && code != -1) {
            code = (long)code < this.destUnpSize ? code : (int)this.destUnpSize;
            this.unpIO.unpWrite(buffer, 0, code);
            if (this.destUnpSize < 0L) continue;
            this.destUnpSize -= (long)code;
        }
    }

    private void unpack29(boolean solid) throws IOException, RarException {
        int[] DDecode = new int[60];
        byte[] DBits = new byte[60];
        if (DDecode[1] == 0) {
            int Dist = 0;
            int BitLength = 0;
            int Slot2 = 0;
            int I = 0;
            while (I < DBitLengthCounts.length) {
                int count = DBitLengthCounts[I];
                int J = 0;
                while (J < count) {
                    DDecode[Slot2] = Dist;
                    DBits[Slot2] = (byte)BitLength;
                    ++J;
                    ++Slot2;
                    Dist += 1 << BitLength;
                }
                ++I;
                ++BitLength;
            }
        }
        this.fileExtracted = true;
        if (!this.suspended) {
            this.unpInitData(solid);
            if (!this.unpReadBuf()) {
                return;
            }
            if (!(solid && this.tablesRead || this.readTables())) {
                return;
            }
        }
        if (this.ppmError) {
            return;
        }
        while (true) {
            int Bits2;
            int Distance;
            this.unpPtr &= 0x3FFFFF;
            if (this.inAddr > this.readBorder && !this.unpReadBuf()) break;
            if ((this.wrPtr - this.unpPtr & 0x3FFFFF) < 260 && this.wrPtr != this.unpPtr) {
                this.UnpWriteBuf();
                if (this.writtenFileSize > this.destUnpSize) {
                    return;
                }
                if (this.suspended) {
                    this.fileExtracted = false;
                    return;
                }
            }
            if (this.unpBlockType == BlockTypes.BLOCK_PPM) {
                int Ch = this.ppm.decodeChar();
                if (Ch == -1) {
                    this.ppmError = true;
                    break;
                }
                if (Ch == this.ppmEscChar) {
                    int NextCh = this.ppm.decodeChar();
                    if (NextCh == 0) {
                        if (this.readTables()) continue;
                        break;
                    }
                    if (NextCh == 2 || NextCh == -1) break;
                    if (NextCh == 3) {
                        if (this.readVMCodePPM()) continue;
                        break;
                    }
                    if (NextCh == 4) {
                        Distance = 0;
                        int Length2 = 0;
                        boolean failed = false;
                        for (int I = 0; I < 4 && !failed; ++I) {
                            int ch = this.ppm.decodeChar();
                            if (ch == -1) {
                                failed = true;
                                continue;
                            }
                            if (I == 3) {
                                Length2 = ch & 0xFF;
                                continue;
                            }
                            Distance = (Distance << 8) + (ch & 0xFF);
                        }
                        if (failed) break;
                        this.copyString(Length2 + 32, Distance + 2);
                        continue;
                    }
                    if (NextCh == 5) {
                        int Length3 = this.ppm.decodeChar();
                        if (Length3 == -1) break;
                        this.copyString(Length3 + 4, 1);
                        continue;
                    }
                }
                this.window[this.unpPtr++] = (byte)Ch;
                continue;
            }
            int Number2 = this.decodeNumber(this.LD);
            if (Number2 < 256) {
                this.window[this.unpPtr++] = (byte)Number2;
                continue;
            }
            if (Number2 >= 271) {
                int Length4 = LDecode[Number2 -= 271] + 3;
                Bits2 = LBits[Number2];
                if (Bits2 > 0) {
                    Length4 += this.getbits() >>> 16 - Bits2;
                    this.addbits(Bits2);
                }
                int DistNumber = this.decodeNumber(this.DD);
                int Distance2 = DDecode[DistNumber] + 1;
                Bits2 = DBits[DistNumber];
                if (Bits2 > 0) {
                    if (DistNumber > 9) {
                        if (Bits2 > 4) {
                            Distance2 += this.getbits() >>> 20 - Bits2 << 4;
                            this.addbits(Bits2 - 4);
                        }
                        if (this.lowDistRepCount > 0) {
                            --this.lowDistRepCount;
                            Distance2 += this.prevLowDist;
                        } else {
                            int LowDist = this.decodeNumber(this.LDD);
                            if (LowDist == 16) {
                                this.lowDistRepCount = 15;
                                Distance2 += this.prevLowDist;
                            } else {
                                Distance2 += LowDist;
                                this.prevLowDist = LowDist;
                            }
                        }
                    } else {
                        Distance2 += this.getbits() >>> 16 - Bits2;
                        this.addbits(Bits2);
                    }
                }
                if (Distance2 >= 8192) {
                    ++Length4;
                    if ((long)Distance2 >= 262144L) {
                        ++Length4;
                    }
                }
                this.insertOldDist(Distance2);
                this.insertLastMatch(Length4, Distance2);
                this.copyString(Length4, Distance2);
                continue;
            }
            if (Number2 == 256) {
                if (this.readEndOfBlock()) continue;
                break;
            }
            if (Number2 == 257) {
                if (this.readVMCode()) continue;
                break;
            }
            if (Number2 == 258) {
                if (this.lastLength == 0) continue;
                this.copyString(this.lastLength, this.lastDist);
                continue;
            }
            if (Number2 < 263) {
                int DistNum = Number2 - 259;
                Distance = this.oldDist[DistNum];
                System.arraycopy(this.oldDist, 0, this.oldDist, 1, DistNum);
                this.oldDist[0] = Distance;
                int LengthNumber = this.decodeNumber(this.RD);
                int Length5 = LDecode[LengthNumber] + 2;
                Bits2 = LBits[LengthNumber];
                if (Bits2 > 0) {
                    Length5 += this.getbits() >>> 16 - Bits2;
                    this.addbits(Bits2);
                }
                this.insertLastMatch(Length5, Distance);
                this.copyString(Length5, Distance);
                continue;
            }
            if (Number2 >= 272) continue;
            int Distance3 = SDDecode[Number2 -= 263] + 1;
            Bits2 = SDBits[Number2];
            if (Bits2 > 0) {
                Distance3 += this.getbits() >>> 16 - Bits2;
                this.addbits(Bits2);
            }
            this.insertOldDist(Distance3);
            this.insertLastMatch(2, Distance3);
            this.copyString(2, Distance3);
        }
        this.UnpWriteBuf();
    }

    private void UnpWriteBuf() throws IOException {
        int WrittenBorder = this.wrPtr;
        int WriteSize = this.unpPtr - WrittenBorder & 0x3FFFFF;
        for (int I = 0; I < this.prgStack.size(); ++I) {
            UnpackFilter flt = this.prgStack.get(I);
            if (flt == null) continue;
            if (flt.isNextWindow()) {
                flt.setNextWindow(false);
                continue;
            }
            int BlockStart = flt.getBlockStart();
            int BlockLength = flt.getBlockLength();
            if ((BlockStart - WrittenBorder & 0x3FFFFF) >= WriteSize) continue;
            if (WrittenBorder != BlockStart) {
                this.UnpWriteArea(WrittenBorder, BlockStart);
                WrittenBorder = BlockStart;
                WriteSize = this.unpPtr - WrittenBorder & 0x3FFFFF;
            }
            if (BlockLength <= WriteSize) {
                UnpackFilter NextFilter;
                int i;
                int BlockEnd = BlockStart + BlockLength & 0x3FFFFF;
                if (BlockStart < BlockEnd || BlockEnd == 0) {
                    this.rarVM.setMemory(0, this.window, BlockStart, BlockLength);
                } else {
                    int FirstPartLength = 0x400000 - BlockStart;
                    this.rarVM.setMemory(0, this.window, BlockStart, FirstPartLength);
                    this.rarVM.setMemory(FirstPartLength, this.window, 0, BlockEnd);
                }
                VMPreparedProgram ParentPrg = this.filters.get(flt.getParentFilter()).getPrg();
                VMPreparedProgram Prg = flt.getPrg();
                if (ParentPrg.getGlobalData().size() > 64) {
                    Prg.getGlobalData().setSize(ParentPrg.getGlobalData().size());
                    for (i = 0; i < ParentPrg.getGlobalData().size() - 64; ++i) {
                        Prg.getGlobalData().set(64 + i, ParentPrg.getGlobalData().get(64 + i));
                    }
                }
                this.ExecuteCode(Prg);
                if (Prg.getGlobalData().size() > 64) {
                    if (ParentPrg.getGlobalData().size() < Prg.getGlobalData().size()) {
                        ParentPrg.getGlobalData().setSize(Prg.getGlobalData().size());
                    }
                    for (i = 0; i < Prg.getGlobalData().size() - 64; ++i) {
                        ParentPrg.getGlobalData().set(64 + i, Prg.getGlobalData().get(64 + i));
                    }
                } else {
                    ParentPrg.getGlobalData().clear();
                }
                int FilteredDataOffset = Prg.getFilteredDataOffset();
                int FilteredDataSize = Prg.getFilteredDataSize();
                byte[] FilteredData = new byte[FilteredDataSize];
                for (int i2 = 0; i2 < FilteredDataSize; ++i2) {
                    FilteredData[i2] = this.rarVM.getMem()[FilteredDataOffset + i2];
                }
                this.prgStack.set(I, null);
                while (I + 1 < this.prgStack.size() && (NextFilter = this.prgStack.get(I + 1)) != null && NextFilter.getBlockStart() == BlockStart && NextFilter.getBlockLength() == FilteredDataSize && !NextFilter.isNextWindow()) {
                    int i3;
                    this.rarVM.setMemory(0, FilteredData, 0, FilteredDataSize);
                    VMPreparedProgram pPrg = this.filters.get(NextFilter.getParentFilter()).getPrg();
                    VMPreparedProgram NextPrg = NextFilter.getPrg();
                    if (pPrg.getGlobalData().size() > 64) {
                        NextPrg.getGlobalData().setSize(pPrg.getGlobalData().size());
                        for (i3 = 0; i3 < pPrg.getGlobalData().size() - 64; ++i3) {
                            NextPrg.getGlobalData().set(64 + i3, pPrg.getGlobalData().get(64 + i3));
                        }
                    }
                    this.ExecuteCode(NextPrg);
                    if (NextPrg.getGlobalData().size() > 64) {
                        if (pPrg.getGlobalData().size() < NextPrg.getGlobalData().size()) {
                            pPrg.getGlobalData().setSize(NextPrg.getGlobalData().size());
                        }
                        for (i3 = 0; i3 < NextPrg.getGlobalData().size() - 64; ++i3) {
                            pPrg.getGlobalData().set(64 + i3, NextPrg.getGlobalData().get(64 + i3));
                        }
                    } else {
                        pPrg.getGlobalData().clear();
                    }
                    FilteredDataOffset = NextPrg.getFilteredDataOffset();
                    FilteredDataSize = NextPrg.getFilteredDataSize();
                    FilteredData = new byte[FilteredDataSize];
                    for (i3 = 0; i3 < FilteredDataSize; ++i3) {
                        FilteredData[i3] = NextPrg.getGlobalData().get(FilteredDataOffset + i3);
                    }
                    this.prgStack.set(++I, null);
                }
                this.unpIO.unpWrite(FilteredData, 0, FilteredDataSize);
                this.unpSomeRead = true;
                this.writtenFileSize += (long)FilteredDataSize;
                WrittenBorder = BlockEnd;
                WriteSize = this.unpPtr - WrittenBorder & 0x3FFFFF;
                continue;
            }
            for (int J = I; J < this.prgStack.size(); ++J) {
                UnpackFilter filt = this.prgStack.get(J);
                if (filt == null || !filt.isNextWindow()) continue;
                filt.setNextWindow(false);
            }
            this.wrPtr = WrittenBorder;
            return;
        }
        this.UnpWriteArea(WrittenBorder, this.unpPtr);
        this.wrPtr = this.unpPtr;
    }

    private void UnpWriteArea(int startPtr, int endPtr) throws IOException {
        if (endPtr != startPtr) {
            this.unpSomeRead = true;
        }
        if (endPtr < startPtr) {
            this.UnpWriteData(this.window, startPtr, -startPtr & 0x3FFFFF);
            this.UnpWriteData(this.window, 0, endPtr);
            this.unpAllBuf = true;
        } else {
            this.UnpWriteData(this.window, startPtr, endPtr - startPtr);
        }
    }

    private void UnpWriteData(byte[] data, int offset, int size) throws IOException {
        if (this.writtenFileSize >= this.destUnpSize) {
            return;
        }
        int writeSize = size;
        long leftToWrite = this.destUnpSize - this.writtenFileSize;
        if ((long)writeSize > leftToWrite) {
            writeSize = (int)leftToWrite;
        }
        this.unpIO.unpWrite(data, offset, writeSize);
        this.writtenFileSize += (long)size;
    }

    private void insertOldDist(int distance) {
        this.oldDist[3] = this.oldDist[2];
        this.oldDist[2] = this.oldDist[1];
        this.oldDist[1] = this.oldDist[0];
        this.oldDist[0] = distance;
    }

    private void insertLastMatch(int length, int distance) {
        this.lastDist = distance;
        this.lastLength = length;
    }

    private void copyString(int length, int distance) {
        int destPtr = this.unpPtr - distance;
        if (destPtr >= 0 && destPtr < 4194044 && this.unpPtr < 4194044) {
            if (distance == 1) {
                Arrays.fill(this.window, this.unpPtr, this.unpPtr + length, this.window[destPtr]);
                this.unpPtr += length;
                destPtr += length;
                length = 0;
            } else if (destPtr + length <= this.unpPtr) {
                System.arraycopy(this.window, destPtr, this.window, this.unpPtr, length);
                this.unpPtr += length;
                destPtr += length;
                length = 0;
            } else {
                do {
                    this.window[this.unpPtr++] = this.window[destPtr++];
                } while (--length > 0);
            }
        } else {
            while (length-- != 0) {
                this.window[this.unpPtr] = this.window[destPtr++ & 0x3FFFFF];
                this.unpPtr = this.unpPtr + 1 & 0x3FFFFF;
            }
        }
    }

    @Override
    protected void unpInitData(boolean solid) {
        if (!solid) {
            this.tablesRead = false;
            Arrays.fill(this.oldDist, 0);
            this.oldDistPtr = 0;
            this.lastDist = 0;
            this.lastLength = 0;
            Arrays.fill(this.unpOldTable, (byte)0);
            this.unpPtr = 0;
            this.wrPtr = 0;
            this.ppmEscChar = 2;
            this.initFilters();
        }
        this.InitBitInput();
        this.ppmError = false;
        this.writtenFileSize = 0L;
        this.readTop = 0;
        this.readBorder = 0;
        this.unpInitData20(solid);
    }

    private void initFilters() {
        this.oldFilterLengths.clear();
        this.lastFilter = 0;
        this.filters.clear();
        this.prgStack.clear();
    }

    private boolean readEndOfBlock() throws IOException, RarException {
        boolean NewTable;
        int BitField2 = this.getbits();
        boolean NewFile = false;
        if ((BitField2 & 0x8000) != 0) {
            NewTable = true;
            this.addbits(1);
        } else {
            NewFile = true;
            NewTable = (BitField2 & 0x4000) != 0;
            this.addbits(2);
        }
        this.tablesRead = !NewTable;
        return !NewFile && (!NewTable || this.readTables());
    }

    private boolean readTables() throws IOException, RarException {
        byte[] bitLength = new byte[20];
        byte[] table = new byte[404];
        if (this.inAddr > this.readTop - 25 && !this.unpReadBuf()) {
            return false;
        }
        this.faddbits(8 - this.inBit & 7);
        long bitField = this.fgetbits() & 0xFFFFFFFF;
        if ((bitField & 0x8000L) != 0L) {
            this.unpBlockType = BlockTypes.BLOCK_PPM;
            return this.ppm.decodeInit(this, this.ppmEscChar);
        }
        this.unpBlockType = BlockTypes.BLOCK_LZ;
        this.prevLowDist = 0;
        this.lowDistRepCount = 0;
        if ((bitField & 0x4000L) == 0L) {
            Arrays.fill(this.unpOldTable, (byte)0);
        }
        this.faddbits(2);
        for (int i = 0; i < 20; ++i) {
            int length = this.fgetbits() >>> 12 & 0xFF;
            this.faddbits(4);
            if (length == 15) {
                int zeroCount = this.fgetbits() >>> 12 & 0xFF;
                this.faddbits(4);
                if (zeroCount == 0) {
                    bitLength[i] = 15;
                    continue;
                }
                zeroCount += 2;
                while (zeroCount-- > 0 && i < bitLength.length) {
                    bitLength[i++] = 0;
                }
                --i;
                continue;
            }
            bitLength[i] = (byte)length;
        }
        this.makeDecodeTables(bitLength, 0, this.BD, 20);
        int TableSize = 404;
        int i = 0;
        while (i < TableSize) {
            int N;
            if (this.inAddr > this.readTop - 5 && !this.unpReadBuf()) {
                return false;
            }
            int Number2 = this.decodeNumber(this.BD);
            if (Number2 < 16) {
                table[i] = (byte)(Number2 + this.unpOldTable[i] & 0xF);
                ++i;
                continue;
            }
            if (Number2 < 18) {
                if (Number2 == 16) {
                    N = (this.fgetbits() >>> 13) + 3;
                    this.faddbits(3);
                } else {
                    N = (this.fgetbits() >>> 9) + 11;
                    this.faddbits(7);
                }
                while (N-- > 0 && i < TableSize) {
                    table[i] = table[i - 1];
                    ++i;
                }
                continue;
            }
            if (Number2 == 18) {
                N = (this.fgetbits() >>> 13) + 3;
                this.faddbits(3);
            } else {
                N = (this.fgetbits() >>> 9) + 11;
                this.faddbits(7);
            }
            while (N-- > 0 && i < TableSize) {
                table[i++] = 0;
            }
        }
        this.tablesRead = true;
        if (this.inAddr > this.readTop) {
            return false;
        }
        this.makeDecodeTables(table, 0, this.LD, 299);
        this.makeDecodeTables(table, 299, this.DD, 60);
        this.makeDecodeTables(table, 359, this.LDD, 17);
        this.makeDecodeTables(table, 376, this.RD, 28);
        System.arraycopy(table, 0, this.unpOldTable, 0, this.unpOldTable.length);
        return true;
    }

    private boolean readVMCode() throws IOException, RarException {
        int FirstByte = this.getbits() >>> 8;
        this.addbits(8);
        int Length2 = (FirstByte & 7) + 1;
        if (Length2 == 7) {
            Length2 = (this.getbits() >>> 8) + 7;
            this.addbits(8);
        } else if (Length2 == 8) {
            Length2 = this.getbits();
            this.addbits(16);
        }
        ArrayList<Byte> vmCode = new ArrayList<Byte>();
        for (int I = 0; I < Length2; ++I) {
            if (this.inAddr >= this.readTop - 1 && !this.unpReadBuf() && I < Length2 - 1) {
                return false;
            }
            vmCode.add((byte)(this.getbits() >>> 8));
            this.addbits(8);
        }
        return this.addVMCode(FirstByte, vmCode, Length2);
    }

    private boolean readVMCodePPM() throws IOException, RarException {
        int B1;
        int FirstByte = this.ppm.decodeChar();
        if (FirstByte == -1) {
            return false;
        }
        int Length2 = (FirstByte & 7) + 1;
        if (Length2 == 7) {
            B1 = this.ppm.decodeChar();
            if (B1 == -1) {
                return false;
            }
            Length2 = B1 + 7;
        } else if (Length2 == 8) {
            B1 = this.ppm.decodeChar();
            if (B1 == -1) {
                return false;
            }
            int B2 = this.ppm.decodeChar();
            if (B2 == -1) {
                return false;
            }
            Length2 = B1 * 256 + B2;
        }
        ArrayList<Byte> vmCode = new ArrayList<Byte>();
        for (int I = 0; I < Length2; ++I) {
            int Ch = this.ppm.decodeChar();
            if (Ch == -1) {
                return false;
            }
            vmCode.add((byte)Ch);
        }
        return this.addVMCode(FirstByte, vmCode, Length2);
    }

    private boolean addVMCode(int firstByte, List<Byte> vmCode, int length) {
        int I;
        UnpackFilter Filter2;
        int FiltPos;
        BitInput Inp = new BitInput();
        Inp.InitBitInput();
        for (int i = 0; i < Math.min(32768, vmCode.size()); ++i) {
            Inp.getInBuf()[i] = vmCode.get(i);
        }
        this.rarVM.init();
        if ((firstByte & 0x80) != 0) {
            FiltPos = RarVM.ReadData(Inp);
            if (FiltPos == 0) {
                this.initFilters();
            } else {
                --FiltPos;
            }
        } else {
            FiltPos = this.lastFilter;
        }
        if (FiltPos > this.filters.size() || FiltPos > this.oldFilterLengths.size()) {
            return false;
        }
        this.lastFilter = FiltPos;
        boolean NewFilter = FiltPos == this.filters.size();
        UnpackFilter StackFilter = new UnpackFilter();
        if (NewFilter) {
            if (FiltPos > 1024) {
                return false;
            }
            Filter2 = new UnpackFilter();
            this.filters.add(Filter2);
            StackFilter.setParentFilter(this.filters.size() - 1);
            this.oldFilterLengths.add(0);
            Filter2.setExecCount(0);
        } else {
            Filter2 = this.filters.get(FiltPos);
            StackFilter.setParentFilter(FiltPos);
            Filter2.setExecCount(Filter2.getExecCount() + 1);
        }
        this.prgStack.add(StackFilter);
        StackFilter.setExecCount(Filter2.getExecCount());
        int BlockStart = RarVM.ReadData(Inp);
        if ((firstByte & 0x40) != 0) {
            BlockStart += 258;
        }
        StackFilter.setBlockStart(BlockStart + this.unpPtr & 0x3FFFFF);
        if ((firstByte & 0x20) != 0) {
            StackFilter.setBlockLength(RarVM.ReadData(Inp));
        } else {
            StackFilter.setBlockLength(FiltPos < this.oldFilterLengths.size() ? this.oldFilterLengths.get(FiltPos) : 0);
        }
        StackFilter.setNextWindow(this.wrPtr != this.unpPtr && (this.wrPtr - this.unpPtr & 0x3FFFFF) <= BlockStart);
        this.oldFilterLengths.set(FiltPos, StackFilter.getBlockLength());
        Arrays.fill(StackFilter.getPrg().getInitR(), 0);
        StackFilter.getPrg().getInitR()[3] = 245760;
        StackFilter.getPrg().getInitR()[4] = StackFilter.getBlockLength();
        StackFilter.getPrg().getInitR()[5] = StackFilter.getExecCount();
        if ((firstByte & 0x10) != 0) {
            int InitMask = Inp.fgetbits() >>> 9;
            Inp.faddbits(7);
            for (int I2 = 0; I2 < 7; ++I2) {
                if ((InitMask & 1 << I2) == 0) continue;
                StackFilter.getPrg().getInitR()[I2] = RarVM.ReadData(Inp);
            }
        }
        if (NewFilter) {
            int VMCodeSize = RarVM.ReadData(Inp);
            if (VMCodeSize >= 65536 || VMCodeSize == 0) {
                return false;
            }
            byte[] VMCode = new byte[VMCodeSize];
            for (I = 0; I < VMCodeSize; ++I) {
                if (Inp.Overflow(3)) {
                    return false;
                }
                VMCode[I] = (byte)(Inp.fgetbits() >>> 8);
                Inp.faddbits(8);
            }
            this.rarVM.prepare(VMCode, VMCodeSize, Filter2.getPrg());
        }
        StackFilter.getPrg().setAltCmd(Filter2.getPrg().getCmd());
        StackFilter.getPrg().setCmdCount(Filter2.getPrg().getCmdCount());
        int StaticDataSize = Filter2.getPrg().getStaticData().size();
        if (StaticDataSize > 0 && StaticDataSize < 8192) {
            StackFilter.getPrg().setStaticData(Filter2.getPrg().getStaticData());
        }
        if (StackFilter.getPrg().getGlobalData().size() < 64) {
            StackFilter.getPrg().getGlobalData().clear();
            StackFilter.getPrg().getGlobalData().setSize(64);
        }
        Vector<Byte> globalData = StackFilter.getPrg().getGlobalData();
        for (I = 0; I < 7; ++I) {
            this.rarVM.setLowEndianValue(globalData, I * 4, StackFilter.getPrg().getInitR()[I]);
        }
        this.rarVM.setLowEndianValue(globalData, 28, StackFilter.getBlockLength());
        this.rarVM.setLowEndianValue(globalData, 32, 0);
        this.rarVM.setLowEndianValue(globalData, 36, 0);
        this.rarVM.setLowEndianValue(globalData, 40, 0);
        this.rarVM.setLowEndianValue(globalData, 44, StackFilter.getExecCount());
        for (int i = 0; i < 16; ++i) {
            globalData.set(48 + i, (byte)0);
        }
        if ((firstByte & 8) != 0) {
            if (Inp.Overflow(3)) {
                return false;
            }
            int DataSize = RarVM.ReadData(Inp);
            if (DataSize > 8128) {
                return false;
            }
            int CurSize = StackFilter.getPrg().getGlobalData().size();
            if (CurSize < DataSize + 64) {
                StackFilter.getPrg().getGlobalData().setSize(DataSize + 64 - CurSize);
            }
            int offset = 64;
            globalData = StackFilter.getPrg().getGlobalData();
            for (int I3 = 0; I3 < DataSize; ++I3) {
                if (Inp.Overflow(3)) {
                    return false;
                }
                globalData.set(offset + I3, (byte)(Inp.fgetbits() >>> 8));
                Inp.faddbits(8);
            }
        }
        return true;
    }

    private void ExecuteCode(VMPreparedProgram Prg) {
        if (Prg.getGlobalData().size() > 0) {
            Prg.getInitR()[6] = (int)this.writtenFileSize;
            this.rarVM.setLowEndianValue(Prg.getGlobalData(), 36, (int)this.writtenFileSize);
            this.rarVM.setLowEndianValue(Prg.getGlobalData(), 40, (int)(this.writtenFileSize >>> 32));
            this.rarVM.execute(Prg);
        }
    }

    public boolean isFileExtracted() {
        return this.fileExtracted;
    }

    public void setDestSize(long destSize) {
        this.destUnpSize = destSize;
        this.fileExtracted = false;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public int getChar() throws IOException, RarException {
        if (this.inAddr > 32738) {
            this.unpReadBuf();
        }
        return this.inBuf[this.inAddr++] & 0xFF;
    }

    public int getPpmEscChar() {
        return this.ppmEscChar;
    }

    public void setPpmEscChar(int ppmEscChar) {
        this.ppmEscChar = ppmEscChar;
    }

    public void cleanUp() {
        SubAllocator allocator;
        if (this.ppm != null && (allocator = this.ppm.getSubAlloc()) != null) {
            allocator.stopSubAllocator();
        }
    }
}

