########## BEGIN OF base.py ##########
# This file is a part of SmoothVideo Project (SVP) ver.4
# This is NOT the full Vapoursynth script, all used variables are defined via
# JScript code that generates the full script text.

def interpolate(clip):
#RESIZE-CODE
    if nvof:
        smooth  = core.svp2.SmoothFps_NVOF(input_m,smoothfps_params,vec_src=input_m8,src=input_um,fps=src_fps)
    elif not rife: 
        super   = core.svp1.Super(input_m8,super_params)
        vectors = core.svp1.Analyse(super["clip"],super["data"],input_m8,analyse_params)
        smooth  = core.svp2.SmoothFps(input_m,super["clip"],super["data"],vectors["clip"],vectors["data"],smoothfps_params,src=input_um,fps=src_fps)
    elif rife:
        input_rife = input_m.resize.Bicubic(format=rife_fmt,matrix_in_s=rife_matrix,range_in=rife_range)
        if not rife_trt:
            smooth = core.rife.RIFE(input_rife,factor_num=rife_num,factor_den=rife_den,model_path=rife_mpath,gpu_id=rife_gpu,gpu_thread=rife_threads,tta=False,sc=False)
        else:
            smooth = RIFE_imp(input_rife,multi=rife_num,model=rife_mnum,backend=trt_backend)
            if rife_den>1:
                smooth = smooth.std.SelectEvery(cycle=rife_den,offsets=0)
        smooth = smooth.resize.Point(format=input_um.format.id,matrix_s=rife_matrix,range=rife_range)
#RESIZE-BACK
        smooth = core.svp2.SmoothFps_RIFE(input_m,smoothfps_params,rife_out=smooth,vec_src=vec_src,vdata=vdata,src=input_um,fps=src_fps)
#FORCE-CFR
    if demo_mode==1:
        return demo(input_m,smooth)
    else:
        return smooth

if stereo_type == 1:
    lf = interpolate(core.std.CropRel(clip,0,(int)(clip.width/2),0,0))
    rf = interpolate(core.std.CropRel(clip,(int)(clip.width/2),0,0,0))
    smooth = core.std.StackHorizontal([lf, rf])
elif stereo_type == 2:
    lf = interpolate(core.std.CropRel(clip,0,0,0,(int)(clip.height/2)))
    rf = interpolate(core.std.CropRel(clip,0,0,(int)(clip.height/2),0))
    smooth = core.std.StackVertical([lf, rf])
else:
    smooth =  interpolate(clip)
########### END OF base.py ###########
