/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;

public class WSKnownHosts {
    private File userWebSpaKnownHostsFile;

    public WSKnownHosts() {
        String userWebSpaKnownHostsFileName = System.getProperty("user.home") + File.separator + ".webspa" + File.separator + "known_hosts";
        this.userWebSpaKnownHostsFile = new File(userWebSpaKnownHostsFileName);
    }

    public boolean checkKnownHost(URL url, String fingerprint) {
        boolean knownHost = false;
        if (this.userWebSpaKnownHostsFile.exists()) {
            try {
                String line;
                FileReader fr = new FileReader(this.userWebSpaKnownHostsFile);
                BufferedReader br = new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    String[] urlHash = line.split("=");
                    if (url.getHost() != urlHash[0] || fingerprint != urlHash[1]) continue;
                    knownHost = true;
                    break;
                }
                br.close();
                fr.close();
            }
            catch (FileNotFoundException fnfEx) {
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        return knownHost;
    }

    public void addKnownHost(URL url, String fingerprint) {
    }
}

