/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;
import net.seleucus.wsp.util.WSUtil;

public class WSUserActivate
extends WSCommandOption {
    public WSUserActivate(WSServer myServer) {
        super(myServer);
    }

    @Override
    protected void execute() {
        String users = this.myServer.getWSDatabase().users.showUsers();
        this.myServer.println(users);
        int ppID = this.myServer.readLineOptionalInt("Select a User ID");
        boolean userIDFound = this.myServer.getWSDatabase().passPhrases.isPPIDInUse(ppID);
        if (!userIDFound) {
            this.myServer.println("User ID Not Found");
        } else {
            String oldPPIDStatus = this.myServer.getWSDatabase().passPhrases.getActivationStatusString(ppID);
            this.myServer.println(oldPPIDStatus);
            String choice = this.myServer.readLineOptional("Toggle user activation [Y/n]");
            if (WSUtil.isAnswerPositive(choice) || choice.isEmpty()) {
                this.myServer.getWSDatabase().passPhrases.toggleUserActivation(ppID);
            }
            String newPPIDStatus = this.myServer.getWSDatabase().passPhrases.getActivationStatusString(ppID);
            this.myServer.println(newPPIDStatus);
        }
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        boolean valid = false;
        if (cmd.equalsIgnoreCase("user activate")) {
            valid = true;
        }
        return valid;
    }
}

